/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.util.MathHelper;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;

public final class OreVeinifier {
    private static final float VEININESS_THRESHOLD = 0.4f;
    private static final int EDGE_ROUNDOFF_BEGIN = 20;
    private static final double MAX_EDGE_ROUNDOFF = 0.2;
    private static final float VEIN_SOLIDNESS = 0.7f;
    private static final float MIN_RICHNESS = 0.1f;
    private static final float MAX_RICHNESS = 0.3f;
    private static final float MAX_RICHNESS_THRESHOLD = 0.6f;
    private static final float CHANCE_OF_RAW_ORE_BLOCK = 0.02f;
    private static final float SKIP_ORE_IF_GAP_NOISE_IS_BELOW = -0.3f;

    private OreVeinifier() {
    }

    protected static NoiseChunk.c create(DensityFunction var0, DensityFunction var1, DensityFunction var2, PositionalRandomFactory var3) {
        IBlockData var4 = null;
        return var5 -> {
            double var6 = var0.compute(var5);
            int var8 = var5.blockY();
            a var9 = var6 > 0.0 ? a.COPPER : a.IRON;
            double var10 = Math.abs(var6);
            int var12 = var9.maxY - var8;
            int var13 = var8 - var9.minY;
            if (var13 < 0 || var12 < 0) {
                return var4;
            }
            int var14 = Math.min(var12, var13);
            double var15 = MathHelper.clampedMap((double)var14, 0.0, 20.0, -0.2, 0.0);
            if (var10 + var15 < (double)0.4f) {
                return var4;
            }
            RandomSource var17 = var3.at(var5.blockX(), var8, var5.blockZ());
            if (var17.nextFloat() > 0.7f) {
                return var4;
            }
            if (var1.compute(var5) >= 0.0) {
                return var4;
            }
            double var18 = MathHelper.clampedMap(var10, (double)0.4f, (double)0.6f, (double)0.1f, (double)0.3f);
            if ((double)var17.nextFloat() < var18 && var2.compute(var5) > (double)-0.3f) {
                return var17.nextFloat() < 0.02f ? var9.rawOreBlock : var9.ore;
            }
            return var9.filler;
        };
    }

    protected static final class a
    extends Enum<a> {
        public static final /* enum */ a COPPER = new a(Blocks.COPPER_ORE.defaultBlockState(), Blocks.RAW_COPPER_BLOCK.defaultBlockState(), Blocks.GRANITE.defaultBlockState(), 0, 50);
        public static final /* enum */ a IRON = new a(Blocks.DEEPSLATE_IRON_ORE.defaultBlockState(), Blocks.RAW_IRON_BLOCK.defaultBlockState(), Blocks.TUFF.defaultBlockState(), -60, -8);
        final IBlockData ore;
        final IBlockData rawOreBlock;
        final IBlockData filler;
        protected final int minY;
        protected final int maxY;
        private static final /* synthetic */ a[] h;

        public static a[] values() {
            return (a[])h.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(IBlockData var2, IBlockData var3, IBlockData var4, int var5, int var6) {
            this.ore = var2;
            this.rawOreBlock = var3;
            this.filler = var4;
            this.minY = var5;
            this.maxY = var6;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{COPPER, IRON};
        }

        static {
            h = a.a();
        }
    }
}

