/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterWithOnlyNoises;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public class NoiseRouterData {
    private static final float ORE_THICKNESS = 0.08f;
    private static final double VEININESS_FREQUENCY = 1.5;
    private static final double NOODLE_SPACING_AND_STRAIGHTNESS = 1.5;
    private static final double SURFACE_DENSITY_THRESHOLD = 1.5625;
    private static final DensityFunction BLENDING_FACTOR = DensityFunctions.constant(10.0);
    private static final DensityFunction BLENDING_JAGGEDNESS = DensityFunctions.zero();
    private static final ResourceKey<DensityFunction> ZERO = NoiseRouterData.createKey("zero");
    private static final ResourceKey<DensityFunction> Y = NoiseRouterData.createKey("y");
    private static final ResourceKey<DensityFunction> SHIFT_X = NoiseRouterData.createKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = NoiseRouterData.createKey("shift_z");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE = NoiseRouterData.createKey("overworld/base_3d_noise");
    private static final ResourceKey<DensityFunction> CONTINENTS = NoiseRouterData.createKey("overworld/continents");
    private static final ResourceKey<DensityFunction> EROSION = NoiseRouterData.createKey("overworld/erosion");
    private static final ResourceKey<DensityFunction> RIDGES = NoiseRouterData.createKey("overworld/ridges");
    private static final ResourceKey<DensityFunction> FACTOR = NoiseRouterData.createKey("overworld/factor");
    private static final ResourceKey<DensityFunction> DEPTH = NoiseRouterData.createKey("overworld/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE = NoiseRouterData.createKey("overworld/sloped_cheese");
    private static final ResourceKey<DensityFunction> CONTINENTS_LARGE = NoiseRouterData.createKey("overworld_large_biomes/continents");
    private static final ResourceKey<DensityFunction> EROSION_LARGE = NoiseRouterData.createKey("overworld_large_biomes/erosion");
    private static final ResourceKey<DensityFunction> FACTOR_LARGE = NoiseRouterData.createKey("overworld_large_biomes/factor");
    private static final ResourceKey<DensityFunction> DEPTH_LARGE = NoiseRouterData.createKey("overworld_large_biomes/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_LARGE = NoiseRouterData.createKey("overworld_large_biomes/sloped_cheese");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_END = NoiseRouterData.createKey("end/sloped_cheese");
    private static final ResourceKey<DensityFunction> SPAGHETTI_ROUGHNESS_FUNCTION = NoiseRouterData.createKey("overworld/caves/spaghetti_roughness_function");
    private static final ResourceKey<DensityFunction> ENTRANCES = NoiseRouterData.createKey("overworld/caves/entrances");
    private static final ResourceKey<DensityFunction> NOODLE = NoiseRouterData.createKey("overworld/caves/noodle");
    private static final ResourceKey<DensityFunction> PILLARS = NoiseRouterData.createKey("overworld/caves/pillars");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D_THICKNESS_MODULATOR = NoiseRouterData.createKey("overworld/caves/spaghetti_2d_thickness_modulator");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D = NoiseRouterData.createKey("overworld/caves/spaghetti_2d");

    protected static NoiseRouterWithOnlyNoises overworld(NoiseSettings var0, boolean var1) {
        return NoiseRouterData.overworldWithNewCaves(var0, var1);
    }

    private static ResourceKey<DensityFunction> createKey(String var0) {
        return ResourceKey.create(IRegistry.DENSITY_FUNCTION_REGISTRY, new MinecraftKey(var0));
    }

    public static Holder<? extends DensityFunction> bootstrap() {
        NoiseRouterData.register(ZERO, DensityFunctions.zero());
        int var0 = DimensionManager.MIN_Y * 2;
        int var1 = DimensionManager.MAX_Y * 2;
        NoiseRouterData.register(Y, DensityFunctions.yClampedGradient(var0, var1, var0, var1));
        DensityFunction var2 = NoiseRouterData.register(SHIFT_X, DensityFunctions.flatCache(DensityFunctions.cache2d(DensityFunctions.shiftA(NoiseRouterData.getNoise(Noises.SHIFT)))));
        DensityFunction var3 = NoiseRouterData.register(SHIFT_Z, DensityFunctions.flatCache(DensityFunctions.cache2d(DensityFunctions.shiftB(NoiseRouterData.getNoise(Noises.SHIFT)))));
        NoiseRouterData.register(BASE_3D_NOISE, BlendedNoise.UNSEEDED);
        DensityFunction var4 = NoiseRouterData.register(CONTINENTS, DensityFunctions.flatCache(DensityFunctions.shiftedNoise2d(var2, var3, 0.25, NoiseRouterData.getNoise(Noises.CONTINENTALNESS))));
        DensityFunction var5 = NoiseRouterData.register(EROSION, DensityFunctions.flatCache(DensityFunctions.shiftedNoise2d(var2, var3, 0.25, NoiseRouterData.getNoise(Noises.EROSION))));
        DensityFunction var6 = NoiseRouterData.register(RIDGES, DensityFunctions.flatCache(DensityFunctions.shiftedNoise2d(var2, var3, 0.25, NoiseRouterData.getNoise(Noises.RIDGE))));
        DensityFunction var7 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.JAGGED), 1500.0, 0.0);
        DensityFunction var8 = NoiseRouterData.splineWithBlending(var4, var5, var6, DensityFunctions.y.b.OFFSET, -0.81, 2.5, DensityFunctions.blendOffset());
        DensityFunction var9 = NoiseRouterData.register(FACTOR, NoiseRouterData.splineWithBlending(var4, var5, var6, DensityFunctions.y.b.FACTOR, 0.0, 8.0, BLENDING_FACTOR));
        DensityFunction var10 = NoiseRouterData.register(DEPTH, DensityFunctions.add(DensityFunctions.yClampedGradient(-64, 320, 1.5, -1.5), var8));
        NoiseRouterData.register(SLOPED_CHEESE, NoiseRouterData.slopedCheese(var4, var5, var6, var9, var10, var7));
        DensityFunction var11 = NoiseRouterData.register(CONTINENTS_LARGE, DensityFunctions.flatCache(DensityFunctions.shiftedNoise2d(var2, var3, 0.25, NoiseRouterData.getNoise(Noises.CONTINENTALNESS_LARGE))));
        DensityFunction var12 = NoiseRouterData.register(EROSION_LARGE, DensityFunctions.flatCache(DensityFunctions.shiftedNoise2d(var2, var3, 0.25, NoiseRouterData.getNoise(Noises.EROSION_LARGE))));
        DensityFunction var13 = NoiseRouterData.splineWithBlending(var11, var12, var6, DensityFunctions.y.b.OFFSET, -0.81, 2.5, DensityFunctions.blendOffset());
        DensityFunction var14 = NoiseRouterData.register(FACTOR_LARGE, NoiseRouterData.splineWithBlending(var11, var12, var6, DensityFunctions.y.b.FACTOR, 0.0, 8.0, BLENDING_FACTOR));
        DensityFunction var15 = NoiseRouterData.register(DEPTH_LARGE, DensityFunctions.add(DensityFunctions.yClampedGradient(-64, 320, 1.5, -1.5), var13));
        NoiseRouterData.register(SLOPED_CHEESE_LARGE, NoiseRouterData.slopedCheese(var11, var12, var6, var14, var15, var7));
        NoiseRouterData.register(SLOPED_CHEESE_END, DensityFunctions.add(DensityFunctions.endIslands(0L), NoiseRouterData.getFunction(BASE_3D_NOISE)));
        NoiseRouterData.register(SPAGHETTI_ROUGHNESS_FUNCTION, NoiseRouterData.spaghettiRoughnessFunction());
        NoiseRouterData.register(SPAGHETTI_2D_THICKNESS_MODULATOR, DensityFunctions.cacheOnce(DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.SPAGHETTI_2D_THICKNESS), 2.0, 1.0, -0.6, -1.3)));
        NoiseRouterData.register(SPAGHETTI_2D, NoiseRouterData.spaghetti2D());
        NoiseRouterData.register(ENTRANCES, NoiseRouterData.entrances());
        NoiseRouterData.register(NOODLE, NoiseRouterData.noodle());
        NoiseRouterData.register(PILLARS, NoiseRouterData.pillars());
        return (Holder)RegistryGeneration.DENSITY_FUNCTION.holders().iterator().next();
    }

    private static DensityFunction register(ResourceKey<DensityFunction> var0, DensityFunction var1) {
        return new DensityFunctions.j(RegistryGeneration.register(RegistryGeneration.DENSITY_FUNCTION, var0, var1));
    }

    private static Holder<NoiseGeneratorNormal.a> getNoise(ResourceKey<NoiseGeneratorNormal.a> var0) {
        return RegistryGeneration.NOISE.getHolderOrThrow(var0);
    }

    private static DensityFunction getFunction(ResourceKey<DensityFunction> var0) {
        return new DensityFunctions.j(RegistryGeneration.DENSITY_FUNCTION.getHolderOrThrow(var0));
    }

    private static DensityFunction slopedCheese(DensityFunction var0, DensityFunction var1, DensityFunction var2, DensityFunction var3, DensityFunction var4, DensityFunction var5) {
        DensityFunction var6 = NoiseRouterData.splineWithBlending(var0, var1, var2, DensityFunctions.y.b.JAGGEDNESS, 0.0, 1.28, BLENDING_JAGGEDNESS);
        DensityFunction var7 = DensityFunctions.mul(var6, var5.halfNegative());
        DensityFunction var8 = NoiseRouterData.noiseGradientDensity(var3, DensityFunctions.add(var4, var7));
        return DensityFunctions.add(var8, NoiseRouterData.getFunction(BASE_3D_NOISE));
    }

    private static DensityFunction spaghettiRoughnessFunction() {
        DensityFunction var0 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.SPAGHETTI_ROUGHNESS));
        DensityFunction var1 = DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.SPAGHETTI_ROUGHNESS_MODULATOR), 0.0, -0.1);
        return DensityFunctions.cacheOnce(DensityFunctions.mul(var1, DensityFunctions.add(var0.abs(), DensityFunctions.constant(-0.4))));
    }

    private static DensityFunction entrances() {
        DensityFunction var0 = DensityFunctions.cacheOnce(DensityFunctions.noise(NoiseRouterData.getNoise(Noises.SPAGHETTI_3D_RARITY), 2.0, 1.0));
        DensityFunction var1 = DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.SPAGHETTI_3D_THICKNESS), -0.065, -0.088);
        DensityFunction var2 = DensityFunctions.weirdScaledSampler(var0, NoiseRouterData.getNoise(Noises.SPAGHETTI_3D_1), DensityFunctions.ab.a.TYPE1);
        DensityFunction var3 = DensityFunctions.weirdScaledSampler(var0, NoiseRouterData.getNoise(Noises.SPAGHETTI_3D_2), DensityFunctions.ab.a.TYPE1);
        DensityFunction var4 = DensityFunctions.add(DensityFunctions.max(var2, var3), var1).clamp(-1.0, 1.0);
        DensityFunction var5 = NoiseRouterData.getFunction(SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction var6 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.CAVE_ENTRANCE), 0.75, 0.5);
        DensityFunction var7 = DensityFunctions.add(DensityFunctions.add(var6, DensityFunctions.constant(0.37)), DensityFunctions.yClampedGradient(-10, 30, 0.3, 0.0));
        return DensityFunctions.cacheOnce(DensityFunctions.min(var7, DensityFunctions.add(var5, var4)));
    }

    private static DensityFunction noodle() {
        DensityFunction var0 = NoiseRouterData.getFunction(Y);
        int var1 = -64;
        int var2 = -60;
        int var3 = 320;
        DensityFunction var4 = NoiseRouterData.yLimitedInterpolatable(var0, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.NOODLE), 1.0, 1.0), -60, 320, -1);
        DensityFunction var5 = NoiseRouterData.yLimitedInterpolatable(var0, DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.NOODLE_THICKNESS), 1.0, 1.0, -0.05, -0.1), -60, 320, 0);
        double var6 = 2.6666666666666665;
        DensityFunction var8 = NoiseRouterData.yLimitedInterpolatable(var0, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.NOODLE_RIDGE_A), 2.6666666666666665, 2.6666666666666665), -60, 320, 0);
        DensityFunction var9 = NoiseRouterData.yLimitedInterpolatable(var0, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.NOODLE_RIDGE_B), 2.6666666666666665, 2.6666666666666665), -60, 320, 0);
        DensityFunction var10 = DensityFunctions.mul(DensityFunctions.constant(1.5), DensityFunctions.max(var8.abs(), var9.abs()));
        return DensityFunctions.rangeChoice(var4, -1000000.0, 0.0, DensityFunctions.constant(64.0), DensityFunctions.add(var5, var10));
    }

    private static DensityFunction pillars() {
        double var0 = 25.0;
        double var2 = 0.3;
        DensityFunction var4 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.PILLAR), 25.0, 0.3);
        DensityFunction var5 = DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.PILLAR_RARENESS), 0.0, -2.0);
        DensityFunction var6 = DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.PILLAR_THICKNESS), 0.0, 1.1);
        DensityFunction var7 = DensityFunctions.add(DensityFunctions.mul(var4, DensityFunctions.constant(2.0)), var5);
        return DensityFunctions.cacheOnce(DensityFunctions.mul(var7, var6.cube()));
    }

    private static DensityFunction spaghetti2D() {
        DensityFunction var0 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.SPAGHETTI_2D_MODULATOR), 2.0, 1.0);
        DensityFunction var1 = DensityFunctions.weirdScaledSampler(var0, NoiseRouterData.getNoise(Noises.SPAGHETTI_2D), DensityFunctions.ab.a.TYPE2);
        DensityFunction var2 = DensityFunctions.mappedNoise(NoiseRouterData.getNoise(Noises.SPAGHETTI_2D_ELEVATION), 0.0, Math.floorDiv(-64, 8), 8.0);
        DensityFunction var3 = NoiseRouterData.getFunction(SPAGHETTI_2D_THICKNESS_MODULATOR);
        DensityFunction var4 = DensityFunctions.add(var2, DensityFunctions.yClampedGradient(-64, 320, 8.0, -40.0)).abs();
        DensityFunction var5 = DensityFunctions.add(var4, var3).cube();
        double var6 = 0.083;
        DensityFunction var8 = DensityFunctions.add(var1, DensityFunctions.mul(DensityFunctions.constant(0.083), var3));
        return DensityFunctions.max(var8, var5).clamp(-1.0, 1.0);
    }

    private static DensityFunction underground(DensityFunction var0) {
        DensityFunction var1 = NoiseRouterData.getFunction(SPAGHETTI_2D);
        DensityFunction var2 = NoiseRouterData.getFunction(SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction var3 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.CAVE_LAYER), 8.0);
        DensityFunction var4 = DensityFunctions.mul(DensityFunctions.constant(4.0), var3.square());
        DensityFunction var5 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.CAVE_CHEESE), 0.6666666666666666);
        DensityFunction var6 = DensityFunctions.add(DensityFunctions.add(DensityFunctions.constant(0.27), var5).clamp(-1.0, 1.0), DensityFunctions.add(DensityFunctions.constant(1.5), DensityFunctions.mul(DensityFunctions.constant(-0.64), var0)).clamp(0.0, 0.5));
        DensityFunction var7 = DensityFunctions.add(var4, var6);
        DensityFunction var8 = DensityFunctions.min(DensityFunctions.min(var7, NoiseRouterData.getFunction(ENTRANCES)), DensityFunctions.add(var1, var2));
        DensityFunction var9 = NoiseRouterData.getFunction(PILLARS);
        DensityFunction var10 = DensityFunctions.rangeChoice(var9, -1000000.0, 0.03, DensityFunctions.constant(-1000000.0), var9);
        return DensityFunctions.max(var8, var10);
    }

    private static DensityFunction postProcess(NoiseSettings var0, DensityFunction var1) {
        DensityFunction var2 = DensityFunctions.slide(var0, var1);
        DensityFunction var3 = DensityFunctions.blendDensity(var2);
        return DensityFunctions.mul(DensityFunctions.interpolated(var3), DensityFunctions.constant(0.64)).squeeze();
    }

    private static NoiseRouterWithOnlyNoises overworldWithNewCaves(NoiseSettings var02, boolean var1) {
        DensityFunction var2 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.AQUIFER_BARRIER), 0.5);
        DensityFunction var3 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS), 0.67);
        DensityFunction var4 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.AQUIFER_FLUID_LEVEL_SPREAD), 0.7142857142857143);
        DensityFunction var5 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.AQUIFER_LAVA));
        DensityFunction var6 = NoiseRouterData.getFunction(SHIFT_X);
        DensityFunction var7 = NoiseRouterData.getFunction(SHIFT_Z);
        DensityFunction var8 = DensityFunctions.shiftedNoise2d(var6, var7, 0.25, NoiseRouterData.getNoise(var1 ? Noises.TEMPERATURE_LARGE : Noises.TEMPERATURE));
        DensityFunction var9 = DensityFunctions.shiftedNoise2d(var6, var7, 0.25, NoiseRouterData.getNoise(var1 ? Noises.VEGETATION_LARGE : Noises.VEGETATION));
        DensityFunction var10 = NoiseRouterData.getFunction(var1 ? FACTOR_LARGE : FACTOR);
        DensityFunction var11 = NoiseRouterData.getFunction(var1 ? DEPTH_LARGE : DEPTH);
        DensityFunction var12 = NoiseRouterData.noiseGradientDensity(DensityFunctions.cache2d(var10), var11);
        DensityFunction var13 = NoiseRouterData.getFunction(var1 ? SLOPED_CHEESE_LARGE : SLOPED_CHEESE);
        DensityFunction var14 = DensityFunctions.min(var13, DensityFunctions.mul(DensityFunctions.constant(5.0), NoiseRouterData.getFunction(ENTRANCES)));
        DensityFunction var15 = DensityFunctions.rangeChoice(var13, -1000000.0, 1.5625, var14, NoiseRouterData.underground(var13));
        DensityFunction var16 = DensityFunctions.min(NoiseRouterData.postProcess(var02, var15), NoiseRouterData.getFunction(NOODLE));
        DensityFunction var17 = NoiseRouterData.getFunction(Y);
        int var18 = var02.minY();
        int var19 = Stream.of(OreVeinifier.a.values()).mapToInt(var0 -> var0.minY).min().orElse(var18);
        int var20 = Stream.of(OreVeinifier.a.values()).mapToInt(var0 -> var0.maxY).max().orElse(var18);
        DensityFunction var21 = NoiseRouterData.yLimitedInterpolatable(var17, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.ORE_VEININESS), 1.5, 1.5), var19, var20, 0);
        float var22 = 4.0f;
        DensityFunction var23 = NoiseRouterData.yLimitedInterpolatable(var17, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.ORE_VEIN_A), 4.0, 4.0), var19, var20, 0).abs();
        DensityFunction var24 = NoiseRouterData.yLimitedInterpolatable(var17, DensityFunctions.noise(NoiseRouterData.getNoise(Noises.ORE_VEIN_B), 4.0, 4.0), var19, var20, 0).abs();
        DensityFunction var25 = DensityFunctions.add(DensityFunctions.constant(-0.08f), DensityFunctions.max(var23, var24));
        DensityFunction var26 = DensityFunctions.noise(NoiseRouterData.getNoise(Noises.ORE_GAP));
        return new NoiseRouterWithOnlyNoises(var2, var3, var4, var5, var8, var9, NoiseRouterData.getFunction(var1 ? CONTINENTS_LARGE : CONTINENTS), NoiseRouterData.getFunction(var1 ? EROSION_LARGE : EROSION), NoiseRouterData.getFunction(var1 ? DEPTH_LARGE : DEPTH), NoiseRouterData.getFunction(RIDGES), var12, var16, var21, var25, var26);
    }

    private static NoiseRouterWithOnlyNoises noNewCaves(NoiseSettings var0) {
        DensityFunction var1 = NoiseRouterData.getFunction(SHIFT_X);
        DensityFunction var2 = NoiseRouterData.getFunction(SHIFT_Z);
        DensityFunction var3 = DensityFunctions.shiftedNoise2d(var1, var2, 0.25, NoiseRouterData.getNoise(Noises.TEMPERATURE));
        DensityFunction var4 = DensityFunctions.shiftedNoise2d(var1, var2, 0.25, NoiseRouterData.getNoise(Noises.VEGETATION));
        DensityFunction var5 = NoiseRouterData.noiseGradientDensity(DensityFunctions.cache2d(NoiseRouterData.getFunction(FACTOR)), NoiseRouterData.getFunction(DEPTH));
        DensityFunction var6 = NoiseRouterData.postProcess(var0, NoiseRouterData.getFunction(SLOPED_CHEESE));
        return new NoiseRouterWithOnlyNoises(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), var3, var4, NoiseRouterData.getFunction(CONTINENTS), NoiseRouterData.getFunction(EROSION), NoiseRouterData.getFunction(DEPTH), NoiseRouterData.getFunction(RIDGES), var5, var6, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    protected static NoiseRouterWithOnlyNoises overworldWithoutCaves(NoiseSettings var0) {
        return NoiseRouterData.noNewCaves(var0);
    }

    protected static NoiseRouterWithOnlyNoises nether(NoiseSettings var0) {
        return NoiseRouterData.noNewCaves(var0);
    }

    protected static NoiseRouterWithOnlyNoises end(NoiseSettings var0) {
        DensityFunction var1 = DensityFunctions.cache2d(DensityFunctions.endIslands(0L));
        DensityFunction var2 = NoiseRouterData.postProcess(var0, NoiseRouterData.getFunction(SLOPED_CHEESE_END));
        return new NoiseRouterWithOnlyNoises(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), var1, var2, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    private static NoiseGeneratorNormal seedNoise(PositionalRandomFactory var0, IRegistry<NoiseGeneratorNormal.a> var1, Holder<NoiseGeneratorNormal.a> var2) {
        return Noises.instantiate(var0, var2.unwrapKey().flatMap(var1::getHolder).orElse(var2));
    }

    public static NoiseRouter createNoiseRouter(NoiseSettings var0, long var1, IRegistry<NoiseGeneratorNormal.a> var3, SeededRandom.a var4, NoiseRouterWithOnlyNoises var5) {
        boolean var6 = var4 == SeededRandom.a.LEGACY;
        PositionalRandomFactory var72 = var4.newInstance(var1).forkPositional();
        HashMap var8 = new HashMap();
        DensityFunction.e var9 = var7 -> {
            if (var7 instanceof DensityFunctions.o) {
                DensityFunctions.o var8 = (DensityFunctions.o)var7;
                Holder<NoiseGeneratorNormal.a> var9 = var8.noiseData();
                return new DensityFunctions.o(var9, NoiseRouterData.seedNoise(var72, var3, var9), var8.xzScale(), var8.yScale());
            }
            if (var7 instanceof DensityFunctions.u) {
                DensityFunctions.u var8 = (DensityFunctions.u)var7;
                Holder<NoiseGeneratorNormal.a> var10 = var8.noiseData();
                NoiseGeneratorNormal var9 = var6 ? NoiseGeneratorNormal.create(var72.fromHashOf(Noises.SHIFT.location()), new NoiseGeneratorNormal.a(0, 0.0, new double[0])) : NoiseRouterData.seedNoise(var72, var3, var10);
                return var8.withNewNoise(var9);
            }
            if (var7 instanceof DensityFunctions.v) {
                Holder<NoiseGeneratorNormal.a> var9;
                DensityFunctions.v var8 = (DensityFunctions.v)var7;
                if (var6) {
                    var9 = var8.noiseData();
                    if (Objects.equals(var9.unwrapKey(), Optional.of(Noises.TEMPERATURE))) {
                        NoiseGeneratorNormal var10 = NoiseGeneratorNormal.createLegacyNetherBiome(var4.newInstance(var1), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
                        return new DensityFunctions.v(var8.shiftX(), var8.shiftY(), var8.shiftZ(), var8.xzScale(), var8.yScale(), var9, var10);
                    }
                    if (Objects.equals(var9.unwrapKey(), Optional.of(Noises.VEGETATION))) {
                        NoiseGeneratorNormal var10 = NoiseGeneratorNormal.createLegacyNetherBiome(var4.newInstance(var1 + 1L), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
                        return new DensityFunctions.v(var8.shiftX(), var8.shiftY(), var8.shiftZ(), var8.xzScale(), var8.yScale(), var9, var10);
                    }
                }
                var9 = var8.noiseData();
                return new DensityFunctions.v(var8.shiftX(), var8.shiftY(), var8.shiftZ(), var8.xzScale(), var8.yScale(), var9, NoiseRouterData.seedNoise(var72, var3, var9));
            }
            if (var7 instanceof DensityFunctions.ab) {
                DensityFunctions.ab var8 = (DensityFunctions.ab)var7;
                return new DensityFunctions.ab(var8.input(), var8.noiseData(), NoiseRouterData.seedNoise(var72, var3, var8.noiseData()), var8.rarityValueMapper());
            }
            if (var7 instanceof BlendedNoise) {
                if (var6) {
                    return new BlendedNoise(var4.newInstance(var1), var0.noiseSamplingSettings(), var0.getCellWidth(), var0.getCellHeight());
                }
                return new BlendedNoise(var72.fromHashOf(new MinecraftKey("terrain")), var0.noiseSamplingSettings(), var0.getCellWidth(), var0.getCellHeight());
            }
            if (var7 instanceof DensityFunctions.i) {
                return new DensityFunctions.i(var1);
            }
            if (var7 instanceof DensityFunctions.y) {
                DensityFunctions.y var8 = (DensityFunctions.y)var7;
                TerrainShaper var9 = var0.terrainShaper();
                return new DensityFunctions.y(var8.continentalness(), var8.erosion(), var8.weirdness(), var9, var8.spline(), var8.minValue(), var8.maxValue());
            }
            if (var7 instanceof DensityFunctions.w) {
                DensityFunctions.w var8 = (DensityFunctions.w)var7;
                return new DensityFunctions.w(var0, var8.input());
            }
            return var7;
        };
        DensityFunction.e var10 = var2 -> var8.computeIfAbsent(var2, var9);
        NoiseRouterWithOnlyNoises var11 = var5.mapAll(var10);
        PositionalRandomFactory var12 = var72.fromHashOf(new MinecraftKey("aquifer")).forkPositional();
        PositionalRandomFactory var13 = var72.fromHashOf(new MinecraftKey("ore")).forkPositional();
        return new NoiseRouter(var11.barrierNoise(), var11.fluidLevelFloodednessNoise(), var11.fluidLevelSpreadNoise(), var11.lavaNoise(), var12, var13, var11.temperature(), var11.vegetation(), var11.continents(), var11.erosion(), var11.depth(), var11.ridges(), var11.initialDensityWithoutJaggedness(), var11.finalDensity(), var11.veinToggle(), var11.veinRidged(), var11.veinGap(), new OverworldBiomeBuilder().spawnTarget());
    }

    private static DensityFunction splineWithBlending(DensityFunction var0, DensityFunction var1, DensityFunction var2, DensityFunctions.y.b var3, double var4, double var6, DensityFunction var8) {
        DensityFunction var9 = DensityFunctions.terrainShaperSpline(var0, var1, var2, var3, var4, var6);
        DensityFunction var10 = DensityFunctions.lerp(DensityFunctions.blendAlpha(), var8, var9);
        return DensityFunctions.flatCache(DensityFunctions.cache2d(var10));
    }

    private static DensityFunction noiseGradientDensity(DensityFunction var0, DensityFunction var1) {
        DensityFunction var2 = DensityFunctions.mul(var1, var0);
        return DensityFunctions.mul(DensityFunctions.constant(4.0), var2.quarterNegative());
    }

    private static DensityFunction yLimitedInterpolatable(DensityFunction var0, DensityFunction var1, int var2, int var3, int var4) {
        return DensityFunctions.interpolated(DensityFunctions.rangeChoice(var0, var2, var3 + 1, var1, DensityFunctions.constant(var4)));
    }

    protected static double applySlide(NoiseSettings var0, double var1, double var3) {
        double var5 = (int)var3 / var0.getCellHeight() - var0.getMinCellY();
        var1 = var0.topSlideSettings().applySlide(var1, (double)var0.getCellCountY() - var5);
        var1 = var0.bottomSlideSettings().applySlide(var1, var5);
        return var1;
    }

    protected static double computePreliminarySurfaceLevelScanning(NoiseSettings var0, DensityFunction var1, int var2, int var3) {
        for (int var4 = var0.getMinCellY() + var0.getCellCountY(); var4 >= var0.getMinCellY(); --var4) {
            int var5 = var4 * var0.getCellHeight();
            double var6 = -0.703125;
            double var8 = var1.compute(new DensityFunction.d(var2, var5, var3)) + -0.703125;
            double var10 = MathHelper.clamp(var8, -64.0, 64.0);
            if (!((var10 = NoiseRouterData.applySlide(var0, var10, var5)) > 0.390625)) continue;
            return var5;
        }
        return 2.147483647E9;
    }

    protected static final class a {
        protected a() {
        }

        protected static double getSphaghettiRarity2D(double var0) {
            if (var0 < -0.75) {
                return 0.5;
            }
            if (var0 < -0.5) {
                return 0.75;
            }
            if (var0 < 0.5) {
                return 1.0;
            }
            if (var0 < 0.75) {
                return 2.0;
            }
            return 3.0;
        }

        protected static double getSpaghettiRarity3D(double var0) {
            if (var0 < -0.5) {
                return 0.75;
            }
            if (var0 < 0.0) {
                return 1.0;
            }
            if (var0 < 0.5) {
                return 1.5;
            }
            return 2.0;
        }
    }
}

