/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.material.MaterialRuleList;

public class NoiseChunk
implements DensityFunction.a,
DensityFunction.b {
    private final NoiseSettings noiseSettings;
    final int cellCountXZ;
    final int cellCountY;
    final int cellNoiseMinY;
    private final int firstCellX;
    private final int firstCellZ;
    final int firstNoiseX;
    final int firstNoiseZ;
    final List<i> interpolators;
    final List<e> cellCaches;
    private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();
    private final Long2IntMap preliminarySurfaceLevel = new Long2IntOpenHashMap();
    private final Aquifer aquifer;
    private final DensityFunction initialDensityNoJaggedness;
    private final c blockStateRule;
    private final Blender blender;
    private final g blendAlpha;
    private final g blendOffset;
    private final DensityFunctions.c beardifier;
    private long lastBlendingDataPos = ChunkCoordIntPair.INVALID_CHUNK_POS;
    private Blender.a lastBlendingOutput = new Blender.a(1.0, 0.0);
    final int noiseSizeXZ;
    final int cellWidth;
    final int cellHeight;
    boolean interpolating;
    boolean fillingCell;
    private int cellStartBlockX;
    int cellStartBlockY;
    private int cellStartBlockZ;
    int inCellX;
    int inCellY;
    int inCellZ;
    long interpolationCounter;
    long arrayInterpolationCounter;
    int arrayIndex;
    private final DensityFunction.a sliceFillingContextProvider = new DensityFunction.a(){

        @Override
        public DensityFunction.b forIndex(int var0) {
            NoiseChunk.this.cellStartBlockY = (var0 + NoiseChunk.this.cellNoiseMinY) * NoiseChunk.this.cellHeight;
            ++NoiseChunk.this.interpolationCounter;
            NoiseChunk.this.inCellY = 0;
            NoiseChunk.this.arrayIndex = var0;
            return NoiseChunk.this;
        }

        @Override
        public void fillAllDirectly(double[] var0, DensityFunction var1) {
            for (int var2 = 0; var2 < NoiseChunk.this.cellCountY + 1; ++var2) {
                NoiseChunk.this.cellStartBlockY = (var2 + NoiseChunk.this.cellNoiseMinY) * NoiseChunk.this.cellHeight;
                ++NoiseChunk.this.interpolationCounter;
                NoiseChunk.this.inCellY = 0;
                NoiseChunk.this.arrayIndex = var2;
                var0[var2] = var1.compute(NoiseChunk.this);
            }
        }
    };

    public static NoiseChunk forChunk(IChunkAccess var0, NoiseRouter var1, Supplier<DensityFunctions.c> var2, GeneratorSettingBase var3, Aquifer.a var4, Blender var5) {
        ChunkCoordIntPair var6 = var0.getPos();
        NoiseSettings var7 = var3.noiseSettings();
        int var8 = Math.max(var7.minY(), var0.getMinBuildHeight());
        int var9 = Math.min(var7.minY() + var7.height(), var0.getMaxBuildHeight());
        int var10 = MathHelper.intFloorDiv(var8, var7.getCellHeight());
        int var11 = MathHelper.intFloorDiv(var9 - var8, var7.getCellHeight());
        return new NoiseChunk(16 / var7.getCellWidth(), var11, var10, var1, var6.getMinBlockX(), var6.getMinBlockZ(), var2.get(), var3, var4, var5);
    }

    public static NoiseChunk forColumn(int var0, int var1, int var2, int var3, NoiseRouter var4, GeneratorSettingBase var5, Aquifer.a var6) {
        return new NoiseChunk(1, var3, var2, var4, var0, var1, DensityFunctions.b.INSTANCE, var5, var6, Blender.empty());
    }

    private NoiseChunk(int var0, int var12, int var2, NoiseRouter var3, int var4, int var5, DensityFunctions.c var6, GeneratorSettingBase var7, Aquifer.a var8, Blender var9) {
        int var11;
        int var10;
        this.noiseSettings = var7.noiseSettings();
        this.cellCountXZ = var0;
        this.cellCountY = var12;
        this.cellNoiseMinY = var2;
        this.cellWidth = this.noiseSettings.getCellWidth();
        this.cellHeight = this.noiseSettings.getCellHeight();
        this.firstCellX = Math.floorDiv(var4, this.cellWidth);
        this.firstCellZ = Math.floorDiv(var5, this.cellWidth);
        this.interpolators = Lists.newArrayList();
        this.cellCaches = Lists.newArrayList();
        this.firstNoiseX = QuartPos.fromBlock(var4);
        this.firstNoiseZ = QuartPos.fromBlock(var5);
        this.noiseSizeXZ = QuartPos.fromBlock(var0 * this.cellWidth);
        this.blender = var9;
        this.beardifier = var6;
        this.blendAlpha = new g(new a(), false);
        this.blendOffset = new g(new b(), false);
        for (var10 = 0; var10 <= this.noiseSizeXZ; ++var10) {
            var11 = this.firstNoiseX + var10;
            int var122 = QuartPos.toBlock(var11);
            for (int var13 = 0; var13 <= this.noiseSizeXZ; ++var13) {
                int var14 = this.firstNoiseZ + var13;
                int var15 = QuartPos.toBlock(var14);
                Blender.a var16 = var9.blendOffsetAndFactor(var122, var15);
                this.blendAlpha.values[var10][var13] = var16.alpha();
                this.blendOffset.values[var10][var13] = var16.blendingOffset();
            }
        }
        if (!var7.isAquifersEnabled()) {
            this.aquifer = Aquifer.createDisabled(var8);
        } else {
            var10 = SectionPosition.blockToSectionCoord(var4);
            var11 = SectionPosition.blockToSectionCoord(var5);
            this.aquifer = Aquifer.create(this, new ChunkCoordIntPair(var10, var11), var3.barrierNoise(), var3.fluidLevelFloodednessNoise(), var3.fluidLevelSpreadNoise(), var3.lavaNoise(), var3.aquiferPositionalRandomFactory(), var2 * this.cellHeight, var12 * this.cellHeight, var8);
        }
        ImmutableList.Builder var102 = ImmutableList.builder();
        DensityFunction var112 = DensityFunctions.cacheAllInCell(DensityFunctions.add(var3.finalDensity(), DensityFunctions.b.INSTANCE)).mapAll(this::wrap);
        var102.add(var1 -> this.aquifer.computeSubstance(var1, var112.compute(var1)));
        if (var7.oreVeinsEnabled()) {
            var102.add((Object)OreVeinifier.create(var3.veinToggle().mapAll(this::wrap), var3.veinRidged().mapAll(this::wrap), var3.veinGap().mapAll(this::wrap), var3.oreVeinsPositionalRandomFactory()));
        }
        this.blockStateRule = new MaterialRuleList((List<c>)var102.build());
        this.initialDensityNoJaggedness = var3.initialDensityWithoutJaggedness().mapAll(this::wrap);
    }

    protected Climate.Sampler cachedClimateSampler(NoiseRouter var0) {
        return new Climate.Sampler(var0.temperature().mapAll(this::wrap), var0.humidity().mapAll(this::wrap), var0.continents().mapAll(this::wrap), var0.erosion().mapAll(this::wrap), var0.depth().mapAll(this::wrap), var0.ridges().mapAll(this::wrap), var0.spawnTarget());
    }

    @Nullable
    protected IBlockData getInterpolatedState() {
        return this.blockStateRule.calculate(this);
    }

    @Override
    public int blockX() {
        return this.cellStartBlockX + this.inCellX;
    }

    @Override
    public int blockY() {
        return this.cellStartBlockY + this.inCellY;
    }

    @Override
    public int blockZ() {
        return this.cellStartBlockZ + this.inCellZ;
    }

    public int preliminarySurfaceLevel(int var0, int var1) {
        return this.preliminarySurfaceLevel.computeIfAbsent(ChunkCoordIntPair.asLong(QuartPos.fromBlock(var0), QuartPos.fromBlock(var1)), this::computePreliminarySurfaceLevel);
    }

    private int computePreliminarySurfaceLevel(long var0) {
        int var2 = ChunkCoordIntPair.getX(var0);
        int var3 = ChunkCoordIntPair.getZ(var0);
        return (int)NoiseRouterData.computePreliminarySurfaceLevelScanning(this.noiseSettings, this.initialDensityNoJaggedness, QuartPos.toBlock(var2), QuartPos.toBlock(var3));
    }

    @Override
    public Blender getBlender() {
        return this.blender;
    }

    private void fillSlice(boolean var0, int var1) {
        this.cellStartBlockX = var1 * this.cellWidth;
        this.inCellX = 0;
        for (int var2 = 0; var2 < this.cellCountXZ + 1; ++var2) {
            int var3 = this.firstCellZ + var2;
            this.cellStartBlockZ = var3 * this.cellWidth;
            this.inCellZ = 0;
            ++this.arrayInterpolationCounter;
            for (i var5 : this.interpolators) {
                double[] var6 = (var0 ? var5.slice0 : var5.slice1)[var2];
                var5.fillArray(var6, this.sliceFillingContextProvider);
            }
        }
        ++this.arrayInterpolationCounter;
    }

    public void initializeForFirstCellX() {
        if (this.interpolating) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.interpolating = true;
        this.interpolationCounter = 0L;
        this.fillSlice(true, this.firstCellX);
    }

    public void advanceCellX(int var0) {
        this.fillSlice(false, this.firstCellX + var0 + 1);
        this.cellStartBlockX = (this.firstCellX + var0) * this.cellWidth;
    }

    @Override
    public NoiseChunk forIndex(int var0) {
        int var1 = Math.floorMod(var0, this.cellWidth);
        int var2 = Math.floorDiv(var0, this.cellWidth);
        int var3 = Math.floorMod(var2, this.cellWidth);
        int var4 = this.cellHeight - 1 - Math.floorDiv(var2, this.cellWidth);
        this.inCellX = var3;
        this.inCellY = var4;
        this.inCellZ = var1;
        this.arrayIndex = var0;
        return this;
    }

    @Override
    public void fillAllDirectly(double[] var0, DensityFunction var1) {
        this.arrayIndex = 0;
        for (int var2 = this.cellHeight - 1; var2 >= 0; --var2) {
            this.inCellY = var2;
            for (int var3 = 0; var3 < this.cellWidth; ++var3) {
                this.inCellX = var3;
                int var4 = 0;
                while (var4 < this.cellWidth) {
                    this.inCellZ = var4++;
                    var0[this.arrayIndex++] = var1.compute(this);
                }
            }
        }
    }

    public void selectCellYZ(int var0, int var1) {
        this.interpolators.forEach(var2 -> var2.selectCellYZ(var0, var1));
        this.fillingCell = true;
        this.cellStartBlockY = (var0 + this.cellNoiseMinY) * this.cellHeight;
        this.cellStartBlockZ = (this.firstCellZ + var1) * this.cellWidth;
        ++this.arrayInterpolationCounter;
        for (e var3 : this.cellCaches) {
            var3.noiseFiller.fillArray(var3.values, this);
        }
        ++this.arrayInterpolationCounter;
        this.fillingCell = false;
    }

    public void updateForY(int var0, double var1) {
        this.inCellY = var0 - this.cellStartBlockY;
        this.interpolators.forEach(var2 -> var2.updateForY(var1));
    }

    public void updateForX(int var0, double var1) {
        this.inCellX = var0 - this.cellStartBlockX;
        this.interpolators.forEach(var2 -> var2.updateForX(var1));
    }

    public void updateForZ(int var0, double var1) {
        this.inCellZ = var0 - this.cellStartBlockZ;
        ++this.interpolationCounter;
        this.interpolators.forEach(var2 -> var2.updateForZ(var1));
    }

    public void stopInterpolation() {
        if (!this.interpolating) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.interpolating = false;
    }

    public void swapSlices() {
        this.interpolators.forEach(i::swapSlices);
    }

    public Aquifer aquifer() {
        return this.aquifer;
    }

    Blender.a getOrComputeBlendingOutput(int var0, int var1) {
        Blender.a var4;
        long var2 = ChunkCoordIntPair.asLong(var0, var1);
        if (this.lastBlendingDataPos == var2) {
            return this.lastBlendingOutput;
        }
        this.lastBlendingDataPos = var2;
        this.lastBlendingOutput = var4 = this.blender.blendOffsetAndFactor(var0, var1);
        return var4;
    }

    protected DensityFunction wrap(DensityFunction var0) {
        return this.wrapped.computeIfAbsent(var0, this::wrapNew);
    }

    private DensityFunction wrapNew(DensityFunction var0) {
        if (var0 instanceof DensityFunctions.l) {
            DensityFunctions.l var1 = (DensityFunctions.l)var0;
            return switch (var1.type()) {
                default -> throw new IncompatibleClassChangeError();
                case DensityFunctions.l.a.Interpolated -> new i(var1.wrapped());
                case DensityFunctions.l.a.FlatCache -> new g(var1.wrapped(), true);
                case DensityFunctions.l.a.Cache2D -> new d(var1.wrapped());
                case DensityFunctions.l.a.CacheOnce -> new f(var1.wrapped());
                case DensityFunctions.l.a.CacheAllInCell -> new e(var1.wrapped());
            };
        }
        if (this.blender != Blender.empty()) {
            if (var0 == DensityFunctions.d.INSTANCE) {
                return this.blendAlpha;
            }
            if (var0 == DensityFunctions.f.INSTANCE) {
                return this.blendOffset;
            }
        }
        if (var0 == DensityFunctions.b.INSTANCE) {
            return this.beardifier;
        }
        if (var0 instanceof DensityFunctions.j) {
            DensityFunctions.j var1 = (DensityFunctions.j)var0;
            return var1.function().value();
        }
        return var0;
    }

    @Override
    public /* synthetic */ DensityFunction.b forIndex(int n2) {
        return this.forIndex(n2);
    }

    class g
    implements DensityFunctions.m,
    h {
        private final DensityFunction noiseFiller;
        final double[][] values;

        g(DensityFunction var1, boolean var2) {
            this.noiseFiller = var1;
            this.values = new double[NoiseChunk.this.noiseSizeXZ + 1][NoiseChunk.this.noiseSizeXZ + 1];
            if (var2) {
                for (int var3 = 0; var3 <= NoiseChunk.this.noiseSizeXZ; ++var3) {
                    int var4 = NoiseChunk.this.firstNoiseX + var3;
                    int var5 = QuartPos.toBlock(var4);
                    for (int var6 = 0; var6 <= NoiseChunk.this.noiseSizeXZ; ++var6) {
                        int var7 = NoiseChunk.this.firstNoiseZ + var6;
                        int var8 = QuartPos.toBlock(var7);
                        this.values[var3][var6] = var1.compute(new DensityFunction.d(var5, 0, var8));
                    }
                }
            }
        }

        @Override
        public double compute(DensityFunction.b var0) {
            int var1 = QuartPos.fromBlock(var0.blockX());
            int var2 = QuartPos.fromBlock(var0.blockZ());
            int var3 = var1 - NoiseChunk.this.firstNoiseX;
            int var4 = var2 - NoiseChunk.this.firstNoiseZ;
            int var5 = this.values.length;
            if (var3 >= 0 && var4 >= 0 && var3 < var5 && var4 < var5) {
                return this.values[var3][var4];
            }
            return this.noiseFiller.compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        @Override
        public DensityFunctions.l.a type() {
            return DensityFunctions.l.a.FlatCache;
        }
    }

    class a
    implements h {
        a() {
        }

        @Override
        public DensityFunction wrapped() {
            return DensityFunctions.d.INSTANCE;
        }

        @Override
        public double compute(DensityFunction.b var0) {
            return NoiseChunk.this.getOrComputeBlendingOutput(var0.blockX(), var0.blockZ()).alpha();
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public double minValue() {
            return 0.0;
        }

        @Override
        public double maxValue() {
            return 1.0;
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return DensityFunctions.d.CODEC;
        }
    }

    class b
    implements h {
        b() {
        }

        @Override
        public DensityFunction wrapped() {
            return DensityFunctions.f.INSTANCE;
        }

        @Override
        public double compute(DensityFunction.b var0) {
            return NoiseChunk.this.getOrComputeBlendingOutput(var0.blockX(), var0.blockZ()).blendingOffset();
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public double minValue() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double maxValue() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public Codec<? extends DensityFunction> codec() {
            return DensityFunctions.f.CODEC;
        }
    }

    @FunctionalInterface
    public static interface c {
        @Nullable
        public IBlockData calculate(DensityFunction.b var1);
    }

    public class i
    implements DensityFunctions.m,
    h {
        double[][] slice0;
        double[][] slice1;
        private final DensityFunction noiseFiller;
        private double noise000;
        private double noise001;
        private double noise100;
        private double noise101;
        private double noise010;
        private double noise011;
        private double noise110;
        private double noise111;
        private double valueXZ00;
        private double valueXZ10;
        private double valueXZ01;
        private double valueXZ11;
        private double valueZ0;
        private double valueZ1;
        private double value;

        i(DensityFunction var1) {
            this.noiseFiller = var1;
            this.slice0 = this.allocateSlice(NoiseChunk.this.cellCountY, NoiseChunk.this.cellCountXZ);
            this.slice1 = this.allocateSlice(NoiseChunk.this.cellCountY, NoiseChunk.this.cellCountXZ);
            NoiseChunk.this.interpolators.add(this);
        }

        private double[][] allocateSlice(int var0, int var1) {
            int var2 = var1 + 1;
            int var3 = var0 + 1;
            double[][] var4 = new double[var2][var3];
            for (int var5 = 0; var5 < var2; ++var5) {
                var4[var5] = new double[var3];
            }
            return var4;
        }

        void selectCellYZ(int var0, int var1) {
            this.noise000 = this.slice0[var1][var0];
            this.noise001 = this.slice0[var1 + 1][var0];
            this.noise100 = this.slice1[var1][var0];
            this.noise101 = this.slice1[var1 + 1][var0];
            this.noise010 = this.slice0[var1][var0 + 1];
            this.noise011 = this.slice0[var1 + 1][var0 + 1];
            this.noise110 = this.slice1[var1][var0 + 1];
            this.noise111 = this.slice1[var1 + 1][var0 + 1];
        }

        void updateForY(double var0) {
            this.valueXZ00 = MathHelper.lerp(var0, this.noise000, this.noise010);
            this.valueXZ10 = MathHelper.lerp(var0, this.noise100, this.noise110);
            this.valueXZ01 = MathHelper.lerp(var0, this.noise001, this.noise011);
            this.valueXZ11 = MathHelper.lerp(var0, this.noise101, this.noise111);
        }

        void updateForX(double var0) {
            this.valueZ0 = MathHelper.lerp(var0, this.valueXZ00, this.valueXZ10);
            this.valueZ1 = MathHelper.lerp(var0, this.valueXZ01, this.valueXZ11);
        }

        void updateForZ(double var0) {
            this.value = MathHelper.lerp(var0, this.valueZ0, this.valueZ1);
        }

        @Override
        public double compute(DensityFunction.b var0) {
            if (var0 != NoiseChunk.this) {
                return this.noiseFiller.compute(var0);
            }
            if (!NoiseChunk.this.interpolating) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            if (NoiseChunk.this.fillingCell) {
                return MathHelper.lerp3((double)NoiseChunk.this.inCellX / (double)NoiseChunk.this.cellWidth, (double)NoiseChunk.this.inCellY / (double)NoiseChunk.this.cellHeight, (double)NoiseChunk.this.inCellZ / (double)NoiseChunk.this.cellWidth, this.noise000, this.noise100, this.noise010, this.noise110, this.noise001, this.noise101, this.noise011, this.noise111);
            }
            return this.value;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            if (NoiseChunk.this.fillingCell) {
                var1.fillAllDirectly(var0, this);
                return;
            }
            this.wrapped().fillArray(var0, var1);
        }

        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        private void swapSlices() {
            double[][] var0 = this.slice0;
            this.slice0 = this.slice1;
            this.slice1 = var0;
        }

        @Override
        public DensityFunctions.l.a type() {
            return DensityFunctions.l.a.Interpolated;
        }
    }

    class e
    implements DensityFunctions.m,
    h {
        final DensityFunction noiseFiller;
        final double[] values;

        e(DensityFunction var1) {
            this.noiseFiller = var1;
            this.values = new double[NoiseChunk.this.cellWidth * NoiseChunk.this.cellWidth * NoiseChunk.this.cellHeight];
            NoiseChunk.this.cellCaches.add(this);
        }

        @Override
        public double compute(DensityFunction.b var0) {
            if (var0 != NoiseChunk.this) {
                return this.noiseFiller.compute(var0);
            }
            if (!NoiseChunk.this.interpolating) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            int var1 = NoiseChunk.this.inCellX;
            int var2 = NoiseChunk.this.inCellY;
            int var3 = NoiseChunk.this.inCellZ;
            if (var1 >= 0 && var2 >= 0 && var3 >= 0 && var1 < NoiseChunk.this.cellWidth && var2 < NoiseChunk.this.cellHeight && var3 < NoiseChunk.this.cellWidth) {
                return this.values[((NoiseChunk.this.cellHeight - 1 - var2) * NoiseChunk.this.cellWidth + var1) * NoiseChunk.this.cellWidth + var3];
            }
            return this.noiseFiller.compute(var0);
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        public DensityFunction wrapped() {
            return this.noiseFiller;
        }

        @Override
        public DensityFunctions.l.a type() {
            return DensityFunctions.l.a.CacheAllInCell;
        }
    }

    static class d
    implements DensityFunctions.m,
    h {
        private final DensityFunction function;
        private long lastPos2D = ChunkCoordIntPair.INVALID_CHUNK_POS;
        private double lastValue;

        d(DensityFunction var0) {
            this.function = var0;
        }

        @Override
        public double compute(DensityFunction.b var0) {
            double var5;
            int var2;
            int var1 = var0.blockX();
            long var3 = ChunkCoordIntPair.asLong(var1, var2 = var0.blockZ());
            if (this.lastPos2D == var3) {
                return this.lastValue;
            }
            this.lastPos2D = var3;
            this.lastValue = var5 = this.function.compute(var0);
            return var5;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            this.function.fillArray(var0, var1);
        }

        @Override
        public DensityFunction wrapped() {
            return this.function;
        }

        @Override
        public DensityFunctions.l.a type() {
            return DensityFunctions.l.a.Cache2D;
        }
    }

    class f
    implements DensityFunctions.m,
    h {
        private final DensityFunction function;
        private long lastCounter;
        private long lastArrayCounter;
        private double lastValue;
        @Nullable
        private double[] lastArray;

        f(DensityFunction var1) {
            this.function = var1;
        }

        @Override
        public double compute(DensityFunction.b var0) {
            double var1;
            if (var0 != NoiseChunk.this) {
                return this.function.compute(var0);
            }
            if (this.lastArray != null && this.lastArrayCounter == NoiseChunk.this.arrayInterpolationCounter) {
                return this.lastArray[NoiseChunk.this.arrayIndex];
            }
            if (this.lastCounter == NoiseChunk.this.interpolationCounter) {
                return this.lastValue;
            }
            this.lastCounter = NoiseChunk.this.interpolationCounter;
            this.lastValue = var1 = this.function.compute(var0);
            return var1;
        }

        @Override
        public void fillArray(double[] var0, DensityFunction.a var1) {
            if (this.lastArray != null && this.lastArrayCounter == NoiseChunk.this.arrayInterpolationCounter) {
                System.arraycopy(this.lastArray, 0, var0, 0, var0.length);
                return;
            }
            this.wrapped().fillArray(var0, var1);
            if (this.lastArray != null && this.lastArray.length == var0.length) {
                System.arraycopy(var0, 0, this.lastArray, 0, var0.length);
            } else {
                this.lastArray = (double[])var0.clone();
            }
            this.lastArrayCounter = NoiseChunk.this.arrayInterpolationCounter;
        }

        @Override
        public DensityFunction wrapped() {
            return this.function;
        }

        @Override
        public DensityFunctions.l.a type() {
            return DensityFunctions.l.a.CacheOnce;
        }
    }

    static interface h
    extends DensityFunction {
        public DensityFunction wrapped();

        @Override
        default public DensityFunction mapAll(DensityFunction.e var0) {
            return this.wrapped().mapAll(var0);
        }

        @Override
        default public double minValue() {
            return this.wrapped().minValue();
        }

        @Override
        default public double maxValue() {
            return this.wrapped().maxValue();
        }
    }
}

