/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.RandomSource;

public class MarsagliaPolarGaussian {
    public final RandomSource randomSource;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian;

    public MarsagliaPolarGaussian(RandomSource var0) {
        this.randomSource = var0;
    }

    public void reset() {
        this.haveNextNextGaussian = false;
    }

    public double nextGaussian() {
        double var2;
        double var0;
        double var4;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        do {
            var0 = 2.0 * this.randomSource.nextDouble() - 1.0;
            var2 = 2.0 * this.randomSource.nextDouble() - 1.0;
        } while ((var4 = MathHelper.square(var0) + MathHelper.square(var2)) >= 1.0 || var4 == 0.0);
        double var6 = Math.sqrt(-2.0 * Math.log(var4) / var4);
        this.nextNextGaussian = var2 * var6;
        this.haveNextNextGaussian = true;
        return var0 * var6;
    }
}

