/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class GeneratorSettings {
    public static final Codec<GeneratorSettings> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(GeneratorSettings::seed), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(GeneratorSettings::generateFeatures), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(GeneratorSettings::generateBonusChest), (App)RegistryCodecs.dataPackAwareCodec(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.stable(), WorldDimension.CODEC).xmap(WorldDimension::sortMap, Function.identity()).fieldOf("dimensions").forGetter(GeneratorSettings::dimensions), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(var0 -> var0.legacyCustomOptions)).apply((Applicative)var02, var02.stable(GeneratorSettings::new))).comapFlatMap(GeneratorSettings::guardExperimental, Function.identity());
    private static final Logger LOGGER = LogUtils.getLogger();
    private final long seed;
    private final boolean generateFeatures;
    private final boolean generateBonusChest;
    private final IRegistry<WorldDimension> dimensions;
    private final Optional<String> legacyCustomOptions;

    private DataResult<GeneratorSettings> guardExperimental() {
        WorldDimension var0 = this.dimensions.get(WorldDimension.OVERWORLD);
        if (var0 == null) {
            return DataResult.error((String)"Overworld settings missing");
        }
        if (this.stable()) {
            return DataResult.success((Object)this, (Lifecycle)Lifecycle.stable());
        }
        return DataResult.success((Object)this);
    }

    private boolean stable() {
        return WorldDimension.stable(this.seed, this.dimensions);
    }

    public GeneratorSettings(long var0, boolean var2, boolean var3, IRegistry<WorldDimension> var4) {
        this(var0, var2, var3, var4, Optional.empty());
        WorldDimension var5 = var4.get(WorldDimension.OVERWORLD);
        if (var5 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    private GeneratorSettings(long var0, boolean var2, boolean var3, IRegistry<WorldDimension> var4, Optional<String> var5) {
        this.seed = var0;
        this.generateFeatures = var2;
        this.generateBonusChest = var3;
        this.dimensions = var4;
        this.legacyCustomOptions = var5;
    }

    public static GeneratorSettings demoSettings(IRegistryCustom var0) {
        int var1 = "North Carolina".hashCode();
        return new GeneratorSettings(var1, true, true, GeneratorSettings.withOverworld(var0.registryOrThrow(IRegistry.DIMENSION_TYPE_REGISTRY), DimensionManager.defaultDimensions(var0, var1), (ChunkGenerator)GeneratorSettings.makeDefaultOverworld(var0, var1)));
    }

    public static GeneratorSettings makeDefault(IRegistryCustom var0) {
        long var1 = new Random().nextLong();
        return new GeneratorSettings(var1, true, false, GeneratorSettings.withOverworld(var0.registryOrThrow(IRegistry.DIMENSION_TYPE_REGISTRY), DimensionManager.defaultDimensions(var0, var1), (ChunkGenerator)GeneratorSettings.makeDefaultOverworld(var0, var1)));
    }

    public static ChunkGeneratorAbstract makeDefaultOverworld(IRegistryCustom var0, long var1) {
        return GeneratorSettings.makeDefaultOverworld(var0, var1, true);
    }

    public static ChunkGeneratorAbstract makeDefaultOverworld(IRegistryCustom var0, long var1, boolean var3) {
        return GeneratorSettings.makeOverworld(var0, var1, GeneratorSettingBase.OVERWORLD, var3);
    }

    public static ChunkGeneratorAbstract makeOverworld(IRegistryCustom var0, long var1, ResourceKey<GeneratorSettingBase> var3) {
        return GeneratorSettings.makeOverworld(var0, var1, var3, true);
    }

    public static ChunkGeneratorAbstract makeOverworld(IRegistryCustom var0, long var1, ResourceKey<GeneratorSettingBase> var3, boolean var4) {
        IRegistry<BiomeBase> var5 = var0.registryOrThrow(IRegistry.BIOME_REGISTRY);
        IRegistry<StructureSet> var6 = var0.registryOrThrow(IRegistry.STRUCTURE_SET_REGISTRY);
        IRegistry<GeneratorSettingBase> var7 = var0.registryOrThrow(IRegistry.NOISE_GENERATOR_SETTINGS_REGISTRY);
        IRegistry<NoiseGeneratorNormal.a> var8 = var0.registryOrThrow(IRegistry.NOISE_REGISTRY);
        return new ChunkGeneratorAbstract(var6, var8, (WorldChunkManager)WorldChunkManagerMultiNoise.a.OVERWORLD.biomeSource(var5, var4), var1, var7.getOrCreateHolder(var3));
    }

    public long seed() {
        return this.seed;
    }

    public boolean generateFeatures() {
        return this.generateFeatures;
    }

    public boolean generateBonusChest() {
        return this.generateBonusChest;
    }

    public static IRegistry<WorldDimension> withOverworld(IRegistry<DimensionManager> var0, IRegistry<WorldDimension> var1, ChunkGenerator var2) {
        WorldDimension var3 = var1.get(WorldDimension.OVERWORLD);
        Holder<DimensionManager> var4 = var3 == null ? var0.getOrCreateHolder(DimensionManager.OVERWORLD_LOCATION) : var3.typeHolder();
        return GeneratorSettings.withOverworld(var1, var4, var2);
    }

    public static IRegistry<WorldDimension> withOverworld(IRegistry<WorldDimension> var0, Holder<DimensionManager> var1, ChunkGenerator var2) {
        RegistryMaterials<WorldDimension> var3 = new RegistryMaterials<WorldDimension>(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.experimental(), null);
        ((IRegistryWritable)var3).register(WorldDimension.OVERWORLD, new WorldDimension(var1, var2), Lifecycle.stable());
        for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> var5 : var0.entrySet()) {
            ResourceKey<WorldDimension> var6 = var5.getKey();
            if (var6 == WorldDimension.OVERWORLD) continue;
            ((IRegistryWritable)var3).register(var6, var5.getValue(), var0.lifecycle(var5.getValue()));
        }
        return var3;
    }

    public IRegistry<WorldDimension> dimensions() {
        return this.dimensions;
    }

    public ChunkGenerator overworld() {
        WorldDimension var0 = this.dimensions.get(WorldDimension.OVERWORLD);
        if (var0 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return var0.generator();
    }

    public ImmutableSet<ResourceKey<World>> levels() {
        return (ImmutableSet)this.dimensions().entrySet().stream().map(Map.Entry::getKey).map(GeneratorSettings::levelStemToLevel).collect(ImmutableSet.toImmutableSet());
    }

    public static ResourceKey<World> levelStemToLevel(ResourceKey<WorldDimension> var0) {
        return ResourceKey.create(IRegistry.DIMENSION_REGISTRY, var0.location());
    }

    public static ResourceKey<WorldDimension> levelToLevelStem(ResourceKey<World> var0) {
        return ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, var0.location());
    }

    public boolean isDebug() {
        return this.overworld() instanceof ChunkProviderDebug;
    }

    public boolean isFlatWorld() {
        return this.overworld() instanceof ChunkProviderFlat;
    }

    public boolean isOldCustomizedWorld() {
        return this.legacyCustomOptions.isPresent();
    }

    public GeneratorSettings withBonusChest() {
        return new GeneratorSettings(this.seed, this.generateFeatures, true, this.dimensions, this.legacyCustomOptions);
    }

    public GeneratorSettings withFeaturesToggled() {
        return new GeneratorSettings(this.seed, !this.generateFeatures, this.generateBonusChest, this.dimensions);
    }

    public GeneratorSettings withBonusChestToggled() {
        return new GeneratorSettings(this.seed, this.generateFeatures, !this.generateBonusChest, this.dimensions);
    }

    public static GeneratorSettings create(IRegistryCustom var0, DedicatedServerProperties.a var1) {
        long var2 = GeneratorSettings.parseSeed(var1.levelSeed()).orElse(new Random().nextLong());
        IRegistry<DimensionManager> var4 = var0.registryOrThrow(IRegistry.DIMENSION_TYPE_REGISTRY);
        IRegistry<BiomeBase> var5 = var0.registryOrThrow(IRegistry.BIOME_REGISTRY);
        IRegistry<StructureSet> var6 = var0.registryOrThrow(IRegistry.STRUCTURE_SET_REGISTRY);
        IRegistry<WorldDimension> var7 = DimensionManager.defaultDimensions(var0, var2);
        switch (var1.levelType()) {
            case "flat": {
                Dynamic var10 = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)var1.generatorSettings());
                return new GeneratorSettings(var2, var1.generateStructures(), false, GeneratorSettings.withOverworld(var4, var7, (ChunkGenerator)new ChunkProviderFlat(var6, GeneratorSettingsFlat.CODEC.parse(var10).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(() -> GeneratorSettingsFlat.getDefault(var5, var6)))));
            }
            case "debug_all_block_states": {
                return new GeneratorSettings(var2, var1.generateStructures(), false, GeneratorSettings.withOverworld(var4, var7, (ChunkGenerator)new ChunkProviderDebug(var6, var5)));
            }
            case "amplified": {
                return new GeneratorSettings(var2, var1.generateStructures(), false, GeneratorSettings.withOverworld(var4, var7, (ChunkGenerator)GeneratorSettings.makeOverworld(var0, var2, GeneratorSettingBase.AMPLIFIED)));
            }
            case "largebiomes": {
                return new GeneratorSettings(var2, var1.generateStructures(), false, GeneratorSettings.withOverworld(var4, var7, (ChunkGenerator)GeneratorSettings.makeOverworld(var0, var2, GeneratorSettingBase.LARGE_BIOMES)));
            }
        }
        return new GeneratorSettings(var2, var1.generateStructures(), false, GeneratorSettings.withOverworld(var4, var7, (ChunkGenerator)GeneratorSettings.makeDefaultOverworld(var0, var2)));
    }

    public GeneratorSettings withSeed(boolean var0, OptionalLong var1) {
        IRegistry<WorldDimension> var5;
        long var3 = var1.orElse(this.seed);
        if (var1.isPresent()) {
            RegistryMaterials<WorldDimension> var6 = new RegistryMaterials<WorldDimension>(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.experimental(), null);
            long var7 = var1.getAsLong();
            for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> var10 : this.dimensions.entrySet()) {
                ResourceKey<WorldDimension> var11 = var10.getKey();
                ((IRegistryWritable)var6).register(var11, new WorldDimension(var10.getValue().typeHolder(), var10.getValue().generator().withSeed(var7)), this.dimensions.lifecycle(var10.getValue()));
            }
            var5 = var6;
        } else {
            var5 = this.dimensions;
        }
        GeneratorSettings var2 = this.isDebug() ? new GeneratorSettings(var3, false, false, var5) : new GeneratorSettings(var3, this.generateFeatures(), this.generateBonusChest() && !var0, var5);
        return var2;
    }

    public static OptionalLong parseSeed(String var0) {
        if (StringUtils.isEmpty((CharSequence)(var0 = var0.trim()))) {
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(Long.parseLong(var0));
        }
        catch (NumberFormatException var1) {
            return OptionalLong.of(var0.hashCode());
        }
    }
}

