/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.blending.Blender;

public interface DensityFunction {
    public static final Codec<DensityFunction> DIRECT_CODEC = DensityFunctions.DIRECT_CODEC;
    public static final Codec<Holder<DensityFunction>> CODEC = RegistryFileCodec.create(IRegistry.DENSITY_FUNCTION_REGISTRY, DIRECT_CODEC);
    public static final Codec<DensityFunction> HOLDER_HELPER_CODEC = CODEC.xmap(DensityFunctions.j::new, var0 -> {
        if (var0 instanceof DensityFunctions.j) {
            DensityFunctions.j var1 = (DensityFunctions.j)var0;
            return var1.function();
        }
        return new Holder.a<DensityFunction>((DensityFunction)var0);
    });

    public double compute(b var1);

    public void fillArray(double[] var1, a var2);

    public DensityFunction mapAll(e var1);

    public double minValue();

    public double maxValue();

    public Codec<? extends DensityFunction> codec();

    default public DensityFunction clamp(double var0, double var2) {
        return new DensityFunctions.g(this, var0, var2);
    }

    default public DensityFunction abs() {
        return DensityFunctions.map(this, DensityFunctions.k.a.ABS);
    }

    default public DensityFunction square() {
        return DensityFunctions.map(this, DensityFunctions.k.a.SQUARE);
    }

    default public DensityFunction cube() {
        return DensityFunctions.map(this, DensityFunctions.k.a.CUBE);
    }

    default public DensityFunction halfNegative() {
        return DensityFunctions.map(this, DensityFunctions.k.a.HALF_NEGATIVE);
    }

    default public DensityFunction quarterNegative() {
        return DensityFunctions.map(this, DensityFunctions.k.a.QUARTER_NEGATIVE);
    }

    default public DensityFunction squeeze() {
        return DensityFunctions.map(this, DensityFunctions.k.a.SQUEEZE);
    }

    public record d(int blockX, int blockY, int blockZ) implements b
    {
    }

    public static interface b {
        public int blockX();

        public int blockY();

        public int blockZ();

        default public Blender getBlender() {
            return Blender.empty();
        }
    }

    public static interface c
    extends DensityFunction {
        @Override
        default public void fillArray(double[] var0, a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        default public DensityFunction mapAll(e var0) {
            return (DensityFunction)var0.apply(this);
        }
    }

    public static interface e
    extends Function<DensityFunction, DensityFunction> {
    }

    public static interface a {
        public b forIndex(int var1);

        public void fillAllDirectly(double[] var1, DensityFunction var2);
    }
}

