/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import org.apache.commons.lang3.mutable.MutableDouble;

public interface Aquifer {
    public static Aquifer create(NoiseChunk var0, ChunkCoordIntPair var1, DensityFunction var2, DensityFunction var3, DensityFunction var4, DensityFunction var5, PositionalRandomFactory var6, int var7, int var8, a var9) {
        return new c(var0, var1, var2, var3, var4, var5, var6, var7, var8, var9);
    }

    public static Aquifer createDisabled(final a var0) {
        return new Aquifer(){

            @Override
            @Nullable
            public IBlockData computeSubstance(DensityFunction.b var02, double var1) {
                if (var1 > 0.0) {
                    return null;
                }
                return var0.computeFluid(var02.blockX(), var02.blockY(), var02.blockZ()).at(var02.blockY());
            }

            @Override
            public boolean shouldScheduleFluidUpdate() {
                return false;
            }
        };
    }

    @Nullable
    public IBlockData computeSubstance(DensityFunction.b var1, double var2);

    public boolean shouldScheduleFluidUpdate();

    public static class c
    implements Aquifer {
        private static final int X_RANGE = 10;
        private static final int Y_RANGE = 9;
        private static final int Z_RANGE = 10;
        private static final int X_SEPARATION = 6;
        private static final int Y_SEPARATION = 3;
        private static final int Z_SEPARATION = 6;
        private static final int X_SPACING = 16;
        private static final int Y_SPACING = 12;
        private static final int Z_SPACING = 16;
        private static final int MAX_REASONABLE_DISTANCE_TO_AQUIFER_CENTER = 11;
        private static final double FLOWING_UPDATE_SIMULARITY = c.similarity(MathHelper.square(10), MathHelper.square(12));
        private final NoiseChunk noiseChunk;
        private final DensityFunction barrierNoise;
        private final DensityFunction fluidLevelFloodednessNoise;
        private final DensityFunction fluidLevelSpreadNoise;
        private final DensityFunction lavaNoise;
        private final PositionalRandomFactory positionalRandomFactory;
        private final b[] aquiferCache;
        private final long[] aquiferLocationCache;
        private final a globalFluidPicker;
        private boolean shouldScheduleFluidUpdate;
        private final int minGridX;
        private final int minGridY;
        private final int minGridZ;
        private final int gridSizeX;
        private final int gridSizeZ;
        private static final int[][] SURFACE_SAMPLING_OFFSETS_IN_CHUNKS = new int[][]{{-2, -1}, {-1, -1}, {0, -1}, {1, -1}, {-3, 0}, {-2, 0}, {-1, 0}, {0, 0}, {1, 0}, {-2, 1}, {-1, 1}, {0, 1}, {1, 1}};

        c(NoiseChunk var0, ChunkCoordIntPair var1, DensityFunction var2, DensityFunction var3, DensityFunction var4, DensityFunction var5, PositionalRandomFactory var6, int var7, int var8, a var9) {
            this.noiseChunk = var0;
            this.barrierNoise = var2;
            this.fluidLevelFloodednessNoise = var3;
            this.fluidLevelSpreadNoise = var4;
            this.lavaNoise = var5;
            this.positionalRandomFactory = var6;
            this.minGridX = this.gridX(var1.getMinBlockX()) - 1;
            this.globalFluidPicker = var9;
            int var10 = this.gridX(var1.getMaxBlockX()) + 1;
            this.gridSizeX = var10 - this.minGridX + 1;
            this.minGridY = this.gridY(var7) - 1;
            int var11 = this.gridY(var7 + var8) + 1;
            int var12 = var11 - this.minGridY + 1;
            this.minGridZ = this.gridZ(var1.getMinBlockZ()) - 1;
            int var13 = this.gridZ(var1.getMaxBlockZ()) + 1;
            this.gridSizeZ = var13 - this.minGridZ + 1;
            int var14 = this.gridSizeX * var12 * this.gridSizeZ;
            this.aquiferCache = new b[var14];
            this.aquiferLocationCache = new long[var14];
            Arrays.fill(this.aquiferLocationCache, Long.MAX_VALUE);
        }

        private int getIndex(int var0, int var1, int var2) {
            int var3 = var0 - this.minGridX;
            int var4 = var1 - this.minGridY;
            int var5 = var2 - this.minGridZ;
            return (var4 * this.gridSizeZ + var5) * this.gridSizeX + var3;
        }

        @Override
        @Nullable
        public IBlockData computeSubstance(DensityFunction.b var0, double var1) {
            double var33;
            double var31;
            IBlockData var22;
            int var3 = var0.blockX();
            int var4 = var0.blockY();
            int var5 = var0.blockZ();
            if (var1 > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            b var6 = this.globalFluidPicker.computeFluid(var3, var4, var5);
            if (var6.at(var4).is(Blocks.LAVA)) {
                this.shouldScheduleFluidUpdate = false;
                return Blocks.LAVA.defaultBlockState();
            }
            int var7 = Math.floorDiv(var3 - 5, 16);
            int var8 = Math.floorDiv(var4 + 1, 12);
            int var9 = Math.floorDiv(var5 - 5, 16);
            int var10 = Integer.MAX_VALUE;
            int var11 = Integer.MAX_VALUE;
            int var12 = Integer.MAX_VALUE;
            long var13 = 0L;
            long var15 = 0L;
            long var17 = 0L;
            for (int var19 = 0; var19 <= 1; ++var19) {
                for (int var20 = -1; var20 <= 1; ++var20) {
                    for (int var21 = 0; var21 <= 1; ++var21) {
                        long var26;
                        int var222 = var7 + var19;
                        int var23 = var8 + var20;
                        int var24 = var9 + var21;
                        int var25 = this.getIndex(var222, var23, var24);
                        long var28 = this.aquiferLocationCache[var25];
                        if (var28 != Long.MAX_VALUE) {
                            var26 = var28;
                        } else {
                            RandomSource var30 = this.positionalRandomFactory.at(var222, var23, var24);
                            this.aquiferLocationCache[var25] = var26 = BlockPosition.asLong(var222 * 16 + var30.nextInt(10), var23 * 12 + var30.nextInt(9), var24 * 16 + var30.nextInt(10));
                        }
                        int var30 = BlockPosition.getX(var26) - var3;
                        int var312 = BlockPosition.getY(var26) - var4;
                        int var32 = BlockPosition.getZ(var26) - var5;
                        int var332 = var30 * var30 + var312 * var312 + var32 * var32;
                        if (var10 >= var332) {
                            var17 = var15;
                            var15 = var13;
                            var13 = var26;
                            var12 = var11;
                            var11 = var10;
                            var10 = var332;
                            continue;
                        }
                        if (var11 >= var332) {
                            var17 = var15;
                            var15 = var26;
                            var12 = var11;
                            var11 = var332;
                            continue;
                        }
                        if (var12 < var332) continue;
                        var17 = var26;
                        var12 = var332;
                    }
                }
            }
            b var19 = this.getAquiferStatus(var13);
            double var20 = c.similarity(var10, var11);
            IBlockData var23 = var22 = var19.at(var4);
            if (var20 <= 0.0) {
                this.shouldScheduleFluidUpdate = var20 >= FLOWING_UPDATE_SIMULARITY;
                return var23;
            }
            if (var22.is(Blocks.WATER) && this.globalFluidPicker.computeFluid(var3, var4 - 1, var5).at(var4 - 1).is(Blocks.LAVA)) {
                this.shouldScheduleFluidUpdate = true;
                return var23;
            }
            MutableDouble var24 = new MutableDouble(Double.NaN);
            b var25 = this.getAquiferStatus(var15);
            double var26 = var20 * this.calculatePressure(var0, var24, var19, var25);
            if (var1 + var26 > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            b var28 = this.getAquiferStatus(var17);
            double var29 = c.similarity(var10, var12);
            if (var29 > 0.0 && var1 + (var31 = var20 * var29 * this.calculatePressure(var0, var24, var19, var28)) > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            double var313 = c.similarity(var11, var12);
            if (var313 > 0.0 && var1 + (var33 = var20 * var313 * this.calculatePressure(var0, var24, var25, var28)) > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            this.shouldScheduleFluidUpdate = true;
            return var23;
        }

        @Override
        public boolean shouldScheduleFluidUpdate() {
            return this.shouldScheduleFluidUpdate;
        }

        private static double similarity(int var0, int var1) {
            double var2 = 25.0;
            return 1.0 - (double)Math.abs(var1 - var0) / 25.0;
        }

        private double calculatePressure(DensityFunction.b var0, MutableDouble var1, b var2, b var3) {
            double var32;
            double var30;
            int var4 = var0.blockY();
            IBlockData var5 = var2.at(var4);
            IBlockData var6 = var3.at(var4);
            if (var5.is(Blocks.LAVA) && var6.is(Blocks.WATER) || var5.is(Blocks.WATER) && var6.is(Blocks.LAVA)) {
                return 2.0;
            }
            int var7 = Math.abs(var2.fluidLevel - var3.fluidLevel);
            if (var7 == 0) {
                return 0.0;
            }
            double var8 = 0.5 * (double)(var2.fluidLevel + var3.fluidLevel);
            double var10 = (double)var4 + 0.5 - var8;
            double var12 = (double)var7 / 2.0;
            double var14 = 0.0;
            double var16 = 2.5;
            double var18 = 1.5;
            double var20 = 3.0;
            double var22 = 10.0;
            double var24 = 3.0;
            double var26 = var12 - Math.abs(var10);
            double var28 = var10 > 0.0 ? ((var30 = 0.0 + var26) > 0.0 ? var30 / 1.5 : var30 / 2.5) : ((var30 = 3.0 + var26) > 0.0 ? var30 / 3.0 : var30 / 10.0);
            var30 = 2.0;
            if (var28 < -2.0 || var28 > 2.0) {
                var32 = 0.0;
            } else {
                double var34 = var1.getValue();
                if (Double.isNaN(var34)) {
                    double var36 = this.barrierNoise.compute(var0);
                    var1.setValue(var36);
                    var32 = var36;
                } else {
                    var32 = var34;
                }
            }
            return 2.0 * (var32 + var28);
        }

        private int gridX(int var0) {
            return Math.floorDiv(var0, 16);
        }

        private int gridY(int var0) {
            return Math.floorDiv(var0, 12);
        }

        private int gridZ(int var0) {
            return Math.floorDiv(var0, 16);
        }

        private b getAquiferStatus(long var0) {
            b var10;
            int var7;
            int var6;
            int var2 = BlockPosition.getX(var0);
            int var3 = BlockPosition.getY(var0);
            int var4 = BlockPosition.getZ(var0);
            int var5 = this.gridX(var2);
            int var8 = this.getIndex(var5, var6 = this.gridY(var3), var7 = this.gridZ(var4));
            b var9 = this.aquiferCache[var8];
            if (var9 != null) {
                return var9;
            }
            this.aquiferCache[var8] = var10 = this.computeFluid(var2, var3, var4);
            return var10;
        }

        private b computeFluid(int var0, int var1, int var2) {
            double var14;
            b var3 = this.globalFluidPicker.computeFluid(var0, var1, var2);
            int var4 = Integer.MAX_VALUE;
            int var5 = var1 + 12;
            int var6 = var1 - 12;
            boolean var7 = false;
            for (int[] var11 : SURFACE_SAMPLING_OFFSETS_IN_CHUNKS) {
                b var18;
                boolean var17;
                boolean var16;
                int var12 = var0 + SectionPosition.sectionToBlockCoord(var11[0]);
                int var13 = var2 + SectionPosition.sectionToBlockCoord(var11[1]);
                int var142 = this.noiseChunk.preliminarySurfaceLevel(var12, var13);
                int var15 = var142 + 8;
                boolean bl = var16 = var11[0] == 0 && var11[1] == 0;
                if (var16 && var6 > var15) {
                    return var3;
                }
                boolean bl2 = var17 = var5 > var15;
                if ((var17 || var16) && !(var18 = this.globalFluidPicker.computeFluid(var12, var15, var13)).at(var15).isAir()) {
                    if (var16) {
                        var7 = true;
                    }
                    if (var17) {
                        return var18;
                    }
                }
                var4 = Math.min(var4, var142);
            }
            int var8 = var4 + 8 - var1;
            int var9 = 64;
            double var10 = var7 ? MathHelper.clampedMap((double)var8, 0.0, 64.0, 1.0, 0.0) : 0.0;
            double var12 = MathHelper.clamp(this.fluidLevelFloodednessNoise.compute(new DensityFunction.d(var0, var1, var2)), -1.0, 1.0);
            if (var12 > (var14 = MathHelper.map(var10, 1.0, 0.0, -0.3, 0.8))) {
                return var3;
            }
            double var16 = MathHelper.map(var10, 1.0, 0.0, -0.8, 0.4);
            if (var12 <= var16) {
                return new b(DimensionManager.WAY_BELOW_MIN_Y, var3.fluidType);
            }
            int var18 = 16;
            int var19 = 40;
            int var20 = Math.floorDiv(var0, 16);
            int var21 = Math.floorDiv(var1, 40);
            int var22 = Math.floorDiv(var2, 16);
            int var23 = var21 * 40 + 20;
            int var24 = 10;
            double var25 = this.fluidLevelSpreadNoise.compute(new DensityFunction.d(var20, var21, var22)) * 10.0;
            int var27 = MathHelper.quantize(var25, 3);
            int var28 = var23 + var27;
            int var29 = Math.min(var4, var28);
            if (var28 <= -10) {
                int var34;
                int var33;
                int var30 = 64;
                int var31 = 40;
                int var32 = Math.floorDiv(var0, 64);
                double var35 = this.lavaNoise.compute(new DensityFunction.d(var32, var33 = Math.floorDiv(var1, 40), var34 = Math.floorDiv(var2, 64)));
                if (Math.abs(var35) > 0.3) {
                    return new b(var29, Blocks.LAVA.defaultBlockState());
                }
            }
            return new b(var29, var3.fluidType);
        }
    }

    public static interface a {
        public b computeFluid(int var1, int var2, int var3);
    }

    public static final class b {
        final int fluidLevel;
        final IBlockData fluidType;

        public b(int var0, IBlockData var1) {
            this.fluidLevel = var0;
            this.fluidType = var1;
        }

        public IBlockData at(int var0) {
            return var0 < this.fluidLevel ? this.fluidType : Blocks.AIR.defaultBlockState();
        }
    }
}

