/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationPath;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public class VibrationListener
implements GameEventListener {
    protected final PositionSource listenerSource;
    protected final int listenerRange;
    protected final a config;
    protected Optional<GameEvent> receivingEvent = Optional.empty();
    protected int receivingDistance;
    protected int travelTimeInTicks = 0;

    public VibrationListener(PositionSource var0, int var1, a var2) {
        this.listenerSource = var0;
        this.listenerRange = var1;
        this.config = var2;
    }

    public void tick(World var0) {
        if (this.receivingEvent.isPresent()) {
            --this.travelTimeInTicks;
            if (this.travelTimeInTicks <= 0) {
                this.travelTimeInTicks = 0;
                this.config.onSignalReceive(var0, this, this.receivingEvent.get(), this.receivingDistance);
                this.receivingEvent = Optional.empty();
            }
        }
    }

    @Override
    public PositionSource getListenerSource() {
        return this.listenerSource;
    }

    @Override
    public int getListenerRadius() {
        return this.listenerRange;
    }

    @Override
    public boolean handleGameEvent(World var0, GameEvent var1, @Nullable Entity var2, BlockPosition var3) {
        if (!this.isValidVibration(var1, var2)) {
            return false;
        }
        Optional<BlockPosition> var4 = this.listenerSource.getPosition(var0);
        if (!var4.isPresent()) {
            return false;
        }
        BlockPosition var5 = var4.get();
        if (!this.config.shouldListen(var0, this, var3, var1, var2)) {
            return false;
        }
        if (this.isOccluded(var0, var3, var5)) {
            return false;
        }
        this.sendSignal(var0, var1, var3, var5);
        return true;
    }

    private boolean isValidVibration(GameEvent var0, @Nullable Entity var1) {
        if (this.receivingEvent.isPresent()) {
            return false;
        }
        if (!var0.is(GameEventTags.VIBRATIONS)) {
            return false;
        }
        if (var1 != null) {
            if (var0.is(GameEventTags.IGNORE_VIBRATIONS_SNEAKING) && var1.isSteppingCarefully()) {
                return false;
            }
            if (var1.occludesVibrations()) {
                return false;
            }
        }
        return var1 == null || !var1.isSpectator();
    }

    private void sendSignal(World var0, GameEvent var1, BlockPosition var2, BlockPosition var3) {
        this.receivingEvent = Optional.of(var1);
        if (var0 instanceof WorldServer) {
            this.travelTimeInTicks = this.receivingDistance = MathHelper.floor(Math.sqrt(var2.distSqr(var3)));
            ((WorldServer)var0).sendVibrationParticle(new VibrationPath(var2, this.listenerSource, this.travelTimeInTicks));
        }
    }

    private boolean isOccluded(World var02, BlockPosition var1, BlockPosition var2) {
        return var02.isBlockInLine(new ClipBlockStateContext(Vec3D.atCenterOf(var1), Vec3D.atCenterOf(var2), var0 -> var0.is(TagsBlock.OCCLUDES_VIBRATION_SIGNALS))).getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK;
    }

    public static interface a {
        public boolean shouldListen(World var1, GameEventListener var2, BlockPosition var3, GameEvent var4, @Nullable Entity var5);

        public void onSignalReceive(World var1, GameEventListener var2, GameEvent var3, int var4);
    }
}

