/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.gameevent.GameEventListener;

public class GameEventListenerRegistrar {
    private final GameEventListener listener;
    @Nullable
    private SectionPosition sectionPos;

    public GameEventListenerRegistrar(GameEventListener var0) {
        this.listener = var0;
    }

    public void onListenerRemoved(World var02) {
        this.ifEventDispatcherExists(var02, this.sectionPos, var0 -> var0.unregister(this.listener));
    }

    public void onListenerMove(World var02) {
        Optional<BlockPosition> var1 = this.listener.getListenerSource().getPosition(var02);
        if (var1.isPresent()) {
            long var2 = SectionPosition.blockToSection(var1.get().asLong());
            if (this.sectionPos == null || this.sectionPos.asLong() != var2) {
                SectionPosition var4 = this.sectionPos;
                this.sectionPos = SectionPosition.of(var2);
                this.ifEventDispatcherExists(var02, var4, var0 -> var0.unregister(this.listener));
                this.ifEventDispatcherExists(var02, this.sectionPos, var0 -> var0.register(this.listener));
            }
        }
    }

    private void ifEventDispatcherExists(World var0, @Nullable SectionPosition var1, Consumer<GameEventDispatcher> var2) {
        if (var1 == null) {
            return;
        }
        IChunkAccess var3 = var0.getChunk(var1.x(), var1.z(), ChunkStatus.FULL, false);
        if (var3 != null) {
            var2.accept(var3.getEventDispatcher(var1.y()));
        }
    }
}

