/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.util.EntitySlice;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public class EntitySection<T extends EntityAccess> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final EntitySlice<T> storage;
    private Visibility chunkStatus;

    public EntitySection(Class<T> var0, Visibility var1) {
        this.chunkStatus = var1;
        this.storage = new EntitySlice<T>(var0);
    }

    public void add(T var0) {
        this.storage.add(var0);
    }

    public boolean remove(T var0) {
        return this.storage.remove(var0);
    }

    public void getEntities(AxisAlignedBB var0, Consumer<T> var1) {
        for (EntityAccess var3 : this.storage) {
            if (!var3.getBoundingBox().intersects(var0)) continue;
            var1.accept(var3);
        }
    }

    public <U extends T> void getEntities(EntityTypeTest<T, U> var0, AxisAlignedBB var1, Consumer<? super U> var2) {
        Collection<T> var3 = this.storage.find(var0.getBaseClass());
        if (var3.isEmpty()) {
            return;
        }
        for (EntityAccess var5 : var3) {
            EntityAccess var6 = (EntityAccess)var0.tryCast(var5);
            if (var6 == null || !var5.getBoundingBox().intersects(var1)) continue;
            var2.accept(var6);
        }
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public Stream<T> getEntities() {
        return this.storage.stream();
    }

    public Visibility getStatus() {
        return this.chunkStatus;
    }

    public Visibility updateChunkStatus(Visibility var0) {
        Visibility var1 = this.chunkStatus;
        this.chunkStatus = var0;
        return var1;
    }

    @VisibleForDebug
    public int size() {
        return this.storage.size();
    }
}

