/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;

public final class WorldDimension {
    public static final Codec<WorldDimension> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)DimensionManager.CODEC.fieldOf("type").forGetter(WorldDimension::typeHolder), (App)ChunkGenerator.CODEC.fieldOf("generator").forGetter(WorldDimension::generator)).apply((Applicative)var0, var0.stable(WorldDimension::new)));
    public static final ResourceKey<WorldDimension> OVERWORLD = ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, new MinecraftKey("overworld"));
    public static final ResourceKey<WorldDimension> NETHER = ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, new MinecraftKey("the_nether"));
    public static final ResourceKey<WorldDimension> END = ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, new MinecraftKey("the_end"));
    private static final Set<ResourceKey<WorldDimension>> BUILTIN_ORDER = ImmutableSet.of(OVERWORLD, NETHER, END);
    private final Holder<DimensionManager> type;
    private final ChunkGenerator generator;

    public WorldDimension(Holder<DimensionManager> var0, ChunkGenerator var1) {
        this.type = var0;
        this.generator = var1;
    }

    public Holder<DimensionManager> typeHolder() {
        return this.type;
    }

    public ChunkGenerator generator() {
        return this.generator;
    }

    public static IRegistry<WorldDimension> sortMap(IRegistry<WorldDimension> var0) {
        Object var4;
        RegistryMaterials<WorldDimension> var1 = new RegistryMaterials<WorldDimension>(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.experimental(), null);
        for (ResourceKey<WorldDimension> resourceKey : BUILTIN_ORDER) {
            var4 = var0.get(resourceKey);
            if (var4 == null) continue;
            ((IRegistryWritable)var1).register(resourceKey, (WorldDimension)var4, var0.lifecycle((WorldDimension)var4));
        }
        for (Map.Entry entry : var0.entrySet()) {
            var4 = (ResourceKey)entry.getKey();
            if (BUILTIN_ORDER.contains(var4)) continue;
            ((IRegistryWritable)var1).register((ResourceKey<WorldDimension>)var4, (WorldDimension)entry.getValue(), var0.lifecycle((WorldDimension)entry.getValue()));
        }
        return var1;
    }

    public static boolean stable(long var0, IRegistry<WorldDimension> var2) {
        if (var2.size() != BUILTIN_ORDER.size()) {
            return false;
        }
        Optional<WorldDimension> var3 = var2.getOptional(OVERWORLD);
        Optional<WorldDimension> var4 = var2.getOptional(NETHER);
        Optional<WorldDimension> var5 = var2.getOptional(END);
        if (var3.isEmpty() || var4.isEmpty() || var5.isEmpty()) {
            return false;
        }
        if (!var3.get().typeHolder().is(DimensionManager.OVERWORLD_LOCATION) && !var3.get().typeHolder().is(DimensionManager.OVERWORLD_CAVES_LOCATION)) {
            return false;
        }
        if (!var4.get().typeHolder().is(DimensionManager.NETHER_LOCATION)) {
            return false;
        }
        if (!var5.get().typeHolder().is(DimensionManager.END_LOCATION)) {
            return false;
        }
        if (!(var4.get().generator() instanceof ChunkGeneratorAbstract) || !(var5.get().generator() instanceof ChunkGeneratorAbstract)) {
            return false;
        }
        ChunkGeneratorAbstract var6 = (ChunkGeneratorAbstract)var4.get().generator();
        ChunkGeneratorAbstract var7 = (ChunkGeneratorAbstract)var5.get().generator();
        if (!var6.stable(var0, GeneratorSettingBase.NETHER)) {
            return false;
        }
        if (!var7.stable(var0, GeneratorSettingBase.END)) {
            return false;
        }
        if (!(var6.getBiomeSource() instanceof WorldChunkManagerMultiNoise)) {
            return false;
        }
        WorldChunkManagerMultiNoise var8 = (WorldChunkManagerMultiNoise)var6.getBiomeSource();
        if (!var8.stable(WorldChunkManagerMultiNoise.a.NETHER)) {
            return false;
        }
        WorldChunkManager var9 = var3.get().generator().getBiomeSource();
        if (var9 instanceof WorldChunkManagerMultiNoise && !((WorldChunkManagerMultiNoise)var9).stable(WorldChunkManagerMultiNoise.a.OVERWORLD)) {
            return false;
        }
        if (!(var7.getBiomeSource() instanceof WorldChunkManagerTheEnd)) {
            return false;
        }
        WorldChunkManagerTheEnd var10 = (WorldChunkManagerTheEnd)var7.getBiomeSource();
        return var10.stable(var0);
    }
}

