/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.PairedQueue;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import org.slf4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final ThreadedMailbox<PairedQueue.b> mailbox;
    private final RegionFileCache storage;
    private final Map<ChunkCoordIntPair, a> pendingWrites = Maps.newLinkedHashMap();

    protected IOWorker(Path var0, boolean var1, String var2) {
        this.storage = new RegionFileCache(var0, var1);
        this.mailbox = new ThreadedMailbox<PairedQueue.b>(new PairedQueue.a(Priority.values().length), SystemUtils.ioPool(), "IOWorker-" + var2);
    }

    public CompletableFuture<Void> store(ChunkCoordIntPair var0, @Nullable NBTTagCompound var1) {
        return this.submitTask(() -> {
            a var2 = this.pendingWrites.computeIfAbsent(var0, var1 -> new a(var1));
            var2.data = var1;
            return Either.left(var2.result);
        }).thenCompose(Function.identity());
    }

    @Nullable
    public NBTTagCompound load(ChunkCoordIntPair var0) throws IOException {
        CompletableFuture<NBTTagCompound> var1 = this.loadAsync(var0);
        try {
            return var1.join();
        }
        catch (CompletionException var2) {
            if (var2.getCause() instanceof IOException) {
                throw (IOException)var2.getCause();
            }
            throw var2;
        }
    }

    protected CompletableFuture<NBTTagCompound> loadAsync(ChunkCoordIntPair var0) {
        return this.submitTask(() -> {
            a var1 = this.pendingWrites.get(var0);
            if (var1 != null) {
                return Either.left((Object)var1.data);
            }
            try {
                NBTTagCompound var2 = this.storage.read(var0);
                return Either.left((Object)var2);
            }
            catch (Exception var2) {
                LOGGER.warn("Failed to read chunk {}", (Object)var0, (Object)var2);
                return Either.right((Object)var2);
            }
        });
    }

    public CompletableFuture<Void> synchronize(boolean var02) {
        CompletionStage var1 = this.submitTask(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.pendingWrites.values().stream().map(var0 -> var0.result).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        if (var02) {
            return ((CompletableFuture)var1).thenCompose(var0 -> this.submitTask(() -> {
                try {
                    this.storage.flush();
                    return Either.left(null);
                }
                catch (Exception var0) {
                    LOGGER.warn("Failed to synchronize chunks", (Throwable)var0);
                    return Either.right((Object)var0);
                }
            }));
        }
        return ((CompletableFuture)var1).thenCompose(var0 -> this.submitTask(() -> Either.left(null)));
    }

    @Override
    public CompletableFuture<Void> scanChunk(ChunkCoordIntPair var0, StreamTagVisitor var1) {
        return this.submitTask(() -> {
            try {
                a var2 = this.pendingWrites.get(var0);
                if (var2 != null) {
                    if (var2.data != null) {
                        var2.data.acceptAsRoot(var1);
                    }
                } else {
                    this.storage.scanChunk(var0, var1);
                }
                return Either.left(null);
            }
            catch (Exception var2) {
                LOGGER.warn("Failed to bulk scan chunk {}", (Object)var0, (Object)var2);
                return Either.right((Object)var2);
            }
        });
    }

    private <T> CompletableFuture<T> submitTask(Supplier<Either<T, Exception>> var0) {
        return this.mailbox.askEither(var1 -> new PairedQueue.b(Priority.FOREGROUND.ordinal(), () -> this.a(var1, (Supplier)var0)));
    }

    private void storePendingChunk() {
        if (this.pendingWrites.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<ChunkCoordIntPair, a>> var0 = this.pendingWrites.entrySet().iterator();
        Map.Entry<ChunkCoordIntPair, a> var1 = var0.next();
        var0.remove();
        this.runStore(var1.getKey(), var1.getValue());
        this.tellStorePending();
    }

    private void tellStorePending() {
        this.mailbox.tell(new PairedQueue.b(Priority.BACKGROUND.ordinal(), this::storePendingChunk));
    }

    private void runStore(ChunkCoordIntPair var0, a var1) {
        try {
            this.storage.write(var0, var1.data);
            var1.result.complete(null);
        }
        catch (Exception var2) {
            LOGGER.error("Failed to store chunk {}", (Object)var0, (Object)var2);
            var1.result.completeExceptionally(var2);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.shutdownRequested.compareAndSet(false, true)) {
            return;
        }
        this.mailbox.ask(var0 -> new PairedQueue.b(Priority.SHUTDOWN.ordinal(), () -> var0.tell(Unit.INSTANCE))).join();
        this.mailbox.close();
        try {
            this.storage.close();
        }
        catch (Exception var02) {
            LOGGER.error("Failed to close storage", (Throwable)var02);
        }
    }

    private /* synthetic */ void a(Mailbox var0, Supplier var1) {
        if (!this.shutdownRequested.get()) {
            var0.tell((Either)var1.get());
        }
        this.tellStorePending();
    }

    static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority FOREGROUND = new Priority();
        public static final /* enum */ Priority BACKGROUND = new Priority();
        public static final /* enum */ Priority SHUTDOWN = new Priority();
        private static final /* synthetic */ Priority[] d;

        public static Priority[] values() {
            return (Priority[])d.clone();
        }

        public static Priority valueOf(String var0) {
            return Enum.valueOf(Priority.class, var0);
        }

        private static /* synthetic */ Priority[] a() {
            return new Priority[]{FOREGROUND, BACKGROUND, SHUTDOWN};
        }

        static {
            d = Priority.a();
        }
    }

    static class a {
        @Nullable
        NBTTagCompound data;
        final CompletableFuture<Void> result = new CompletableFuture();

        public a(@Nullable NBTTagCompound var0) {
            this.data = var0;
        }
    }
}

