/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import org.slf4j.Logger;

public class ChunkRegionLoader {
    public static final Codec<DataPaletteBlock<IBlockData>> BLOCK_STATE_CODEC = DataPaletteBlock.codec(Block.BLOCK_STATE_REGISTRY, IBlockData.CODEC, DataPaletteBlock.e.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";

    public static ProtoChunk read(WorldServer var02, VillagePlace var1, ChunkCoordIntPair var22, NBTTagCompound var3) {
        Object var24;
        EnumSet<HeightMap.Type> var21;
        DataPaletteBlock<Object> var20;
        Object var19;
        ChunkCoordIntPair var4 = new ChunkCoordIntPair(var3.getInt("xPos"), var3.getInt("zPos"));
        if (!Objects.equals(var22, var4)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{var22, var22, var4});
        }
        ChunkConverter var5 = var3.contains(TAG_UPGRADE_DATA, 10) ? new ChunkConverter(var3.getCompound(TAG_UPGRADE_DATA), var02) : ChunkConverter.EMPTY;
        boolean var6 = var3.getBoolean("isLightOn");
        NBTTagList var7 = var3.getList("sections", 10);
        int var8 = var02.getSectionsCount();
        ChunkSection[] var9 = new ChunkSection[var8];
        boolean var10 = var02.dimensionType().hasSkyLight();
        ChunkProviderServer var11 = var02.getChunkSource();
        LightEngine var12 = ((IChunkProvider)var11).getLightEngine();
        if (var6) {
            var12.retainData(var22, true);
        }
        IRegistry<BiomeBase> var13 = var02.registryAccess().registryOrThrow(IRegistry.BIOME_REGISTRY);
        Codec<DataPaletteBlock<Holder<BiomeBase>>> var14 = ChunkRegionLoader.makeBiomeCodec(var13);
        for (int var15 = 0; var15 < var7.size(); ++var15) {
            NBTTagCompound var16 = var7.getCompound(var15);
            byte var17 = var16.getByte("Y");
            int var18 = var02.getSectionIndexFromSectionY(var17);
            if (var18 >= 0 && var18 < var9.length) {
                var19 = var16.contains("block_states", 10) ? (DataPaletteBlock)BLOCK_STATE_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var16.getCompound("block_states")).promotePartial(var2 -> ChunkRegionLoader.logErrors(var22, var17, var2)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)) : new DataPaletteBlock(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), DataPaletteBlock.e.SECTION_STATES);
                var20 = var16.contains("biomes", 10) ? (DataPaletteBlock)var14.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var16.getCompound("biomes")).promotePartial(var2 -> ChunkRegionLoader.logErrors(var22, var17, var2)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)) : new DataPaletteBlock<Holder<BiomeBase>>(var13.asHolderIdMap(), var13.getHolderOrThrow(Biomes.PLAINS), DataPaletteBlock.e.SECTION_BIOMES);
                var21 = new ChunkSection(var17, (DataPaletteBlock<IBlockData>)var19, (DataPaletteBlock<Holder<BiomeBase>>)var20);
                var9[var18] = var21;
                var1.checkConsistencyWithBlocks(var22, (ChunkSection)((Object)var21));
            }
            if (!var6) continue;
            if (var16.contains("BlockLight", 7)) {
                var12.queueSectionData(EnumSkyBlock.BLOCK, SectionPosition.of(var22, var17), new NibbleArray(var16.getByteArray("BlockLight")), true);
            }
            if (!var10 || !var16.contains("SkyLight", 7)) continue;
            var12.queueSectionData(EnumSkyBlock.SKY, SectionPosition.of(var22, var17), new NibbleArray(var16.getByteArray("SkyLight")), true);
        }
        long var15 = var3.getLong("InhabitedTime");
        ChunkStatus.Type var17 = ChunkRegionLoader.getChunkTypeFromTag(var3);
        BlendingData var18 = var3.contains("blending_data", 10) ? (BlendingData)BlendingData.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var3.getCompound("blending_data"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null) : null;
        if (var17 == ChunkStatus.Type.LEVELCHUNK) {
            var20 = LevelChunkTicks.load(var3.getList(BLOCK_TICKS_TAG, 10), var0 -> IRegistry.BLOCK.getOptional(MinecraftKey.tryParse(var0)), var22);
            var21 = LevelChunkTicks.load(var3.getList(FLUID_TICKS_TAG, 10), var0 -> IRegistry.FLUID.getOptional(MinecraftKey.tryParse(var0)), var22);
            var19 = new Chunk(var02.getLevel(), var22, var5, (LevelChunkTicks<Block>)((Object)var20), (LevelChunkTicks<FluidType>)((Object)var21), var15, var9, ChunkRegionLoader.postLoadChunk(var02, var3), var18);
        } else {
            boolean var25;
            Object var222;
            var20 = ProtoChunkTickList.load(var3.getList(BLOCK_TICKS_TAG, 10), var0 -> IRegistry.BLOCK.getOptional(MinecraftKey.tryParse(var0)), var22);
            var21 = ProtoChunkTickList.load(var3.getList(FLUID_TICKS_TAG, 10), var0 -> IRegistry.FLUID.getOptional(MinecraftKey.tryParse(var0)), var22);
            var19 = var222 = new ProtoChunk(var22, var5, var9, (ProtoChunkTickList<Block>)((Object)var20), (ProtoChunkTickList<FluidType>)((Object)var21), var02, var13, var18);
            ((IChunkAccess)var19).setInhabitedTime(var15);
            if (var3.contains("below_zero_retrogen", 10)) {
                BelowZeroRetrogen.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var3.getCompound("below_zero_retrogen"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(((ProtoChunk)var222)::setBelowZeroRetrogen);
            }
            ChunkStatus chunkStatus = ChunkStatus.byName(var3.getString("Status"));
            ((ProtoChunk)var222).setStatus(chunkStatus);
            if (chunkStatus.isOrAfter(ChunkStatus.FEATURES)) {
                ((ProtoChunk)var222).setLightEngine(var12);
            }
            var24 = ((ProtoChunk)var222).getBelowZeroRetrogen();
            boolean bl = var25 = chunkStatus.isOrAfter(ChunkStatus.LIGHT) || var24 != null && ((BelowZeroRetrogen)var24).targetStatus().isOrAfter(ChunkStatus.LIGHT);
            if (!var6 && var25) {
                for (BlockPosition var27 : BlockPosition.betweenClosed(var22.getMinBlockX(), var02.getMinBuildHeight(), var22.getMinBlockZ(), var22.getMaxBlockX(), var02.getMaxBuildHeight() - 1, var22.getMaxBlockZ())) {
                    if (var19.getBlockState(var27).getLightEmission() == 0) continue;
                    ((ProtoChunk)var222).addLight(var27);
                }
            }
        }
        ((IChunkAccess)var19).setLightCorrect(var6);
        var20 = var3.getCompound("Heightmaps");
        var21 = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type type : ((IChunkAccess)var19).getStatus().heightmapsAfter()) {
            var24 = type.getSerializationKey();
            if (((NBTTagCompound)((Object)var20)).contains((String)var24, 12)) {
                ((IChunkAccess)var19).setHeightmap(type, ((NBTTagCompound)((Object)var20)).getLongArray((String)var24));
                continue;
            }
            var21.add(type);
        }
        HeightMap.primeHeightmaps((IChunkAccess)var19, var21);
        NBTTagCompound var222 = var3.getCompound("structures");
        ((IChunkAccess)var19).setAllStarts(ChunkRegionLoader.unpackStructureStart(StructurePieceSerializationContext.fromLevel(var02), var222, var02.getSeed()));
        ((IChunkAccess)var19).setAllReferences(ChunkRegionLoader.unpackStructureReferences(var02.registryAccess(), var22, var222));
        if (var3.getBoolean("shouldSave")) {
            ((IChunkAccess)var19).setUnsaved(true);
        }
        NBTTagList nBTTagList = var3.getList("PostProcessing", 9);
        for (int var242 = 0; var242 < nBTTagList.size(); ++var242) {
            NBTTagList var25 = nBTTagList.getList(var242);
            for (int var26 = 0; var26 < var25.size(); ++var26) {
                ((IChunkAccess)var19).addPackedPostProcess(var25.getShort(var26), var242);
            }
        }
        if (var17 == ChunkStatus.Type.LEVELCHUNK) {
            return new ProtoChunkExtension((Chunk)var19, false);
        }
        ProtoChunk var243 = (ProtoChunk)var19;
        NBTTagList var25 = var3.getList("entities", 10);
        for (int var26 = 0; var26 < var25.size(); ++var26) {
            var243.addEntity(var25.getCompound(var26));
        }
        NBTTagList var26 = var3.getList("block_entities", 10);
        for (int var27 = 0; var27 < var26.size(); ++var27) {
            NBTTagCompound var28 = var26.getCompound(var27);
            ((IChunkAccess)var19).setBlockEntityNbt(var28);
        }
        NBTTagList var27 = var3.getList("Lights", 9);
        for (int var28 = 0; var28 < var27.size(); ++var28) {
            NBTTagList var29 = var27.getList(var28);
            for (int var30 = 0; var30 < var29.size(); ++var30) {
                var243.addLight(var29.getShort(var30), var28);
            }
        }
        NBTTagCompound var28 = var3.getCompound("CarvingMasks");
        for (String var30 : var28.getAllKeys()) {
            WorldGenStage.Features var31 = WorldGenStage.Features.valueOf(var30);
            var243.setCarvingMask(var31, new CarvingMask(var28.getLongArray(var30), ((IChunkAccess)var19).getMinBuildHeight()));
        }
        return var243;
    }

    private static void logErrors(ChunkCoordIntPair var0, int var1, String var2) {
        LOGGER.error("Recoverable errors when loading section [" + var0.x + ", " + var1 + ", " + var0.z + "]: " + var2);
    }

    private static Codec<DataPaletteBlock<Holder<BiomeBase>>> makeBiomeCodec(IRegistry<BiomeBase> var0) {
        return DataPaletteBlock.codec(var0.asHolderIdMap(), var0.holderByNameCodec(), DataPaletteBlock.e.SECTION_BIOMES, var0.getHolderOrThrow(Biomes.PLAINS));
    }

    public static NBTTagCompound write(WorldServer var0, IChunkAccess var12) {
        Object var14;
        ChunkConverter var6;
        BelowZeroRetrogen var5;
        ChunkCoordIntPair var2 = var12.getPos();
        NBTTagCompound var3 = new NBTTagCompound();
        var3.putInt("DataVersion", SharedConstants.getCurrentVersion().getWorldVersion());
        var3.putInt("xPos", var2.x);
        var3.putInt("yPos", var12.getMinSection());
        var3.putInt("zPos", var2.z);
        var3.putLong("LastUpdate", var0.getGameTime());
        var3.putLong("InhabitedTime", var12.getInhabitedTime());
        var3.putString("Status", var12.getStatus().getName());
        BlendingData var4 = var12.getBlendingData();
        if (var4 != null) {
            BlendingData.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var4).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var3.put("blending_data", (NBTBase)var1));
        }
        if ((var5 = var12.getBelowZeroRetrogen()) != null) {
            BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var5).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var3.put("below_zero_retrogen", (NBTBase)var1));
        }
        if (!(var6 = var12.getUpgradeData()).isEmpty()) {
            var3.put(TAG_UPGRADE_DATA, var6.write());
        }
        ChunkSection[] var7 = var12.getSections();
        NBTTagList var8 = new NBTTagList();
        LightEngineThreaded var9 = var0.getChunkSource().getLightEngine();
        IRegistry<BiomeBase> var10 = var0.registryAccess().registryOrThrow(IRegistry.BIOME_REGISTRY);
        Codec<DataPaletteBlock<Holder<BiomeBase>>> var11 = ChunkRegionLoader.makeBiomeCodec(var10);
        boolean var122 = var12.isLightCorrect();
        for (int var13 = var9.getMinLightSection(); var13 < var9.getMaxLightSection(); ++var13) {
            int var142 = var12.getSectionIndexFromSectionY(var13);
            boolean var15 = var142 >= 0 && var142 < var7.length;
            NibbleArray nibbleArray = var9.getLayerListener(EnumSkyBlock.BLOCK).getDataLayerData(SectionPosition.of(var2, var13));
            NibbleArray var17 = var9.getLayerListener(EnumSkyBlock.SKY).getDataLayerData(SectionPosition.of(var2, var13));
            if (!var15 && nibbleArray == null && var17 == null) continue;
            NBTTagCompound var18 = new NBTTagCompound();
            if (var15) {
                ChunkSection var19 = var7[var142];
                var18.put("block_states", (NBTBase)BLOCK_STATE_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var19.getStates()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                var18.put("biomes", (NBTBase)var11.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var19.getBiomes()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
            }
            if (nibbleArray != null && !nibbleArray.isEmpty()) {
                var18.putByteArray("BlockLight", nibbleArray.getData());
            }
            if (var17 != null && !var17.isEmpty()) {
                var18.putByteArray("SkyLight", var17.getData());
            }
            if (var18.isEmpty()) continue;
            var18.putByte("Y", (byte)var13);
            var8.add(var18);
        }
        var3.put("sections", var8);
        if (var122) {
            var3.putBoolean("isLightOn", true);
        }
        NBTTagList var13 = new NBTTagList();
        for (BlockPosition var15 : var12.getBlockEntitiesPos()) {
            NBTTagCompound nBTTagCompound = var12.getBlockEntityNbtForSaving(var15);
            if (nBTTagCompound == null) continue;
            var13.add(nBTTagCompound);
        }
        var3.put("block_entities", var13);
        if (var12.getStatus().getChunkType() == ChunkStatus.Type.PROTOCHUNK) {
            var14 = (ProtoChunk)var12;
            NBTTagList var15 = new NBTTagList();
            var15.addAll(((ProtoChunk)var14).getEntities());
            var3.put("entities", var15);
            var3.put("Lights", ChunkRegionLoader.packOffsets(((ProtoChunk)var14).getPackedLights()));
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            for (WorldGenStage.Features var20 : WorldGenStage.Features.values()) {
                CarvingMask var21 = ((ProtoChunk)var14).getCarvingMask(var20);
                if (var21 == null) continue;
                nBTTagCompound.putLongArray(var20.toString(), var21.toArray());
            }
            var3.put("CarvingMasks", nBTTagCompound);
        }
        ChunkRegionLoader.saveTicks(var0, var3, var12.getTicksForSerialization());
        var3.put("PostProcessing", ChunkRegionLoader.packOffsets(var12.getPostProcessing()));
        var14 = new NBTTagCompound();
        for (Map.Entry<HeightMap.Type, HeightMap> entry : var12.getHeightmaps()) {
            if (!var12.getStatus().heightmapsAfter().contains(entry.getKey())) continue;
            ((NBTTagCompound)var14).put(entry.getKey().getSerializationKey(), new NBTTagLongArray(entry.getValue().getRawData()));
        }
        var3.put("Heightmaps", (NBTBase)var14);
        var3.put("structures", ChunkRegionLoader.packStructureData(StructurePieceSerializationContext.fromLevel(var0), var2, var12.getAllStarts(), var12.getAllReferences()));
        return var3;
    }

    private static void saveTicks(WorldServer var02, NBTTagCompound var1, IChunkAccess.a var2) {
        long var3 = var02.getLevelData().getGameTime();
        var1.put(BLOCK_TICKS_TAG, var2.blocks().save(var3, var0 -> IRegistry.BLOCK.getKey((Block)var0).toString()));
        var1.put(FLUID_TICKS_TAG, var2.fluids().save(var3, var0 -> IRegistry.FLUID.getKey((FluidType)var0).toString()));
    }

    public static ChunkStatus.Type getChunkTypeFromTag(@Nullable NBTTagCompound var0) {
        if (var0 != null) {
            return ChunkStatus.byName(var0.getString("Status")).getChunkType();
        }
        return ChunkStatus.Type.PROTOCHUNK;
    }

    @Nullable
    private static Chunk.c postLoadChunk(WorldServer var0, NBTTagCompound var1) {
        NBTTagList var2 = ChunkRegionLoader.getListOfCompoundsOrNull(var1, "entities");
        NBTTagList var32 = ChunkRegionLoader.getListOfCompoundsOrNull(var1, "block_entities");
        if (var2 == null && var32 == null) {
            return null;
        }
        return var3 -> {
            if (var2 != null) {
                var0.addLegacyChunkEntities(EntityTypes.loadEntitiesRecursive(var2, var0));
            }
            if (var32 != null) {
                for (int var4 = 0; var4 < var32.size(); ++var4) {
                    NBTTagCompound var5 = var32.getCompound(var4);
                    boolean var6 = var5.getBoolean("keepPacked");
                    if (var6) {
                        var3.setBlockEntityNbt(var5);
                        continue;
                    }
                    BlockPosition var7 = TileEntity.getPosFromTag(var5);
                    TileEntity var8 = TileEntity.loadStatic(var7, var3.getBlockState(var7), var5);
                    if (var8 == null) continue;
                    var3.setBlockEntity(var8);
                }
            }
        };
    }

    @Nullable
    private static NBTTagList getListOfCompoundsOrNull(NBTTagCompound var0, String var1) {
        NBTTagList var2 = var0.getList(var1, 10);
        return var2.isEmpty() ? null : var2;
    }

    private static NBTTagCompound packStructureData(StructurePieceSerializationContext var0, ChunkCoordIntPair var1, Map<StructureFeature<?, ?>, StructureStart> var2, Map<StructureFeature<?, ?>, LongSet> var3) {
        NBTTagCompound var4 = new NBTTagCompound();
        NBTTagCompound var5 = new NBTTagCompound();
        IRegistry<StructureFeature<?, ?>> var6 = var0.registryAccess().registryOrThrow(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY);
        for (Map.Entry<StructureFeature<?, ?>, StructureStart> var8 : var2.entrySet()) {
            Map.Entry<StructureFeature<?, ?>, LongSet> var9 = var6.getKey(var8.getKey());
            var5.put(((MinecraftKey)((Object)var9)).toString(), var8.getValue().createTag(var0, var1));
        }
        var4.put("starts", var5);
        NBTTagCompound var7 = new NBTTagCompound();
        for (Map.Entry<StructureFeature<?, ?>, LongSet> var9 : var3.entrySet()) {
            if (((LongSet)var9.getValue()).isEmpty()) continue;
            MinecraftKey var10 = var6.getKey((StructureFeature)var9.getKey());
            var7.put(var10.toString(), new NBTTagLongArray((LongSet)var9.getValue()));
        }
        var4.put("References", var7);
        return var4;
    }

    private static Map<StructureFeature<?, ?>, StructureStart> unpackStructureStart(StructurePieceSerializationContext var0, NBTTagCompound var1, long var2) {
        HashMap var4 = Maps.newHashMap();
        IRegistry<StructureFeature<?, ?>> var5 = var0.registryAccess().registryOrThrow(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY);
        NBTTagCompound var6 = var1.getCompound("starts");
        for (String var8 : var6.getAllKeys()) {
            MinecraftKey var9 = MinecraftKey.tryParse(var8);
            StructureFeature<?, ?> var10 = var5.get(var9);
            if (var10 == null) {
                LOGGER.error("Unknown structure start: {}", (Object)var9);
                continue;
            }
            StructureStart var11 = StructureGenerator.loadStaticStart(var0, var6.getCompound(var8), var2);
            if (var11 == null) continue;
            var4.put(var10, var11);
        }
        return var4;
    }

    private static Map<StructureFeature<?, ?>, LongSet> unpackStructureReferences(IRegistryCustom var0, ChunkCoordIntPair var1, NBTTagCompound var22) {
        HashMap var3 = Maps.newHashMap();
        IRegistry<StructureFeature<?, ?>> var4 = var0.registryOrThrow(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY);
        NBTTagCompound var5 = var22.getCompound("References");
        for (String var7 : var5.getAllKeys()) {
            MinecraftKey var8 = MinecraftKey.tryParse(var7);
            StructureFeature<?, ?> var9 = var4.get(var8);
            if (var9 == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)var8, (Object)var1);
                continue;
            }
            long[] var10 = var5.getLongArray(var7);
            if (var10.length == 0) continue;
            var3.put(var9, new LongOpenHashSet(Arrays.stream(var10).filter(var2 -> {
                ChunkCoordIntPair var4 = new ChunkCoordIntPair(var2);
                if (var4.getChessboardDistance(var1) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{var8, var4, var1});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return var3;
    }

    public static NBTTagList packOffsets(ShortList[] var0) {
        NBTTagList var1 = new NBTTagList();
        for (ShortList var5 : var0) {
            NBTTagList var6 = new NBTTagList();
            if (var5 != null) {
                for (Short var8 : var5) {
                    var6.add(NBTTagShort.valueOf(var8));
                }
            }
            var1.add(var6);
        }
        return var1;
    }
}

