/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public abstract class ChunkGenerator
implements BiomeManager.Provider {
    private static final Logger LOGGER;
    public static final Codec<ChunkGenerator> CODEC;
    public final IRegistry<StructureSet> structureSets;
    protected final WorldChunkManager biomeSource;
    protected final WorldChunkManager runtimeBiomeSource;
    public final Optional<HolderSet<StructureSet>> structureOverrides;
    private final Map<StructureFeature<?, ?>, List<StructurePlacement>> placementsForFeature = new Object2ObjectOpenHashMap();
    private final Map<ConcentricRingsStructurePlacement, CompletableFuture<List<ChunkCoordIntPair>>> ringPositions = new Object2ObjectArrayMap();
    private boolean hasGeneratedPositions;
    @Deprecated
    public final long ringPlacementSeed;

    protected static final <T extends ChunkGenerator> Products.P1<RecordCodecBuilder.Mu<T>, IRegistry<StructureSet>> commonCodec(RecordCodecBuilder.Instance<T> var02) {
        return var02.group((App)RegistryOps.retrieveRegistry(IRegistry.STRUCTURE_SET_REGISTRY).forGetter(var0 -> var0.structureSets));
    }

    public ChunkGenerator(IRegistry<StructureSet> var0, Optional<HolderSet<StructureSet>> var1, WorldChunkManager var2) {
        this(var0, var1, var2, var2, 0L);
    }

    public ChunkGenerator(IRegistry<StructureSet> var0, Optional<HolderSet<StructureSet>> var1, WorldChunkManager var2, WorldChunkManager var3, long var4) {
        this.structureSets = var0;
        this.biomeSource = var2;
        this.runtimeBiomeSource = var3;
        this.structureOverrides = var1;
        this.ringPlacementSeed = var4;
    }

    public Stream<Holder<StructureSet>> possibleStructureSets() {
        if (this.structureOverrides.isPresent()) {
            return this.structureOverrides.get().stream();
        }
        return this.structureSets.holders().map(Holder::hackyErase);
    }

    private void generatePositions() {
        Set<Holder<BiomeBase>> var0 = this.runtimeBiomeSource.possibleBiomes();
        this.possibleStructureSets().forEach(var12 -> {
            StructureSet var2 = (StructureSet)var12.value();
            for (StructureSet.a a2 : var2.structures()) {
                this.placementsForFeature.computeIfAbsent(a2.structure().value(), var0 -> new ArrayList()).add(var2.placement());
            }
            StructurePlacement structurePlacement = var2.placement();
            if (structurePlacement instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement var3 = (ConcentricRingsStructurePlacement)structurePlacement;
                if (var2.structures().stream().anyMatch(var1 -> var1.generatesInMatchingBiome(var0::contains))) {
                    this.ringPositions.put(var3, this.generateRingPositions((Holder<StructureSet>)var12, var3));
                }
            }
        });
    }

    private CompletableFuture<List<ChunkCoordIntPair>> generateRingPositions(Holder<StructureSet> var0, ConcentricRingsStructurePlacement var1) {
        if (var1.count() == 0) {
            return CompletableFuture.completedFuture(List.of());
        }
        return CompletableFuture.supplyAsync(SystemUtils.wrapThreadWithTaskName("placement calculation", () -> {
            Stopwatch var2 = Stopwatch.createStarted((Ticker)SystemUtils.TICKER);
            ArrayList<ChunkCoordIntPair> var3 = new ArrayList<ChunkCoordIntPair>();
            Set var4 = ((StructureSet)var0.value()).structures().stream().flatMap(var0 -> var0.structure().value().biomes().stream()).collect(Collectors.toSet());
            int var5 = var1.distance();
            int var6 = var1.count();
            int var7 = var1.spread();
            Random var8 = new Random();
            var8.setSeed(this.ringPlacementSeed);
            double var9 = var8.nextDouble() * Math.PI * 2.0;
            int var11 = 0;
            int var12 = 0;
            for (int var13 = 0; var13 < var6; ++var13) {
                double var14 = (double)(4 * var5 + var5 * var12 * 6) + (var8.nextDouble() - 0.5) * ((double)var5 * 2.5);
                int var16 = (int)Math.round(Math.cos(var9) * var14);
                int var17 = (int)Math.round(Math.sin(var9) * var14);
                Pair<BlockPosition, Holder<BiomeBase>> var18 = this.biomeSource.findBiomeHorizontal(SectionPosition.sectionToBlockCoord(var16, 8), 0, SectionPosition.sectionToBlockCoord(var17, 8), 112, var4::contains, var8, this.climateSampler());
                if (var18 != null) {
                    BlockPosition var19 = (BlockPosition)var18.getFirst();
                    var16 = SectionPosition.blockToSectionCoord(var19.getX());
                    var17 = SectionPosition.blockToSectionCoord(var19.getZ());
                }
                var3.add(new ChunkCoordIntPair(var16, var17));
                var9 += Math.PI * 2 / (double)var7;
                if (++var11 != var7) continue;
                var11 = 0;
                var7 += 2 * var7 / (++var12 + 1);
                var7 = Math.min(var7, var6 - var13);
                var9 += var8.nextDouble() * Math.PI * 2.0;
            }
            double var13 = (double)var2.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            LOGGER.debug("Calculation for {} took {}s", (Object)var0, (Object)var13);
            return var3;
        }), SystemUtils.backgroundExecutor());
    }

    protected abstract Codec<? extends ChunkGenerator> codec();

    public Optional<ResourceKey<Codec<? extends ChunkGenerator>>> getTypeNameForDataFixer() {
        return IRegistry.CHUNK_GENERATOR.getResourceKey(this.codec());
    }

    public abstract ChunkGenerator withSeed(long var1);

    public CompletableFuture<IChunkAccess> createBiomes(IRegistry<BiomeBase> var0, Executor var1, Blender var2, StructureManager var3, IChunkAccess var4) {
        return CompletableFuture.supplyAsync(SystemUtils.wrapThreadWithTaskName("init_biomes", () -> {
            var4.fillBiomesFromNoise(this.runtimeBiomeSource::getNoiseBiome, this.climateSampler());
            return var4;
        }), SystemUtils.backgroundExecutor());
    }

    public abstract Climate.Sampler climateSampler();

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2) {
        return this.getBiomeSource().getNoiseBiome(var0, var1, var2, this.climateSampler());
    }

    public abstract void applyCarvers(RegionLimitedWorldAccess var1, long var2, BiomeManager var4, StructureManager var5, IChunkAccess var6, WorldGenStage.Features var7);

    @Nullable
    public Pair<BlockPosition, Holder<StructureFeature<?, ?>>> findNearestMapFeature(WorldServer var02, HolderSet<StructureFeature<?, ?>> var1, BlockPosition var2, int var3, boolean var4) {
        Set var5 = var1.stream().flatMap(var0 -> ((StructureFeature)var0.value()).biomes().stream()).collect(Collectors.toSet());
        if (var5.isEmpty()) {
            return null;
        }
        Set<Holder<BiomeBase>> var6 = this.runtimeBiomeSource.possibleBiomes();
        if (Collections.disjoint(var6, var5)) {
            return null;
        }
        Pair<BlockPosition, Holder<StructureFeature<?, ?>>> var7 = null;
        double var8 = Double.MAX_VALUE;
        Object2ObjectArrayMap var10 = new Object2ObjectArrayMap();
        for (Holder holder : var1) {
            if (var6.stream().noneMatch(((StructureFeature)holder.value()).biomes()::contains)) continue;
            for (StructurePlacement var14 : this.getPlacementsForFeature(holder)) {
                var10.computeIfAbsent(var14, var0 -> new ObjectArraySet()).add(holder);
            }
        }
        ArrayList var11 = new ArrayList(var10.size());
        for (Map.Entry entry : var10.entrySet()) {
            StructurePlacement var14;
            var14 = (StructurePlacement)entry.getKey();
            if (var14 instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement var15 = (ConcentricRingsStructurePlacement)var14;
                BlockPosition var16 = this.getNearestGeneratedStructure(var2, var15);
                double var17 = var2.distSqr(var16);
                if (!(var17 < var8)) continue;
                var8 = var17;
                var7 = Pair.of((Object)var16, (Object)((Holder)((Set)entry.getValue()).iterator().next()));
                continue;
            }
            if (!(var14 instanceof RandomSpreadStructurePlacement)) continue;
            var11.add(entry);
        }
        if (!var11.isEmpty()) {
            int n2 = SectionPosition.blockToSectionCoord(var2.getX());
            int n3 = SectionPosition.blockToSectionCoord(var2.getZ());
            for (int var14 = 0; var14 <= var3; ++var14) {
                boolean var15 = false;
                for (Map.Entry var17 : var11) {
                    RandomSpreadStructurePlacement var18 = (RandomSpreadStructurePlacement)var17.getKey();
                    Pair<BlockPosition, Holder<StructureFeature<?, ?>>> var19 = ChunkGenerator.getNearestGeneratedStructure((Set)var17.getValue(), var02, var02.structureFeatureManager(), n2, n3, var14, var4, var02.getSeed(), var18);
                    if (var19 == null) continue;
                    var15 = true;
                    double var20 = var2.distSqr((BaseBlockPosition)var19.getFirst());
                    if (!(var20 < var8)) continue;
                    var8 = var20;
                    var7 = var19;
                }
                if (!var15) continue;
                return var7;
            }
        }
        return var7;
    }

    @Nullable
    private BlockPosition getNearestGeneratedStructure(BlockPosition var0, ConcentricRingsStructurePlacement var1) {
        List<ChunkCoordIntPair> var2 = this.getRingPositionsFor(var1);
        if (var2 == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        BlockPosition var3 = null;
        double var4 = Double.MAX_VALUE;
        BlockPosition.MutableBlockPosition var6 = new BlockPosition.MutableBlockPosition();
        for (ChunkCoordIntPair var8 : var2) {
            var6.set(SectionPosition.sectionToBlockCoord(var8.x, 8), 32, SectionPosition.sectionToBlockCoord(var8.z, 8));
            double var9 = var6.distSqr(var0);
            if (var3 == null) {
                var3 = new BlockPosition(var6);
                var4 = var9;
                continue;
            }
            if (!(var9 < var4)) continue;
            var3 = new BlockPosition(var6);
            var4 = var9;
        }
        return var3;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<StructureFeature<?, ?>>> getNearestGeneratedStructure(Set<Holder<StructureFeature<?, ?>>> var0, IWorldReader var1, StructureManager var2, int var3, int var4, int var5, boolean var6, long var7, RandomSpreadStructurePlacement var9) {
        int var10 = var9.spacing();
        for (int var11 = -var5; var11 <= var5; ++var11) {
            boolean var12 = var11 == -var5 || var11 == var5;
            for (int var13 = -var5; var13 <= var5; ++var13) {
                boolean var14;
                boolean bl = var14 = var13 == -var5 || var13 == var5;
                if (!var12 && !var14) continue;
                int var15 = var3 + var10 * var11;
                int var16 = var4 + var10 * var13;
                ChunkCoordIntPair var17 = var9.getPotentialFeatureChunk(var7, var15, var16);
                for (Holder<StructureFeature<?, ?>> var19 : var0) {
                    StructureCheckResult var20 = var2.checkStructurePresence(var17, var19.value(), var6);
                    if (var20 == StructureCheckResult.START_NOT_PRESENT) continue;
                    if (!var6 && var20 == StructureCheckResult.START_PRESENT) {
                        return Pair.of((Object)StructureGenerator.getLocatePos(var9, var17), var19);
                    }
                    IChunkAccess var21 = var1.getChunk(var17.x, var17.z, ChunkStatus.STRUCTURE_STARTS);
                    StructureStart var22 = var2.getStartForFeature(SectionPosition.bottomOf(var21), var19.value(), var21);
                    if (var22 == null || !var22.isValid()) continue;
                    if (var6 && var22.canBeReferenced()) {
                        var2.addReference(var22);
                        return Pair.of((Object)StructureGenerator.getLocatePos(var9, var22.getChunkPos()), var19);
                    }
                    if (var6) continue;
                    return Pair.of((Object)StructureGenerator.getLocatePos(var9, var22.getChunkPos()), var19);
                }
            }
        }
        return null;
    }

    public void applyBiomeDecoration(GeneratorAccessSeed var02, IChunkAccess var1, StructureManager var2) {
        ChunkCoordIntPair var3 = var1.getPos();
        if (SharedConstants.debugVoidTerrain(var3)) {
            return;
        }
        SectionPosition var4 = SectionPosition.of(var3, var02.getMinSection());
        BlockPosition var52 = var4.origin();
        IRegistry<StructureFeature<?, ?>> var6 = var02.registryAccess().registryOrThrow(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY);
        Map<Integer, List<StructureFeature>> var7 = var6.stream().collect(Collectors.groupingBy(var0 -> ((StructureGenerator)var0.feature).step().ordinal()));
        List<WorldChunkManager.b> var8 = this.biomeSource.featuresPerStep();
        SeededRandom var9 = new SeededRandom(new XoroshiroRandomSource(RandomSupport.seedUniquifier()));
        long var10 = var9.setDecorationSeed(var02.getSeed(), var52.getX(), var52.getZ());
        ObjectArraySet var12 = new ObjectArraySet();
        if (this instanceof ChunkProviderFlat) {
            this.biomeSource.possibleBiomes().stream().map(Holder::value).forEach(((Set)var12)::add);
        } else {
            ChunkCoordIntPair.rangeClosed(var4.chunk(), 1).forEach(arg_0 -> ChunkGenerator.a(var02, (Set)var12, arg_0));
            var12.retainAll(this.biomeSource.possibleBiomes().stream().map(Holder::value).collect(Collectors.toSet()));
        }
        int var13 = var8.size();
        try {
            IRegistry<PlacedFeature> var14 = var02.registryAccess().registryOrThrow(IRegistry.PLACED_FEATURE_REGISTRY);
            int var15 = Math.max(WorldGenStage.Decoration.values().length, var13);
            for (int var16 = 0; var16 < var15; ++var16) {
                List<HolderSet<PlacedFeature>> var21;
                Object var202;
                IntArraySet var18;
                int var17 = 0;
                if (var2.shouldGenerateFeatures()) {
                    var18 = var7.getOrDefault(var16, Collections.emptyList());
                    for (Object var202 : var18) {
                        var9.setFeatureSeed(var10, var17, var16);
                        var21 = () -> ChunkGenerator.a(var6, (StructureFeature)var202);
                        try {
                            var02.setCurrentlyGenerating((Supplier<String>)((Object)var21));
                            var2.startsForFeature(var4, (StructureFeature<?, ?>)var202).forEach(var5 -> var5.placeInChunk(var02, var2, this, var9, ChunkGenerator.getWritableArea(var1), var3));
                        }
                        catch (Exception var22) {
                            CrashReport var23 = CrashReport.forThrowable(var22, "Feature placement");
                            var23.addCategory("Feature").setDetail("Description", ((Supplier)((Object)var21))::get);
                            throw new ReportedException(var23);
                        }
                        ++var17;
                    }
                }
                if (var16 >= var13) continue;
                var18 = new IntArraySet();
                for (Object var202 : var12) {
                    var21 = ((BiomeBase)var202).getGenerationSettings().features();
                    if (var16 >= var21.size()) continue;
                    HolderSet var22 = (HolderSet)var21.get(var16);
                    WorldChunkManager.b var23 = var8.get(var16);
                    var22.stream().map(Holder::value).forEach(arg_0 -> ChunkGenerator.a((IntSet)var18, var23, arg_0));
                }
                int var19 = var18.size();
                var202 = var18.toIntArray();
                Arrays.sort((int[])var202);
                var21 = var8.get(var16);
                for (int var22 = 0; var22 < var19; ++var22) {
                    Object var23 = var202[var22];
                    PlacedFeature var24 = ((WorldChunkManager.b)((Object)var21)).features().get((int)var23);
                    Supplier<String> var25 = () -> var14.getResourceKey(var24).map(Object::toString).orElseGet(var24::toString);
                    var9.setFeatureSeed(var10, (int)var23, var16);
                    try {
                        var02.setCurrentlyGenerating(var25);
                        var24.placeWithBiomeCheck(var02, this, var9, var52);
                        continue;
                    }
                    catch (Exception var26) {
                        CrashReport var27 = CrashReport.forThrowable(var26, "Feature placement");
                        var27.addCategory("Feature").setDetail("Description", var25::get);
                        throw new ReportedException(var27);
                    }
                }
            }
            var02.setCurrentlyGenerating(null);
        }
        catch (Exception var14) {
            CrashReport var15 = CrashReport.forThrowable(var14, "Biome decoration");
            var15.addCategory("Generation").setDetail("CenterX", var3.x).setDetail("CenterZ", var3.z).setDetail("Seed", var10);
            throw new ReportedException(var15);
        }
    }

    public boolean hasFeatureChunkInRange(ResourceKey<StructureSet> var0, long var1, int var3, int var4, int var5) {
        StructureSet var6 = this.structureSets.get(var0);
        if (var6 == null) {
            return false;
        }
        StructurePlacement var7 = var6.placement();
        for (int var8 = var3 - var5; var8 <= var3 + var5; ++var8) {
            for (int var9 = var4 - var5; var9 <= var4 + var5; ++var9) {
                if (!var7.isFeatureChunk(this, var1, var8, var9)) continue;
                return true;
            }
        }
        return false;
    }

    private static StructureBoundingBox getWritableArea(IChunkAccess var0) {
        ChunkCoordIntPair var1 = var0.getPos();
        int var2 = var1.getMinBlockX();
        int var3 = var1.getMinBlockZ();
        LevelHeightAccessor var4 = var0.getHeightAccessorForGeneration();
        int var5 = var4.getMinBuildHeight() + 1;
        int var6 = var4.getMaxBuildHeight() - 1;
        return new StructureBoundingBox(var2, var5, var3, var2 + 15, var6, var3 + 15);
    }

    public abstract void buildSurface(RegionLimitedWorldAccess var1, StructureManager var2, IChunkAccess var3);

    public abstract void spawnOriginalMobs(RegionLimitedWorldAccess var1);

    public int getSpawnHeight(LevelHeightAccessor var0) {
        return 64;
    }

    public WorldChunkManager getBiomeSource() {
        return this.runtimeBiomeSource;
    }

    public abstract int getGenDepth();

    public WeightedRandomList<BiomeSettingsMobs.c> getMobsAt(Holder<BiomeBase> var0, StructureManager var12, EnumCreatureType var22, BlockPosition var3) {
        Map<StructureFeature<?, ?>, LongSet> var4 = var12.getAllStructuresAt(var3);
        for (Map.Entry<StructureFeature<?, ?>, LongSet> var6 : var4.entrySet()) {
            StructureFeature<?, ?> var7 = var6.getKey();
            StructureSpawnOverride var8 = var7.spawnOverrides.get(var22);
            if (var8 == null) continue;
            MutableBoolean var9 = new MutableBoolean(false);
            Predicate<StructureStart> var10 = var8.boundingBox() == StructureSpawnOverride.a.PIECE ? var2 -> var12.structureHasPieceAt(var3, (StructureStart)var2) : var1 -> var1.getBoundingBox().isInside(var3);
            var12.fillStartsForFeature(var7, var6.getValue(), var2 -> {
                if (var9.isFalse() && var10.test((StructureStart)var2)) {
                    var9.setTrue();
                }
            });
            if (!var9.isTrue()) continue;
            return var8.spawns();
        }
        return var0.value().getMobSettings().getMobs(var22);
    }

    public static Stream<StructureFeature<?, ?>> allConfigurations(IRegistry<StructureFeature<?, ?>> var0, StructureGenerator<?> var12) {
        return var0.stream().filter(var1 -> var1.feature == var12);
    }

    public void createStructures(IRegistryCustom var0, StructureManager var1, IChunkAccess var2, DefinedStructureManager var3, long var4) {
        ChunkCoordIntPair var6 = var2.getPos();
        SectionPosition var7 = SectionPosition.bottomOf(var2);
        this.possibleStructureSets().forEach(var8 -> {
            StructurePlacement var9 = ((StructureSet)var8.value()).placement();
            List<StructureSet.a> var10 = ((StructureSet)var8.value()).structures();
            for (StructureSet.a a2 : var10) {
                StructureStart var13 = var1.getStartForFeature(var7, a2.structure().value(), var2);
                if (var13 == null || !var13.isValid()) continue;
                return;
            }
            if (!var9.isFeatureChunk(this, var4, var5.x, var5.z)) {
                return;
            }
            if (var10.size() == 1) {
                this.tryGenerateStructure(var10.get(0), var1, var0, var3, var4, var2, var6, var7);
                return;
            }
            ArrayList<StructureSet.a> var11 = new ArrayList<StructureSet.a>(var10.size());
            var11.addAll(var10);
            SeededRandom seededRandom = new SeededRandom(new LegacyRandomSource(0L));
            seededRandom.setLargeFeatureSeed(var4, var5.x, var5.z);
            int var13 = 0;
            for (StructureSet.a var15 : var11) {
                var13 += var15.weight();
            }
            while (!var11.isEmpty()) {
                StructureSet.a var17;
                int var14 = seededRandom.nextInt(var13);
                int var15 = 0;
                Iterator iterator = var11.iterator();
                while (iterator.hasNext() && (var14 -= (var17 = (StructureSet.a)iterator.next()).weight()) >= 0) {
                    ++var15;
                }
                StructureSet.a var16 = (StructureSet.a)var11.get(var15);
                if (this.tryGenerateStructure(var16, var1, var0, var3, var4, var2, var6, var7)) {
                    return;
                }
                var11.remove(var15);
                var13 -= var16.weight();
            }
        });
    }

    private boolean tryGenerateStructure(StructureSet.a var0, StructureManager var1, IRegistryCustom var2, DefinedStructureManager var3, long var4, IChunkAccess var6, ChunkCoordIntPair var7, SectionPosition var8) {
        HolderSet<BiomeBase> var11;
        Predicate<Holder<BiomeBase>> var12;
        int var10;
        StructureFeature<?, ?> var9 = var0.structure().value();
        StructureStart var13 = var9.generate(var2, this, this.biomeSource, var3, var4, var7, var10 = ChunkGenerator.fetchReferences(var1, var6, var8, var9), var6, var12 = arg_0 -> this.a(var11 = var9.biomes(), arg_0));
        if (var13.isValid()) {
            var1.setStartForFeature(var8, var9, var13, var6);
            return true;
        }
        return false;
    }

    private static int fetchReferences(StructureManager var0, IChunkAccess var1, SectionPosition var2, StructureFeature<?, ?> var3) {
        StructureStart var4 = var0.getStartForFeature(var2, var3, var1);
        return var4 != null ? var4.getReferences() : 0;
    }

    protected Holder<BiomeBase> adjustBiome(Holder<BiomeBase> var0) {
        return var0;
    }

    public void createReferences(GeneratorAccessSeed var0, StructureManager var1, IChunkAccess var2) {
        int var3 = 8;
        ChunkCoordIntPair var4 = var2.getPos();
        int var5 = var4.x;
        int var6 = var4.z;
        int var7 = var4.getMinBlockX();
        int var8 = var4.getMinBlockZ();
        SectionPosition var9 = SectionPosition.bottomOf(var2);
        for (int var10 = var5 - 8; var10 <= var5 + 8; ++var10) {
            for (int var11 = var6 - 8; var11 <= var6 + 8; ++var11) {
                long var12 = ChunkCoordIntPair.asLong(var10, var11);
                for (StructureStart var15 : var0.getChunk(var10, var11).getAllStarts().values()) {
                    try {
                        if (!var15.isValid() || !var15.getBoundingBox().intersects(var7, var8, var7 + 15, var8 + 15)) continue;
                        var1.addReferenceForFeature(var9, var15.getFeature(), var12, var2);
                        PacketDebug.sendStructurePacket(var0, var15);
                    }
                    catch (Exception var16) {
                        CrashReport var17 = CrashReport.forThrowable(var16, "Generating structure reference");
                        CrashReportSystemDetails var18 = var17.addCategory("Structure");
                        Optional<IRegistry<StructureFeature<?, ?>>> var19 = var0.registryAccess().registry(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY);
                        var18.setDetail("Id", () -> var19.map(var1 -> var1.getKey(var15.getFeature()).toString()).orElse("UNKNOWN"));
                        var18.setDetail("Name", () -> IRegistry.STRUCTURE_FEATURE.getKey((StructureGenerator<?>)var0.getFeature().feature).toString());
                        var18.setDetail("Class", () -> var15.getFeature().getClass().getCanonicalName());
                        throw new ReportedException(var17);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<IChunkAccess> fillFromNoise(Executor var1, Blender var2, StructureManager var3, IChunkAccess var4);

    public abstract int getSeaLevel();

    public abstract int getMinY();

    public abstract int getBaseHeight(int var1, int var2, HeightMap.Type var3, LevelHeightAccessor var4);

    public abstract BlockColumn getBaseColumn(int var1, int var2, LevelHeightAccessor var3);

    public int getFirstFreeHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3) {
        return this.getBaseHeight(var0, var1, var2, var3);
    }

    public int getFirstOccupiedHeight(int var0, int var1, HeightMap.Type var2, LevelHeightAccessor var3) {
        return this.getBaseHeight(var0, var1, var2, var3) - 1;
    }

    public void ensureStructuresGenerated() {
        if (!this.hasGeneratedPositions) {
            this.generatePositions();
            this.hasGeneratedPositions = true;
        }
    }

    @Nullable
    public List<ChunkCoordIntPair> getRingPositionsFor(ConcentricRingsStructurePlacement var0) {
        this.ensureStructuresGenerated();
        CompletableFuture<List<ChunkCoordIntPair>> var1 = this.ringPositions.get(var0);
        return var1 != null ? var1.join() : null;
    }

    private List<StructurePlacement> getPlacementsForFeature(Holder<StructureFeature<?, ?>> var0) {
        this.ensureStructuresGenerated();
        return this.placementsForFeature.getOrDefault(var0.value(), List.of());
    }

    public abstract void addDebugScreenInfo(List<String> var1, BlockPosition var2);

    private /* synthetic */ boolean a(HolderSet var0, Holder var1) {
        return var0.contains(this.adjustBiome(var1));
    }

    private static /* synthetic */ void a(IntSet var0, WorldChunkManager.b var1, PlacedFeature var2) {
        var0.add(var1.indexMapping().applyAsInt(var2));
    }

    private static /* synthetic */ String a(IRegistry var0, StructureFeature var1) {
        return var0.getResourceKey(var1).map(Object::toString).orElseGet(var1::toString);
    }

    private static /* synthetic */ void a(GeneratorAccessSeed var0, Set var12, ChunkCoordIntPair var2) {
        IChunkAccess var3 = var0.getChunk(var2.x, var2.z);
        for (ChunkSection var7 : var3.getSections()) {
            var7.getBiomes().getAll(var1 -> var12.add((BiomeBase)var1.value()));
        }
    }

    static {
        IRegistry.register(IRegistry.CHUNK_GENERATOR, "noise", ChunkGeneratorAbstract.CODEC);
        IRegistry.register(IRegistry.CHUNK_GENERATOR, "flat", ChunkProviderFlat.CODEC);
        IRegistry.register(IRegistry.CHUNK_GENERATOR, "debug", ChunkProviderDebug.CODEC);
        LOGGER = LogUtils.getLogger();
        CODEC = IRegistry.CHUNK_GENERATOR.byNameCodec().dispatchStable(ChunkGenerator::codec, Function.identity());
    }
}

