/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import java.util.Arrays;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockPistonExtension
extends BlockDirectional {
    public static final BlockStateEnum<BlockPropertyPistonType> TYPE = BlockProperties.PISTON_TYPE;
    public static final BlockStateBoolean SHORT = BlockProperties.SHORT;
    public static final float PLATFORM = 4.0f;
    protected static final VoxelShape EAST_AABB = Block.box(12.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape WEST_AABB = Block.box(0.0, 0.0, 0.0, 4.0, 16.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 12.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 4.0);
    protected static final VoxelShape UP_AABB = Block.box(0.0, 12.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape DOWN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 4.0, 16.0);
    protected static final float AABB_OFFSET = 2.0f;
    protected static final float EDGE_MIN = 6.0f;
    protected static final float EDGE_MAX = 10.0f;
    protected static final VoxelShape UP_ARM_AABB = Block.box(6.0, -4.0, 6.0, 10.0, 12.0, 10.0);
    protected static final VoxelShape DOWN_ARM_AABB = Block.box(6.0, 4.0, 6.0, 10.0, 20.0, 10.0);
    protected static final VoxelShape SOUTH_ARM_AABB = Block.box(6.0, 6.0, -4.0, 10.0, 10.0, 12.0);
    protected static final VoxelShape NORTH_ARM_AABB = Block.box(6.0, 6.0, 4.0, 10.0, 10.0, 20.0);
    protected static final VoxelShape EAST_ARM_AABB = Block.box(-4.0, 6.0, 6.0, 12.0, 10.0, 10.0);
    protected static final VoxelShape WEST_ARM_AABB = Block.box(4.0, 6.0, 6.0, 20.0, 10.0, 10.0);
    protected static final VoxelShape SHORT_UP_ARM_AABB = Block.box(6.0, 0.0, 6.0, 10.0, 12.0, 10.0);
    protected static final VoxelShape SHORT_DOWN_ARM_AABB = Block.box(6.0, 4.0, 6.0, 10.0, 16.0, 10.0);
    protected static final VoxelShape SHORT_SOUTH_ARM_AABB = Block.box(6.0, 6.0, 0.0, 10.0, 10.0, 12.0);
    protected static final VoxelShape SHORT_NORTH_ARM_AABB = Block.box(6.0, 6.0, 4.0, 10.0, 10.0, 16.0);
    protected static final VoxelShape SHORT_EAST_ARM_AABB = Block.box(0.0, 6.0, 6.0, 12.0, 10.0, 10.0);
    protected static final VoxelShape SHORT_WEST_ARM_AABB = Block.box(4.0, 6.0, 6.0, 16.0, 10.0, 10.0);
    private static final VoxelShape[] SHAPES_SHORT = BlockPistonExtension.makeShapes(true);
    private static final VoxelShape[] SHAPES_LONG = BlockPistonExtension.makeShapes(false);

    private static VoxelShape[] makeShapes(boolean var0) {
        return (VoxelShape[])Arrays.stream(EnumDirection.values()).map(var1 -> BlockPistonExtension.calculateShape(var1, var0)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape calculateShape(EnumDirection var0, boolean var1) {
        switch (var0) {
            default: {
                return VoxelShapes.or(DOWN_AABB, var1 ? SHORT_DOWN_ARM_AABB : DOWN_ARM_AABB);
            }
            case UP: {
                return VoxelShapes.or(UP_AABB, var1 ? SHORT_UP_ARM_AABB : UP_ARM_AABB);
            }
            case NORTH: {
                return VoxelShapes.or(NORTH_AABB, var1 ? SHORT_NORTH_ARM_AABB : NORTH_ARM_AABB);
            }
            case SOUTH: {
                return VoxelShapes.or(SOUTH_AABB, var1 ? SHORT_SOUTH_ARM_AABB : SOUTH_ARM_AABB);
            }
            case WEST: {
                return VoxelShapes.or(WEST_AABB, var1 ? SHORT_WEST_ARM_AABB : WEST_ARM_AABB);
            }
            case EAST: 
        }
        return VoxelShapes.or(EAST_AABB, var1 ? SHORT_EAST_ARM_AABB : EAST_ARM_AABB);
    }

    public BlockPistonExtension(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(TYPE, BlockPropertyPistonType.DEFAULT)).setValue(SHORT, false));
    }

    @Override
    public boolean useShapeForLightOcclusion(IBlockData var0) {
        return true;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return (var0.getValue(SHORT) != false ? SHAPES_SHORT : SHAPES_LONG)[var0.getValue(FACING).ordinal()];
    }

    private boolean isFittingBase(IBlockData var0, IBlockData var1) {
        Block var2 = var0.getValue(TYPE) == BlockPropertyPistonType.DEFAULT ? Blocks.PISTON : Blocks.STICKY_PISTON;
        return var1.is(var2) && var1.getValue(BlockPiston.EXTENDED) != false && var1.getValue(FACING) == var0.getValue(FACING);
    }

    @Override
    public void playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        BlockPosition var4;
        if (!var0.isClientSide && var3.getAbilities().instabuild && this.isFittingBase(var2, var0.getBlockState(var4 = var1.relative(var2.getValue(FACING).getOpposite())))) {
            var0.destroyBlock(var4, false);
        }
        super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        super.onRemove(var0, var1, var2, var3, var4);
        BlockPosition var5 = var2.relative(var0.getValue(FACING).getOpposite());
        if (this.isFittingBase(var0, var1.getBlockState(var5))) {
            var1.destroyBlock(var5, true);
        }
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1.getOpposite() == var0.getValue(FACING) && !var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        IBlockData var3 = var1.getBlockState(var2.relative(var0.getValue(FACING).getOpposite()));
        return this.isFittingBase(var0, var3) || var3.is(Blocks.MOVING_PISTON) && var3.getValue(FACING) == var0.getValue(FACING);
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        if (var0.canSurvive(var1, var2)) {
            BlockPosition var6 = var2.relative(var0.getValue(FACING).getOpposite());
            var1.getBlockState(var6).neighborChanged(var1, var6, var3, var4, false);
        }
    }

    @Override
    public ItemStack getCloneItemStack(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return new ItemStack(var2.getValue(TYPE) == BlockPropertyPistonType.STICKY ? Blocks.STICKY_PISTON : Blocks.PISTON);
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, TYPE, SHORT);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }
}

