/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.grower;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;

public abstract class WorldGenTreeProvider {
    @Nullable
    protected abstract Holder<? extends WorldGenFeatureConfigured<?, ?>> getConfiguredFeature(Random var1, boolean var2);

    public boolean growTree(WorldServer var0, ChunkGenerator var1, BlockPosition var2, IBlockData var3, Random var4) {
        Holder<WorldGenFeatureConfigured<?, ?>> var5 = this.getConfiguredFeature(var4, this.hasFlowers(var0, var2));
        if (var5 == null) {
            return false;
        }
        WorldGenFeatureConfigured<?, ?> var6 = var5.value();
        var0.setBlock(var2, Blocks.AIR.defaultBlockState(), 4);
        if (var6.place(var0, var1, var4, var2)) {
            return true;
        }
        var0.setBlock(var2, var3, 4);
        return false;
    }

    private boolean hasFlowers(GeneratorAccess var0, BlockPosition var1) {
        for (BlockPosition var3 : BlockPosition.MutableBlockPosition.betweenClosed(var1.below().north(2).west(2), var1.above().south(2).east(2))) {
            if (!var0.getBlockState(var3).is(TagsBlock.FLOWERS)) continue;
            return true;
        }
        return false;
    }
}

