/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.grower;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.WorldGenTreeProvider;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;

public abstract class WorldGenMegaTreeProvider
extends WorldGenTreeProvider {
    @Override
    public boolean growTree(WorldServer var0, ChunkGenerator var1, BlockPosition var2, IBlockData var3, Random var4) {
        for (int var5 = 0; var5 >= -1; --var5) {
            for (int var6 = 0; var6 >= -1; --var6) {
                if (!WorldGenMegaTreeProvider.isTwoByTwoSapling(var3, var0, var2, var5, var6)) continue;
                return this.placeMega(var0, var1, var2, var3, var4, var5, var6);
            }
        }
        return super.growTree(var0, var1, var2, var3, var4);
    }

    @Nullable
    protected abstract Holder<? extends WorldGenFeatureConfigured<?, ?>> getConfiguredMegaFeature(Random var1);

    public boolean placeMega(WorldServer var0, ChunkGenerator var1, BlockPosition var2, IBlockData var3, Random var4, int var5, int var6) {
        Holder<WorldGenFeatureConfigured<?, ?>> var7 = this.getConfiguredMegaFeature(var4);
        if (var7 == null) {
            return false;
        }
        WorldGenFeatureConfigured<?, ?> var8 = var7.value();
        IBlockData var9 = Blocks.AIR.defaultBlockState();
        var0.setBlock(var2.offset(var5, 0, var6), var9, 4);
        var0.setBlock(var2.offset(var5 + 1, 0, var6), var9, 4);
        var0.setBlock(var2.offset(var5, 0, var6 + 1), var9, 4);
        var0.setBlock(var2.offset(var5 + 1, 0, var6 + 1), var9, 4);
        if (var8.place(var0, var1, var4, var2.offset(var5, 0, var6))) {
            return true;
        }
        var0.setBlock(var2.offset(var5, 0, var6), var3, 4);
        var0.setBlock(var2.offset(var5 + 1, 0, var6), var3, 4);
        var0.setBlock(var2.offset(var5, 0, var6 + 1), var3, 4);
        var0.setBlock(var2.offset(var5 + 1, 0, var6 + 1), var3, 4);
        return false;
    }

    public static boolean isTwoByTwoSapling(IBlockData var0, IBlockAccess var1, BlockPosition var2, int var3, int var4) {
        Block var5 = var0.getBlock();
        return var1.getBlockState(var2.offset(var3, 0, var4)).is(var5) && var1.getBlockState(var2.offset(var3 + 1, 0, var4)).is(var5) && var1.getBlockState(var2.offset(var3, 0, var4 + 1)).is(var5) && var1.getBlockState(var2.offset(var3 + 1, 0, var4 + 1)).is(var5);
    }
}

