/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.FormattedString;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class TileEntitySign
extends TileEntity {
    public static final int LINES = 4;
    private static final String[] RAW_TEXT_FIELD_NAMES = new String[]{"Text1", "Text2", "Text3", "Text4"};
    private static final String[] FILTERED_TEXT_FIELD_NAMES = new String[]{"FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4"};
    public final IChatBaseComponent[] messages = new IChatBaseComponent[]{ChatComponentText.EMPTY, ChatComponentText.EMPTY, ChatComponentText.EMPTY, ChatComponentText.EMPTY};
    private final IChatBaseComponent[] filteredMessages = new IChatBaseComponent[]{ChatComponentText.EMPTY, ChatComponentText.EMPTY, ChatComponentText.EMPTY, ChatComponentText.EMPTY};
    public boolean isEditable = true;
    @Nullable
    private UUID playerWhoMayEdit;
    @Nullable
    private FormattedString[] renderMessages;
    private boolean renderMessagedFiltered;
    private EnumColor color = EnumColor.BLACK;
    private boolean hasGlowingText;

    public TileEntitySign(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SIGN, var0, var1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        for (int var1 = 0; var1 < 4; ++var1) {
            IChatBaseComponent var2 = this.messages[var1];
            String var3 = IChatBaseComponent.ChatSerializer.toJson(var2);
            var0.putString(RAW_TEXT_FIELD_NAMES[var1], var3);
            IChatBaseComponent var4 = this.filteredMessages[var1];
            if (var4.equals(var2)) continue;
            var0.putString(FILTERED_TEXT_FIELD_NAMES[var1], IChatBaseComponent.ChatSerializer.toJson(var4));
        }
        var0.putString("Color", this.color.getName());
        var0.putBoolean("GlowingText", this.hasGlowingText);
    }

    @Override
    public void load(NBTTagCompound var0) {
        this.isEditable = false;
        super.load(var0);
        this.color = EnumColor.byName(var0.getString("Color"), EnumColor.BLACK);
        for (int var1 = 0; var1 < 4; ++var1) {
            IChatBaseComponent var3;
            String var2 = var0.getString(RAW_TEXT_FIELD_NAMES[var1]);
            this.messages[var1] = var3 = this.loadLine(var2);
            String var4 = FILTERED_TEXT_FIELD_NAMES[var1];
            this.filteredMessages[var1] = var0.contains(var4, 8) ? this.loadLine(var0.getString(var4)) : var3;
        }
        this.renderMessages = null;
        this.hasGlowingText = var0.getBoolean("GlowingText");
    }

    private IChatBaseComponent loadLine(String var0) {
        IChatBaseComponent var1 = this.deserializeTextSafe(var0);
        if (this.level instanceof WorldServer) {
            try {
                return ChatComponentUtils.updateForEntity(this.createCommandSourceStack(null), var1, null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return var1;
    }

    private IChatBaseComponent deserializeTextSafe(String var0) {
        try {
            IChatMutableComponent var1 = IChatBaseComponent.ChatSerializer.fromJson(var0);
            if (var1 != null) {
                return var1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ChatComponentText.EMPTY;
    }

    public IChatBaseComponent getMessage(int var0, boolean var1) {
        return this.getMessages(var1)[var0];
    }

    public void setMessage(int var0, IChatBaseComponent var1) {
        this.setMessage(var0, var1, var1);
    }

    public void setMessage(int var0, IChatBaseComponent var1, IChatBaseComponent var2) {
        this.messages[var0] = var1;
        this.filteredMessages[var0] = var2;
        this.renderMessages = null;
    }

    public FormattedString[] getRenderMessages(boolean var0, Function<IChatBaseComponent, FormattedString> var1) {
        if (this.renderMessages == null || this.renderMessagedFiltered != var0) {
            this.renderMessagedFiltered = var0;
            this.renderMessages = new FormattedString[4];
            for (int var2 = 0; var2 < 4; ++var2) {
                this.renderMessages[var2] = var1.apply(this.getMessage(var2, var0));
            }
        }
        return this.renderMessages;
    }

    private IChatBaseComponent[] getMessages(boolean var0) {
        return var0 ? this.filteredMessages : this.messages;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean var0) {
        this.isEditable = var0;
        if (!var0) {
            this.playerWhoMayEdit = null;
        }
    }

    public void setAllowedPlayerEditor(UUID var0) {
        this.playerWhoMayEdit = var0;
    }

    @Nullable
    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    public boolean executeClickCommands(EntityPlayer var0) {
        for (IChatBaseComponent var4 : this.getMessages(var0.isTextFilteringEnabled())) {
            ChatModifier var5 = var4.getStyle();
            ChatClickable var6 = var5.getClickEvent();
            if (var6 == null || var6.getAction() != ChatClickable.EnumClickAction.RUN_COMMAND) continue;
            var0.getServer().getCommands().performCommand(this.createCommandSourceStack(var0), var6.getValue());
        }
        return true;
    }

    public CommandListenerWrapper createCommandSourceStack(@Nullable EntityPlayer var0) {
        String var1 = var0 == null ? "Sign" : var0.getName().getString();
        IChatBaseComponent var2 = var0 == null ? new ChatComponentText("Sign") : var0.getDisplayName();
        return new CommandListenerWrapper(ICommandListener.NULL, Vec3D.atCenterOf(this.worldPosition), Vec2F.ZERO, (WorldServer)this.level, 2, var1, var2, this.level.getServer(), var0);
    }

    public EnumColor getColor() {
        return this.color;
    }

    public boolean setColor(EnumColor var0) {
        if (var0 != this.getColor()) {
            this.color = var0;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean hasGlowingText() {
        return this.hasGlowingText;
    }

    public boolean setHasGlowingText(boolean var0) {
        if (this.hasGlowingText != var0) {
            this.hasGlowingText = var0;
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

