/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.INamable;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolSingle;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;

public class TileEntityJigsaw
extends TileEntity {
    public static final String TARGET = "target";
    public static final String POOL = "pool";
    public static final String JOINT = "joint";
    public static final String NAME = "name";
    public static final String FINAL_STATE = "final_state";
    private MinecraftKey name = new MinecraftKey("empty");
    private MinecraftKey target = new MinecraftKey("empty");
    private MinecraftKey pool = new MinecraftKey("empty");
    private JointType joint = JointType.ROLLABLE;
    private String finalState = "minecraft:air";

    public TileEntityJigsaw(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.JIGSAW, var0, var1);
    }

    public MinecraftKey getName() {
        return this.name;
    }

    public MinecraftKey getTarget() {
        return this.target;
    }

    public MinecraftKey getPool() {
        return this.pool;
    }

    public String getFinalState() {
        return this.finalState;
    }

    public JointType getJoint() {
        return this.joint;
    }

    public void setName(MinecraftKey var0) {
        this.name = var0;
    }

    public void setTarget(MinecraftKey var0) {
        this.target = var0;
    }

    public void setPool(MinecraftKey var0) {
        this.pool = var0;
    }

    public void setFinalState(String var0) {
        this.finalState = var0;
    }

    public void setJoint(JointType var0) {
        this.joint = var0;
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        var0.putString(NAME, this.name.toString());
        var0.putString(TARGET, this.target.toString());
        var0.putString(POOL, this.pool.toString());
        var0.putString(FINAL_STATE, this.finalState);
        var0.putString(JOINT, this.joint.getSerializedName());
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.name = new MinecraftKey(var0.getString(NAME));
        this.target = new MinecraftKey(var0.getString(TARGET));
        this.pool = new MinecraftKey(var0.getString(POOL));
        this.finalState = var0.getString(FINAL_STATE);
        this.joint = JointType.byName(var0.getString(JOINT)).orElseGet(() -> BlockJigsaw.getFrontFacing(this.getBlockState()).getAxis().isHorizontal() ? JointType.ALIGNED : JointType.ROLLABLE);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public void generate(WorldServer var0, int var1, boolean var2) {
        ChunkGenerator var3 = var0.getChunkSource().getGenerator();
        DefinedStructureManager var4 = var0.getStructureManager();
        StructureManager var5 = var0.structureFeatureManager();
        Random var6 = var0.getRandom();
        BlockPosition var7 = this.getBlockPos();
        ArrayList var8 = Lists.newArrayList();
        DefinedStructure var9 = new DefinedStructure();
        var9.fillFromWorld(var0, var7, new BaseBlockPosition(1, 1, 1), false, null);
        WorldGenFeatureDefinedStructurePoolSingle var10 = new WorldGenFeatureDefinedStructurePoolSingle(var9);
        WorldGenFeaturePillagerOutpostPoolPiece var11 = new WorldGenFeaturePillagerOutpostPoolPiece(var4, var10, var7, 1, EnumBlockRotation.NONE, new StructureBoundingBox(var7));
        WorldGenFeatureDefinedStructureJigsawPlacement.addPieces(var0.registryAccess(), var11, var1, WorldGenFeaturePillagerOutpostPoolPiece::new, var3, var4, var8, var6, var0);
        for (WorldGenFeaturePillagerOutpostPoolPiece var13 : var8) {
            var13.place(var0, var5, var3, var6, StructureBoundingBox.infinite(), var7, var2);
        }
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    public static final class JointType
    extends Enum<JointType>
    implements INamable {
        public static final /* enum */ JointType ROLLABLE = new JointType("rollable");
        public static final /* enum */ JointType ALIGNED = new JointType("aligned");
        private final String name;
        private static final /* synthetic */ JointType[] d;

        public static JointType[] values() {
            return (JointType[])d.clone();
        }

        public static JointType valueOf(String var0) {
            return Enum.valueOf(JointType.class, var0);
        }

        private JointType(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static Optional<JointType> byName(String var0) {
            return Arrays.stream(JointType.values()).filter(var1 -> var1.getSerializedName().equals(var0)).findFirst();
        }

        public IChatBaseComponent getTranslatedName() {
            return new ChatMessage("jigsaw_block.joint." + this.name);
        }

        private static /* synthetic */ JointType[] b() {
            return new JointType[]{ROLLABLE, ALIGNED};
        }

        static {
            d = JointType.b();
        }
    }
}

