/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntityEnchantTable
extends TileEntity
implements INamableTileEntity {
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;
    private static final Random RANDOM = new Random();
    private IChatBaseComponent name;

    public TileEntityEnchantTable(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.ENCHANTING_TABLE, var0, var1);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        if (this.hasCustomName()) {
            var0.putString("CustomName", IChatBaseComponent.ChatSerializer.toJson(this.name));
        }
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        if (var0.contains("CustomName", 8)) {
            this.name = IChatBaseComponent.ChatSerializer.fromJson(var0.getString("CustomName"));
        }
    }

    public static void bookAnimationTick(World var0, BlockPosition var1, IBlockData var2, TileEntityEnchantTable var3) {
        float var5;
        var3.oOpen = var3.open;
        var3.oRot = var3.rot;
        EntityHuman var4 = var0.getNearestPlayer((double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, 3.0, false);
        if (var4 != null) {
            double var52 = var4.getX() - ((double)var1.getX() + 0.5);
            double var7 = var4.getZ() - ((double)var1.getZ() + 0.5);
            var3.tRot = (float)MathHelper.atan2(var7, var52);
            var3.open += 0.1f;
            if (var3.open < 0.5f || RANDOM.nextInt(40) == 0) {
                float var9 = var3.flipT;
                do {
                    var3.flipT += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
                } while (var9 == var3.flipT);
            }
        } else {
            var3.tRot += 0.02f;
            var3.open -= 0.1f;
        }
        while (var3.rot >= (float)Math.PI) {
            var3.rot -= (float)Math.PI * 2;
        }
        while (var3.rot < (float)(-Math.PI)) {
            var3.rot += (float)Math.PI * 2;
        }
        while (var3.tRot >= (float)Math.PI) {
            var3.tRot -= (float)Math.PI * 2;
        }
        while (var3.tRot < (float)(-Math.PI)) {
            var3.tRot += (float)Math.PI * 2;
        }
        for (var5 = var3.tRot - var3.rot; var5 >= (float)Math.PI; var5 -= (float)Math.PI * 2) {
        }
        while (var5 < (float)(-Math.PI)) {
            var5 += (float)Math.PI * 2;
        }
        var3.rot += var5 * 0.4f;
        var3.open = MathHelper.clamp(var3.open, 0.0f, 1.0f);
        ++var3.time;
        var3.oFlip = var3.flip;
        float var6 = (var3.flipT - var3.flip) * 0.4f;
        float var7 = 0.2f;
        var6 = MathHelper.clamp(var6, -0.2f, 0.2f);
        var3.flipA += (var6 - var3.flipA) * 0.9f;
        var3.flip += var3.flipA;
    }

    @Override
    public IChatBaseComponent getName() {
        if (this.name != null) {
            return this.name;
        }
        return new ChatMessage("container.enchant");
    }

    public void setCustomName(@Nullable IChatBaseComponent var0) {
        this.name = var0;
    }

    @Override
    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.name;
    }
}

