/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerDispenser;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntityDispenser
extends TileEntityLootable {
    private static final Random RANDOM = new Random();
    public static final int CONTAINER_SIZE = 9;
    private NonNullList<ItemStack> items = NonNullList.withSize(9, ItemStack.EMPTY);

    protected TileEntityDispenser(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        super(var0, var1, var2);
    }

    public TileEntityDispenser(BlockPosition var0, IBlockData var1) {
        this(TileEntityTypes.DISPENSER, var0, var1);
    }

    @Override
    public int getContainerSize() {
        return 9;
    }

    public int getRandomSlot() {
        this.unpackLootTable(null);
        int var0 = -1;
        int var1 = 1;
        for (int var2 = 0; var2 < this.items.size(); ++var2) {
            if (this.items.get(var2).isEmpty() || RANDOM.nextInt(var1++) != 0) continue;
            var0 = var2;
        }
        return var0;
    }

    public int addItem(ItemStack var0) {
        for (int var1 = 0; var1 < this.items.size(); ++var1) {
            if (!this.items.get(var1).isEmpty()) continue;
            this.setItem(var1, var0);
            return var1;
        }
        return -1;
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return new ChatMessage("container.dispenser");
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(var0)) {
            ContainerUtil.loadAllItems(var0, this.items);
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        if (!this.trySaveLootTable(var0)) {
            ContainerUtil.saveAllItems(var0, this.items);
        }
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> var0) {
        this.items = var0;
    }

    @Override
    protected Container createMenu(int var0, PlayerInventory var1) {
        return new ContainerDispenser(var0, var1, this);
    }
}

