/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.EnumColor;

public final class EnumBannerPatternType
extends Enum<EnumBannerPatternType> {
    public static final /* enum */ EnumBannerPatternType BASE = new EnumBannerPatternType("base", "b", false);
    public static final /* enum */ EnumBannerPatternType SQUARE_BOTTOM_LEFT = new EnumBannerPatternType("square_bottom_left", "bl");
    public static final /* enum */ EnumBannerPatternType SQUARE_BOTTOM_RIGHT = new EnumBannerPatternType("square_bottom_right", "br");
    public static final /* enum */ EnumBannerPatternType SQUARE_TOP_LEFT = new EnumBannerPatternType("square_top_left", "tl");
    public static final /* enum */ EnumBannerPatternType SQUARE_TOP_RIGHT = new EnumBannerPatternType("square_top_right", "tr");
    public static final /* enum */ EnumBannerPatternType STRIPE_BOTTOM = new EnumBannerPatternType("stripe_bottom", "bs");
    public static final /* enum */ EnumBannerPatternType STRIPE_TOP = new EnumBannerPatternType("stripe_top", "ts");
    public static final /* enum */ EnumBannerPatternType STRIPE_LEFT = new EnumBannerPatternType("stripe_left", "ls");
    public static final /* enum */ EnumBannerPatternType STRIPE_RIGHT = new EnumBannerPatternType("stripe_right", "rs");
    public static final /* enum */ EnumBannerPatternType STRIPE_CENTER = new EnumBannerPatternType("stripe_center", "cs");
    public static final /* enum */ EnumBannerPatternType STRIPE_MIDDLE = new EnumBannerPatternType("stripe_middle", "ms");
    public static final /* enum */ EnumBannerPatternType STRIPE_DOWNRIGHT = new EnumBannerPatternType("stripe_downright", "drs");
    public static final /* enum */ EnumBannerPatternType STRIPE_DOWNLEFT = new EnumBannerPatternType("stripe_downleft", "dls");
    public static final /* enum */ EnumBannerPatternType STRIPE_SMALL = new EnumBannerPatternType("small_stripes", "ss");
    public static final /* enum */ EnumBannerPatternType CROSS = new EnumBannerPatternType("cross", "cr");
    public static final /* enum */ EnumBannerPatternType STRAIGHT_CROSS = new EnumBannerPatternType("straight_cross", "sc");
    public static final /* enum */ EnumBannerPatternType TRIANGLE_BOTTOM = new EnumBannerPatternType("triangle_bottom", "bt");
    public static final /* enum */ EnumBannerPatternType TRIANGLE_TOP = new EnumBannerPatternType("triangle_top", "tt");
    public static final /* enum */ EnumBannerPatternType TRIANGLES_BOTTOM = new EnumBannerPatternType("triangles_bottom", "bts");
    public static final /* enum */ EnumBannerPatternType TRIANGLES_TOP = new EnumBannerPatternType("triangles_top", "tts");
    public static final /* enum */ EnumBannerPatternType DIAGONAL_LEFT = new EnumBannerPatternType("diagonal_left", "ld");
    public static final /* enum */ EnumBannerPatternType DIAGONAL_RIGHT = new EnumBannerPatternType("diagonal_up_right", "rd");
    public static final /* enum */ EnumBannerPatternType DIAGONAL_LEFT_MIRROR = new EnumBannerPatternType("diagonal_up_left", "lud");
    public static final /* enum */ EnumBannerPatternType DIAGONAL_RIGHT_MIRROR = new EnumBannerPatternType("diagonal_right", "rud");
    public static final /* enum */ EnumBannerPatternType CIRCLE_MIDDLE = new EnumBannerPatternType("circle", "mc");
    public static final /* enum */ EnumBannerPatternType RHOMBUS_MIDDLE = new EnumBannerPatternType("rhombus", "mr");
    public static final /* enum */ EnumBannerPatternType HALF_VERTICAL = new EnumBannerPatternType("half_vertical", "vh");
    public static final /* enum */ EnumBannerPatternType HALF_HORIZONTAL = new EnumBannerPatternType("half_horizontal", "hh");
    public static final /* enum */ EnumBannerPatternType HALF_VERTICAL_MIRROR = new EnumBannerPatternType("half_vertical_right", "vhr");
    public static final /* enum */ EnumBannerPatternType HALF_HORIZONTAL_MIRROR = new EnumBannerPatternType("half_horizontal_bottom", "hhb");
    public static final /* enum */ EnumBannerPatternType BORDER = new EnumBannerPatternType("border", "bo");
    public static final /* enum */ EnumBannerPatternType CURLY_BORDER = new EnumBannerPatternType("curly_border", "cbo");
    public static final /* enum */ EnumBannerPatternType GRADIENT = new EnumBannerPatternType("gradient", "gra");
    public static final /* enum */ EnumBannerPatternType GRADIENT_UP = new EnumBannerPatternType("gradient_up", "gru");
    public static final /* enum */ EnumBannerPatternType BRICKS = new EnumBannerPatternType("bricks", "bri");
    public static final /* enum */ EnumBannerPatternType GLOBE = new EnumBannerPatternType("globe", "glb", true);
    public static final /* enum */ EnumBannerPatternType CREEPER = new EnumBannerPatternType("creeper", "cre", true);
    public static final /* enum */ EnumBannerPatternType SKULL = new EnumBannerPatternType("skull", "sku", true);
    public static final /* enum */ EnumBannerPatternType FLOWER = new EnumBannerPatternType("flower", "flo", true);
    public static final /* enum */ EnumBannerPatternType MOJANG = new EnumBannerPatternType("mojang", "moj", true);
    public static final /* enum */ EnumBannerPatternType PIGLIN = new EnumBannerPatternType("piglin", "pig", true);
    private static final EnumBannerPatternType[] VALUES;
    public static final int COUNT;
    public static final int PATTERN_ITEM_COUNT;
    public static final int AVAILABLE_PATTERNS;
    private final boolean hasPatternItem;
    private final String filename;
    final String hashname;
    private static final /* synthetic */ EnumBannerPatternType[] W;

    public static EnumBannerPatternType[] values() {
        return (EnumBannerPatternType[])W.clone();
    }

    public static EnumBannerPatternType valueOf(String var0) {
        return Enum.valueOf(EnumBannerPatternType.class, var0);
    }

    private EnumBannerPatternType(String var2, String var3) {
        this(var2, var3, false);
    }

    private EnumBannerPatternType(String var2, String var3, boolean var4) {
        this.filename = var2;
        this.hashname = var3;
        this.hasPatternItem = var4;
    }

    public MinecraftKey location(boolean var0) {
        String var1 = var0 ? "banner" : "shield";
        return new MinecraftKey("entity/" + var1 + "/" + this.getFilename());
    }

    public String getFilename() {
        return this.filename;
    }

    public String getHashname() {
        return this.hashname;
    }

    @Nullable
    public static EnumBannerPatternType byHash(String var0) {
        for (EnumBannerPatternType var4 : EnumBannerPatternType.values()) {
            if (!var4.hashname.equals(var0)) continue;
            return var4;
        }
        return null;
    }

    @Nullable
    public static EnumBannerPatternType byFilename(String var0) {
        for (EnumBannerPatternType var4 : EnumBannerPatternType.values()) {
            if (!var4.filename.equals(var0)) continue;
            return var4;
        }
        return null;
    }

    private static /* synthetic */ EnumBannerPatternType[] c() {
        return new EnumBannerPatternType[]{BASE, SQUARE_BOTTOM_LEFT, SQUARE_BOTTOM_RIGHT, SQUARE_TOP_LEFT, SQUARE_TOP_RIGHT, STRIPE_BOTTOM, STRIPE_TOP, STRIPE_LEFT, STRIPE_RIGHT, STRIPE_CENTER, STRIPE_MIDDLE, STRIPE_DOWNRIGHT, STRIPE_DOWNLEFT, STRIPE_SMALL, CROSS, STRAIGHT_CROSS, TRIANGLE_BOTTOM, TRIANGLE_TOP, TRIANGLES_BOTTOM, TRIANGLES_TOP, DIAGONAL_LEFT, DIAGONAL_RIGHT, DIAGONAL_LEFT_MIRROR, DIAGONAL_RIGHT_MIRROR, CIRCLE_MIDDLE, RHOMBUS_MIDDLE, HALF_VERTICAL, HALF_HORIZONTAL, HALF_VERTICAL_MIRROR, HALF_HORIZONTAL_MIRROR, BORDER, CURLY_BORDER, GRADIENT, GRADIENT_UP, BRICKS, GLOBE, CREEPER, SKULL, FLOWER, MOJANG, PIGLIN};
    }

    static {
        W = EnumBannerPatternType.c();
        VALUES = EnumBannerPatternType.values();
        COUNT = VALUES.length;
        PATTERN_ITEM_COUNT = (int)Arrays.stream(VALUES).filter(var0 -> var0.hasPatternItem).count();
        AVAILABLE_PATTERNS = COUNT - PATTERN_ITEM_COUNT - 1;
    }

    public static class a {
        private final List<Pair<EnumBannerPatternType, EnumColor>> patterns = Lists.newArrayList();

        public a addPattern(EnumBannerPatternType var0, EnumColor var1) {
            return this.addPattern((Pair<EnumBannerPatternType, EnumColor>)Pair.of((Object)((Object)var0), (Object)var1));
        }

        public a addPattern(Pair<EnumBannerPatternType, EnumColor> var0) {
            this.patterns.add(var0);
            return this;
        }

        public NBTTagList toListTag() {
            NBTTagList var0 = new NBTTagList();
            for (Pair<EnumBannerPatternType, EnumColor> var2 : this.patterns) {
                NBTTagCompound var3 = new NBTTagCompound();
                var3.putString("Pattern", ((EnumBannerPatternType)((Object)var2.getFirst())).hashname);
                var3.putInt("Color", ((EnumColor)var2.getSecond()).getId());
                var0.add(var3);
            }
            return var0;
        }
    }
}

