/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockTorch
extends Block {
    protected static final int AABB_STANDING_OFFSET = 2;
    protected static final VoxelShape AABB = Block.box(6.0, 0.0, 6.0, 10.0, 10.0, 10.0);
    protected final ParticleParam flameParticle;

    protected BlockTorch(BlockBase.Info var0, ParticleParam var1) {
        super(var0);
        this.flameParticle = var1;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return AABB;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.DOWN && !this.canSurvive(var0, var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return BlockTorch.canSupportCenter(var1, var2.below(), EnumDirection.UP);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, Random var3) {
        double var4 = (double)var2.getX() + 0.5;
        double var6 = (double)var2.getY() + 0.7;
        double var8 = (double)var2.getZ() + 0.5;
        var1.addParticle(Particles.SMOKE, var4, var6, var8, 0.0, 0.0, 0.0);
        var1.addParticle(this.flameParticle, var4, var6, var8, 0.0, 0.0, 0.0);
    }
}

