/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockSmoker
extends BlockFurnace {
    protected BlockSmoker(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntitySmoker(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return BlockSmoker.createFurnaceTicker(var0, var2, TileEntityTypes.SMOKER);
    }

    @Override
    protected void openContainer(World var0, BlockPosition var1, EntityHuman var2) {
        TileEntity var3 = var0.getBlockEntity(var1);
        if (var3 instanceof TileEntitySmoker) {
            var2.openMenu((ITileInventory)((Object)var3));
            var2.awardStat(StatisticList.INTERACT_WITH_SMOKER);
        }
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, Random var3) {
        if (!var0.getValue(LIT).booleanValue()) {
            return;
        }
        double var4 = (double)var2.getX() + 0.5;
        double var6 = var2.getY();
        double var8 = (double)var2.getZ() + 0.5;
        if (var3.nextDouble() < 0.1) {
            var1.playLocalSound(var4, var6, var8, SoundEffects.SMOKER_SMOKE, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        var1.addParticle(Particles.SMOKE, var4, var6 + 1.1, var8, 0.0, 0.0, 0.0);
    }
}

