/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class BlockPoweredRail
extends BlockMinecartTrackAbstract {
    public static final BlockStateEnum<BlockPropertyTrackPosition> SHAPE = BlockProperties.RAIL_SHAPE_STRAIGHT;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;

    protected BlockPoweredRail(BlockBase.Info var0) {
        super(true, var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH)).setValue(POWERED, false)).setValue(WATERLOGGED, false));
    }

    protected boolean findPoweredRailSignal(World var0, BlockPosition var1, IBlockData var2, boolean var3, int var4) {
        if (var4 >= 8) {
            return false;
        }
        int var5 = var1.getX();
        int var6 = var1.getY();
        int var7 = var1.getZ();
        boolean var8 = true;
        BlockPropertyTrackPosition var9 = var2.getValue(SHAPE);
        switch (var9) {
            case NORTH_SOUTH: {
                if (var3) {
                    ++var7;
                    break;
                }
                --var7;
                break;
            }
            case EAST_WEST: {
                if (var3) {
                    --var5;
                    break;
                }
                ++var5;
                break;
            }
            case ASCENDING_EAST: {
                if (var3) {
                    --var5;
                } else {
                    ++var5;
                    ++var6;
                    var8 = false;
                }
                var9 = BlockPropertyTrackPosition.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (var3) {
                    --var5;
                    ++var6;
                    var8 = false;
                } else {
                    ++var5;
                }
                var9 = BlockPropertyTrackPosition.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (var3) {
                    ++var7;
                } else {
                    --var7;
                    ++var6;
                    var8 = false;
                }
                var9 = BlockPropertyTrackPosition.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (var3) {
                    ++var7;
                    ++var6;
                    var8 = false;
                } else {
                    --var7;
                }
                var9 = BlockPropertyTrackPosition.NORTH_SOUTH;
            }
        }
        if (this.isSameRailWithPower(var0, new BlockPosition(var5, var6, var7), var3, var4, var9)) {
            return true;
        }
        return var8 && this.isSameRailWithPower(var0, new BlockPosition(var5, var6 - 1, var7), var3, var4, var9);
    }

    protected boolean isSameRailWithPower(World var0, BlockPosition var1, boolean var2, int var3, BlockPropertyTrackPosition var4) {
        IBlockData var5 = var0.getBlockState(var1);
        if (!var5.is(this)) {
            return false;
        }
        BlockPropertyTrackPosition var6 = var5.getValue(SHAPE);
        if (var4 == BlockPropertyTrackPosition.EAST_WEST && (var6 == BlockPropertyTrackPosition.NORTH_SOUTH || var6 == BlockPropertyTrackPosition.ASCENDING_NORTH || var6 == BlockPropertyTrackPosition.ASCENDING_SOUTH)) {
            return false;
        }
        if (var4 == BlockPropertyTrackPosition.NORTH_SOUTH && (var6 == BlockPropertyTrackPosition.EAST_WEST || var6 == BlockPropertyTrackPosition.ASCENDING_EAST || var6 == BlockPropertyTrackPosition.ASCENDING_WEST)) {
            return false;
        }
        if (var5.getValue(POWERED).booleanValue()) {
            if (var0.hasNeighborSignal(var1)) {
                return true;
            }
            return this.findPoweredRailSignal(var0, var1, var5, var2, var3 + 1);
        }
        return false;
    }

    @Override
    protected void updateState(IBlockData var0, World var1, BlockPosition var2, Block var3) {
        boolean var5;
        boolean var4 = var0.getValue(POWERED);
        boolean bl = var5 = var1.hasNeighborSignal(var2) || this.findPoweredRailSignal(var1, var2, var0, true, 0) || this.findPoweredRailSignal(var1, var2, var0, false, 0);
        if (var5 != var4) {
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, var5), 3);
            var1.updateNeighborsAt(var2.below(), this);
            if (var0.getValue(SHAPE).isAscending()) {
                var1.updateNeighborsAt(var2.above(), this);
            }
        }
    }

    @Override
    public IBlockState<BlockPropertyTrackPosition> getShapeProperty() {
        return SHAPE;
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                switch (var0.getValue(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (var0.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (var0.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                }
            }
        }
        return var0;
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        BlockPropertyTrackPosition var2 = var0.getValue(SHAPE);
        switch (var1) {
            case LEFT_RIGHT: {
                switch (var2) {
                    case ASCENDING_NORTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                }
                break;
            }
            case FRONT_BACK: {
                switch (var2) {
                    case ASCENDING_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (IBlockData)var0.setValue(SHAPE, BlockPropertyTrackPosition.NORTH_WEST);
                    }
                }
                break;
            }
        }
        return super.mirror(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(SHAPE, POWERED, WATERLOGGED);
    }
}

