/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockIronBars
extends BlockTall {
    protected BlockIronBars(BlockBase.Info var0) {
        super(1.0f, 1.0f, 16.0f, 16.0f, 16.0f, var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false)).setValue(WATERLOGGED, false));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        Fluid var3 = var0.getLevel().getFluidState(var0.getClickedPos());
        BlockPosition var4 = var2.north();
        BlockPosition var5 = var2.south();
        BlockPosition var6 = var2.west();
        BlockPosition var7 = var2.east();
        IBlockData var8 = var1.getBlockState(var4);
        IBlockData var9 = var1.getBlockState(var5);
        IBlockData var10 = var1.getBlockState(var6);
        IBlockData var11 = var1.getBlockState(var7);
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(NORTH, this.attachsTo(var8, var8.isFaceSturdy(var1, var4, EnumDirection.SOUTH)))).setValue(SOUTH, this.attachsTo(var9, var9.isFaceSturdy(var1, var5, EnumDirection.NORTH)))).setValue(WEST, this.attachsTo(var10, var10.isFaceSturdy(var1, var6, EnumDirection.EAST)))).setValue(EAST, this.attachsTo(var11, var11.isFaceSturdy(var1, var7, EnumDirection.WEST)))).setValue(WATERLOGGED, var3.getType() == FluidTypes.WATER);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        if (var1.getAxis().isHorizontal()) {
            return (IBlockData)var0.setValue((IBlockState)PROPERTY_BY_DIRECTION.get(var1), this.attachsTo(var2, var2.isFaceSturdy(var3, var5, var1.getOpposite())));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public VoxelShape getVisualShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return VoxelShapes.empty();
    }

    @Override
    public boolean skipRendering(IBlockData var0, IBlockData var1, EnumDirection var2) {
        if (var1.is(this)) {
            if (!var2.getAxis().isHorizontal()) {
                return true;
            }
            if (((Boolean)var0.getValue((IBlockState)PROPERTY_BY_DIRECTION.get(var2))).booleanValue() && ((Boolean)var1.getValue((IBlockState)PROPERTY_BY_DIRECTION.get(var2.getOpposite()))).booleanValue()) {
                return true;
            }
        }
        return super.skipRendering(var0, var1, var2);
    }

    public final boolean attachsTo(IBlockData var0, boolean var1) {
        return !BlockIronBars.isExceptionForConnection(var0) && var1 || var0.getBlock() instanceof BlockIronBars || var0.is(TagsBlock.WALLS);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(NORTH, EAST, WEST, SOUTH, WATERLOGGED);
    }
}

