/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockFlowerPot
extends Block {
    private static final Map<Block, Block> POTTED_BY_CONTENT = Maps.newHashMap();
    public static final float AABB_SIZE = 3.0f;
    protected static final VoxelShape SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final Block content;

    public BlockFlowerPot(Block var0, BlockBase.Info var1) {
        super(var1);
        this.content = var0;
        POTTED_BY_CONTENT.put(var0, this);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        boolean var10;
        ItemStack var6 = var3.getItemInHand(var4);
        Item var7 = var6.getItem();
        IBlockData var8 = (var7 instanceof ItemBlock ? POTTED_BY_CONTENT.getOrDefault(((ItemBlock)var7).getBlock(), Blocks.AIR) : Blocks.AIR).defaultBlockState();
        boolean var9 = var8.is(Blocks.AIR);
        if (var9 != (var10 = this.isEmpty())) {
            if (var10) {
                var1.setBlock(var2, var8, 3);
                var3.awardStat(StatisticList.POT_FLOWER);
                if (!var3.getAbilities().instabuild) {
                    var6.shrink(1);
                }
            } else {
                ItemStack var11 = new ItemStack(this.content);
                if (var6.isEmpty()) {
                    var3.setItemInHand(var4, var11);
                } else if (!var3.addItem(var11)) {
                    var3.drop(var11, false);
                }
                var1.setBlock(var2, Blocks.FLOWER_POT.defaultBlockState(), 3);
            }
            var1.gameEvent((Entity)var3, GameEvent.BLOCK_CHANGE, var2);
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public ItemStack getCloneItemStack(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        if (this.isEmpty()) {
            return super.getCloneItemStack(var0, var1, var2);
        }
        return new ItemStack(this.content);
    }

    private boolean isEmpty() {
        return this.content == Blocks.AIR;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.DOWN && !var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    public Block getContent() {
        return this.content;
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }
}

