/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Material;

public class BlockFalling
extends Block
implements Fallable {
    public BlockFalling(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        var1.scheduleTick(var2, this, this.getDelayAfterPlace());
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        var3.scheduleTick(var4, this, this.getDelayAfterPlace());
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, Random var3) {
        if (!BlockFalling.isFree(var1.getBlockState(var2.below())) || var2.getY() < var1.getMinBuildHeight()) {
            return;
        }
        EntityFallingBlock var4 = EntityFallingBlock.fall(var1, var2, var0);
        this.falling(var4);
    }

    protected void falling(EntityFallingBlock var0) {
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public static boolean isFree(IBlockData var0) {
        Material var1 = var0.getMaterial();
        return var0.isAir() || var0.is(TagsBlock.FIRE) || var1.isLiquid() || var1.isReplaceable();
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, Random var3) {
        BlockPosition var4;
        if (var3.nextInt(16) == 0 && BlockFalling.isFree(var1.getBlockState(var4 = var2.below()))) {
            double var5 = (double)var2.getX() + var3.nextDouble();
            double var7 = (double)var2.getY() - 0.05;
            double var9 = (double)var2.getZ() + var3.nextDouble();
            var1.addParticle(new ParticleParamBlock(Particles.FALLING_DUST, var0), var5, var7, var9, 0.0, 0.0, 0.0);
        }
    }

    public int getDustColor(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return -16777216;
    }
}

