/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;

public class WorldChunkManagerTheEnd
extends WorldChunkManager {
    public static final Codec<WorldChunkManagerTheEnd> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)RegistryOps.retrieveRegistry(IRegistry.BIOME_REGISTRY).forGetter(var0 -> null), (App)Codec.LONG.fieldOf("seed").stable().forGetter(var0 -> var0.seed)).apply((Applicative)var02, var02.stable(WorldChunkManagerTheEnd::new)));
    private static final float ISLAND_THRESHOLD = -0.9f;
    public static final int ISLAND_CHUNK_DISTANCE = 64;
    private static final long ISLAND_CHUNK_DISTANCE_SQR = 4096L;
    private final NoiseGenerator3Handler islandNoise;
    private final long seed;
    private final Holder<BiomeBase> end;
    private final Holder<BiomeBase> highlands;
    private final Holder<BiomeBase> midlands;
    private final Holder<BiomeBase> islands;
    private final Holder<BiomeBase> barrens;

    public WorldChunkManagerTheEnd(IRegistry<BiomeBase> var0, long var1) {
        this(var1, var0.getOrCreateHolder(Biomes.THE_END), var0.getOrCreateHolder(Biomes.END_HIGHLANDS), var0.getOrCreateHolder(Biomes.END_MIDLANDS), var0.getOrCreateHolder(Biomes.SMALL_END_ISLANDS), var0.getOrCreateHolder(Biomes.END_BARRENS));
    }

    private WorldChunkManagerTheEnd(long var0, Holder<BiomeBase> var2, Holder<BiomeBase> var3, Holder<BiomeBase> var4, Holder<BiomeBase> var5, Holder<BiomeBase> var6) {
        super((List<Holder<BiomeBase>>)ImmutableList.of(var2, var3, var4, var5, var6));
        this.seed = var0;
        this.end = var2;
        this.highlands = var3;
        this.midlands = var4;
        this.islands = var5;
        this.barrens = var6;
        SeededRandom var7 = new SeededRandom(new LegacyRandomSource(var0));
        var7.consumeCount(17292);
        this.islandNoise = new NoiseGenerator3Handler(var7);
    }

    @Override
    protected Codec<? extends WorldChunkManager> codec() {
        return CODEC;
    }

    @Override
    public WorldChunkManager withSeed(long var0) {
        return new WorldChunkManagerTheEnd(var0, this.end, this.highlands, this.midlands, this.islands, this.barrens);
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2, Climate.Sampler var3) {
        int var4 = var0 >> 2;
        int var5 = var2 >> 2;
        if ((long)var4 * (long)var4 + (long)var5 * (long)var5 <= 4096L) {
            return this.end;
        }
        float var6 = WorldChunkManagerTheEnd.getHeightValue(this.islandNoise, var4 * 2 + 1, var5 * 2 + 1);
        if (var6 > 40.0f) {
            return this.highlands;
        }
        if (var6 >= 0.0f) {
            return this.midlands;
        }
        if (var6 < -20.0f) {
            return this.islands;
        }
        return this.barrens;
    }

    public boolean stable(long var0) {
        return this.seed == var0;
    }

    public static float getHeightValue(NoiseGenerator3Handler var0, int var1, int var2) {
        int var3 = var1 / 2;
        int var4 = var2 / 2;
        int var5 = var1 % 2;
        int var6 = var2 % 2;
        float var7 = 100.0f - MathHelper.sqrt(var1 * var1 + var2 * var2) * 8.0f;
        var7 = MathHelper.clamp(var7, -100.0f, 80.0f);
        for (int var8 = -12; var8 <= 12; ++var8) {
            for (int var9 = -12; var9 <= 12; ++var9) {
                long var10 = var3 + var8;
                long var12 = var4 + var9;
                if (var10 * var10 + var12 * var12 <= 4096L || !(var0.getValue(var10, var12) < (double)-0.9f)) continue;
                float var14 = (MathHelper.abs(var10) * 3439.0f + MathHelper.abs(var12) * 147.0f) % 13.0f + 9.0f;
                float var15 = var5 - var8 * 2;
                float var16 = var6 - var9 * 2;
                float var17 = 100.0f - MathHelper.sqrt(var15 * var15 + var16 * var16) * var14;
                var17 = MathHelper.clamp(var17, -100.0f, 80.0f);
                var7 = Math.max(var7, var17);
            }
        }
        return var7;
    }
}

