/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;

public class WorldChunkManagerCheckerBoard
extends WorldChunkManager {
    public static final Codec<WorldChunkManagerCheckerBoard> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)BiomeBase.LIST_CODEC.fieldOf("biomes").forGetter(var0 -> var0.allowedBiomes), (App)Codec.intRange((int)0, (int)62).fieldOf("scale").orElse((Object)2).forGetter(var0 -> var0.size)).apply((Applicative)var02, WorldChunkManagerCheckerBoard::new));
    private final HolderSet<BiomeBase> allowedBiomes;
    private final int bitShift;
    private final int size;

    public WorldChunkManagerCheckerBoard(HolderSet<BiomeBase> var0, int var1) {
        super(var0.stream());
        this.allowedBiomes = var0;
        this.bitShift = var1 + 2;
        this.size = var1;
    }

    @Override
    protected Codec<? extends WorldChunkManager> codec() {
        return CODEC;
    }

    @Override
    public WorldChunkManager withSeed(long var0) {
        return this;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2, Climate.Sampler var3) {
        return this.allowedBiomes.get(Math.floorMod((var0 >> this.bitShift) + (var2 >> this.bitShift), this.allowedBiomes.size()));
    }
}

