/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Graph;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManagerCheckerBoard;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class WorldChunkManager
implements BiomeResolver {
    public static final Codec<WorldChunkManager> CODEC;
    private final Set<Holder<BiomeBase>> possibleBiomes;
    private final Supplier<List<b>> featuresPerStep;

    protected WorldChunkManager(Stream<Holder<BiomeBase>> var0) {
        this(var0.distinct().toList());
    }

    protected WorldChunkManager(List<Holder<BiomeBase>> var0) {
        this.possibleBiomes = new ObjectLinkedOpenHashSet(var0);
        this.featuresPerStep = Suppliers.memoize(() -> this.buildFeaturesPerStep(var0, true));
    }

    private List<b> buildFeaturesPerStep(List<Holder<BiomeBase>> var0, boolean var12) {
        Collection<Object> var13;
        int var122;
        Object var15;
        Object var10;
        Object var9;
        Object2IntOpenHashMap var2 = new Object2IntOpenHashMap();
        MutableInt var3 = new MutableInt(0);
        record A(int featureIndex, int step, PlacedFeature feature) {
        }
        Comparator<A> var4 = Comparator.comparingInt(A::step).thenComparingInt(A::featureIndex);
        TreeMap<A, Set> var5 = new TreeMap<A, Set>(var4);
        int var6 = 0;
        for (Holder<BiomeBase> holder : var0) {
            var9 = holder.value();
            var10 = Lists.newArrayList();
            Object var11 = ((BiomeBase)var9).getGenerationSettings().features();
            var6 = Math.max(var6, var11.size());
            for (int var1222 = 0; var1222 < var11.size(); ++var1222) {
                for (Object var14 : (HolderSet)var11.get(var1222)) {
                    var15 = (PlacedFeature)var14.value();
                    var10.add(new A(var2.computeIfAbsent(var15, var1 -> var3.getAndIncrement()), var1222, (PlacedFeature)var15));
                }
            }
            for (var122 = 0; var122 < var10.size(); ++var122) {
                var13 = var5.computeIfAbsent((A)var10.get(var122), var1 -> new TreeSet(var4));
                if (var122 >= var10.size() - 1) continue;
                var13.add((A)var10.get(var122 + 1));
            }
        }
        TreeSet<A> var7 = new TreeSet<A>(var4);
        TreeSet<A> treeSet = new TreeSet<A>(var4);
        var9 = Lists.newArrayList();
        for (Object var11 : var5.keySet()) {
            if (!treeSet.isEmpty()) {
                throw new IllegalStateException("You somehow broke the universe; DFS bork (iteration finished with non-empty in-progress vertex set");
            }
            if (var7.contains(var11) || !Graph.depthFirstSearch(var5, var7, treeSet, ((List)var9)::add, var11)) continue;
            if (var12) {
                int var132;
                ArrayList<Holder<BiomeBase>> var123 = new ArrayList<Holder<BiomeBase>>(var0);
                do {
                    Object var14;
                    var132 = var123.size();
                    var14 = var123.listIterator();
                    while (var14.hasNext()) {
                        var15 = (Holder)var14.next();
                        var14.remove();
                        try {
                            this.buildFeaturesPerStep(var123, false);
                        }
                        catch (IllegalStateException var16) {
                            continue;
                        }
                        var14.add(var15);
                    }
                } while (var132 != var123.size());
                throw new IllegalStateException("Feature order cycle found, involved biomes: " + var123);
            }
            throw new IllegalStateException("Feature order cycle found");
        }
        Collections.reverse(var9);
        var10 = ImmutableList.builder();
        for (int var11 = 0; var11 < var6; ++var11) {
            var122 = var11;
            var13 = var9.stream().filter(var1 -> var1.step() == var1222).map(A::feature).collect(Collectors.toList());
            int var14 = var13.size();
            var15 = new Object2IntOpenCustomHashMap(var14, SystemUtils.identityStrategy());
            for (int var16 = 0; var16 < var14; ++var16) {
                var15.put((Object)((PlacedFeature)var13.get(var16)), var16);
            }
            var10.add((Object)new b((List<PlacedFeature>)var13, (ToIntFunction<PlacedFeature>)var15));
        }
        return var10.build();
    }

    protected abstract Codec<? extends WorldChunkManager> codec();

    public abstract WorldChunkManager withSeed(long var1);

    public Set<Holder<BiomeBase>> possibleBiomes() {
        return this.possibleBiomes;
    }

    public Set<Holder<BiomeBase>> getBiomesWithin(int var0, int var1, int var2, int var3, Climate.Sampler var4) {
        int var5 = QuartPos.fromBlock(var0 - var3);
        int var6 = QuartPos.fromBlock(var1 - var3);
        int var7 = QuartPos.fromBlock(var2 - var3);
        int var8 = QuartPos.fromBlock(var0 + var3);
        int var9 = QuartPos.fromBlock(var1 + var3);
        int var10 = QuartPos.fromBlock(var2 + var3);
        int var11 = var8 - var5 + 1;
        int var12 = var9 - var6 + 1;
        int var13 = var10 - var7 + 1;
        HashSet var14 = Sets.newHashSet();
        for (int var15 = 0; var15 < var13; ++var15) {
            for (int var16 = 0; var16 < var11; ++var16) {
                for (int var17 = 0; var17 < var12; ++var17) {
                    int var18 = var5 + var16;
                    int var19 = var6 + var17;
                    int var20 = var7 + var15;
                    var14.add(this.getNoiseBiome(var18, var19, var20, var4));
                }
            }
        }
        return var14;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> findBiomeHorizontal(int var0, int var1, int var2, int var3, Predicate<Holder<BiomeBase>> var4, Random var5, Climate.Sampler var6) {
        return this.findBiomeHorizontal(var0, var1, var2, var3, 1, var4, var5, false, var6);
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> findBiomeHorizontal(int var0, int var1, int var2, int var3, int var4, Predicate<Holder<BiomeBase>> var5, Random var6, boolean var7, Climate.Sampler var8) {
        int var15;
        int var9 = QuartPos.fromBlock(var0);
        int var10 = QuartPos.fromBlock(var2);
        int var11 = QuartPos.fromBlock(var3);
        int var12 = QuartPos.fromBlock(var1);
        Pair var13 = null;
        int var14 = 0;
        for (int var16 = var15 = var7 ? 0 : var11; var16 <= var11; var16 += var4) {
            int var17;
            int n2 = var17 = SharedConstants.debugGenerateSquareTerrainWithoutNoise ? 0 : -var16;
            while (var17 <= var16) {
                boolean var18 = Math.abs(var17) == var16;
                for (int var19 = -var16; var19 <= var16; var19 += var4) {
                    int var21;
                    Holder<BiomeBase> var22;
                    int var20;
                    if (var7) {
                        int n3 = var20 = Math.abs(var19) == var16 ? 1 : 0;
                        if (var20 == 0 && !var18) continue;
                    }
                    if (!var5.test(var22 = this.getNoiseBiome(var20 = var9 + var19, var12, var21 = var10 + var17, var8))) continue;
                    if (var13 == null || var6.nextInt(var14 + 1) == 0) {
                        BlockPosition var23 = new BlockPosition(QuartPos.toBlock(var20), var1, QuartPos.toBlock(var21));
                        if (var7) {
                            return Pair.of((Object)var23, var22);
                        }
                        var13 = Pair.of((Object)var23, var22);
                    }
                    ++var14;
                }
                var17 += var4;
            }
        }
        return var13;
    }

    @Override
    public abstract Holder<BiomeBase> getNoiseBiome(int var1, int var2, int var3, Climate.Sampler var4);

    public void addDebugInfo(List<String> var0, BlockPosition var1, Climate.Sampler var2) {
    }

    public List<b> featuresPerStep() {
        return this.featuresPerStep.get();
    }

    static {
        IRegistry.register(IRegistry.BIOME_SOURCE, "fixed", WorldChunkManagerHell.CODEC);
        IRegistry.register(IRegistry.BIOME_SOURCE, "multi_noise", WorldChunkManagerMultiNoise.CODEC);
        IRegistry.register(IRegistry.BIOME_SOURCE, "checkerboard", WorldChunkManagerCheckerBoard.CODEC);
        IRegistry.register(IRegistry.BIOME_SOURCE, "the_end", WorldChunkManagerTheEnd.CODEC);
        CODEC = IRegistry.BIOME_SOURCE.byNameCodec().dispatchStable(WorldChunkManager::codec, Function.identity());
    }

    public record b(List<PlacedFeature> features, ToIntFunction<PlacedFeature> indexMapping) {
    }
}

