/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IStructureAccess;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureManager {
    private final GeneratorAccess level;
    private final GeneratorSettings worldGenSettings;
    private final StructureCheck structureCheck;

    public StructureManager(GeneratorAccess var0, GeneratorSettings var1, StructureCheck var2) {
        this.level = var0;
        this.worldGenSettings = var1;
        this.structureCheck = var2;
    }

    public StructureManager forWorldGenRegion(RegionLimitedWorldAccess var0) {
        if (var0.getLevel() != this.level) {
            throw new IllegalStateException("Using invalid feature manager (source level: " + var0.getLevel() + ", region: " + var0);
        }
        return new StructureManager(var0, this.worldGenSettings, this.structureCheck);
    }

    public List<StructureStart> startsForFeature(SectionPosition var0, Predicate<StructureFeature<?, ?>> var1) {
        Map<StructureFeature<?, ?>, LongSet> var2 = this.level.getChunk(var0.x(), var0.z(), ChunkStatus.STRUCTURE_REFERENCES).getAllReferences();
        ImmutableList.Builder var3 = ImmutableList.builder();
        for (Map.Entry<StructureFeature<?, ?>, LongSet> var5 : var2.entrySet()) {
            StructureFeature<?, ?> var6 = var5.getKey();
            if (!var1.test(var6)) continue;
            this.fillStartsForFeature(var6, var5.getValue(), arg_0 -> ((ImmutableList.Builder)var3).add(arg_0));
        }
        return var3.build();
    }

    public List<StructureStart> startsForFeature(SectionPosition var0, StructureFeature<?, ?> var1) {
        LongSet var2 = this.level.getChunk(var0.x(), var0.z(), ChunkStatus.STRUCTURE_REFERENCES).getReferencesForFeature(var1);
        ImmutableList.Builder var3 = ImmutableList.builder();
        this.fillStartsForFeature(var1, var2, arg_0 -> ((ImmutableList.Builder)var3).add(arg_0));
        return var3.build();
    }

    public void fillStartsForFeature(StructureFeature<?, ?> var0, LongSet var1, Consumer<StructureStart> var2) {
        LongIterator longIterator = var1.iterator();
        while (longIterator.hasNext()) {
            long var4 = (Long)longIterator.next();
            SectionPosition var6 = SectionPosition.of(new ChunkCoordIntPair(var4), this.level.getMinSection());
            StructureStart var7 = this.getStartForFeature(var6, var0, this.level.getChunk(var6.x(), var6.z(), ChunkStatus.STRUCTURE_STARTS));
            if (var7 == null || !var7.isValid()) continue;
            var2.accept(var7);
        }
    }

    @Nullable
    public StructureStart getStartForFeature(SectionPosition var0, StructureFeature<?, ?> var1, IStructureAccess var2) {
        return var2.getStartForFeature(var1);
    }

    public void setStartForFeature(SectionPosition var0, StructureFeature<?, ?> var1, StructureStart var2, IStructureAccess var3) {
        var3.setStartForFeature(var1, var2);
    }

    public void addReferenceForFeature(SectionPosition var0, StructureFeature<?, ?> var1, long var2, IStructureAccess var4) {
        var4.addReferenceForFeature(var1, var2);
    }

    public boolean shouldGenerateFeatures() {
        return this.worldGenSettings.generateFeatures();
    }

    public StructureStart getStructureAt(BlockPosition var0, StructureFeature<?, ?> var1) {
        for (StructureStart var3 : this.startsForFeature(SectionPosition.of(var0), var1)) {
            if (!var3.getBoundingBox().isInside(var0)) continue;
            return var3;
        }
        return StructureStart.INVALID_START;
    }

    public StructureStart getStructureWithPieceAt(BlockPosition var0, ResourceKey<StructureFeature<?, ?>> var1) {
        StructureFeature<?, ?> var2 = this.registryAccess().registryOrThrow(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY).get(var1);
        if (var2 == null) {
            return StructureStart.INVALID_START;
        }
        return this.getStructureWithPieceAt(var0, var2);
    }

    public StructureStart getStructureWithPieceAt(BlockPosition var0, StructureFeature<?, ?> var1) {
        for (StructureStart var3 : this.startsForFeature(SectionPosition.of(var0), var1)) {
            if (!this.structureHasPieceAt(var0, var3)) continue;
            return var3;
        }
        return StructureStart.INVALID_START;
    }

    public boolean structureHasPieceAt(BlockPosition var0, StructureStart var1) {
        for (StructurePiece var3 : var1.getPieces()) {
            if (!var3.getBoundingBox().isInside(var0)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyStructureAt(BlockPosition var0) {
        SectionPosition var1 = SectionPosition.of(var0);
        return this.level.getChunk(var1.x(), var1.z(), ChunkStatus.STRUCTURE_REFERENCES).hasAnyStructureReferences();
    }

    public Map<StructureFeature<?, ?>, LongSet> getAllStructuresAt(BlockPosition var0) {
        SectionPosition var1 = SectionPosition.of(var0);
        return this.level.getChunk(var1.x(), var1.z(), ChunkStatus.STRUCTURE_REFERENCES).getAllReferences();
    }

    public StructureCheckResult checkStructurePresence(ChunkCoordIntPair var0, StructureFeature<?, ?> var1, boolean var2) {
        return this.structureCheck.checkStart(var0, var1, var2);
    }

    public void addReference(StructureStart var0) {
        var0.addReference();
        this.structureCheck.incrementReference(var0.getChunkPos(), var0.getFeature());
    }

    public IRegistryCustom registryAccess() {
        return this.level.registryAccess();
    }
}

