/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public abstract class MobSpawnerAbstract {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EVENT_SPAWN = 1;
    public int spawnDelay = 20;
    public SimpleWeightedRandomList<MobSpawnerData> spawnPotentials = SimpleWeightedRandomList.empty();
    public MobSpawnerData nextSpawnData = new MobSpawnerData();
    private double spin;
    private double oSpin;
    public int minSpawnDelay = 200;
    public int maxSpawnDelay = 800;
    public int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    public int maxNearbyEntities = 6;
    public int requiredPlayerRange = 16;
    public int spawnRange = 4;
    private final Random random = new Random();

    public void setEntityId(EntityTypes<?> var0) {
        this.nextSpawnData.getEntityToSpawn().putString("id", IRegistry.ENTITY_TYPE.getKey(var0).toString());
    }

    private boolean isNearPlayer(World var0, BlockPosition var1) {
        return var0.hasNearbyAlivePlayer((double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, this.requiredPlayerRange);
    }

    public void clientTick(World var0, BlockPosition var1) {
        if (!this.isNearPlayer(var0, var1)) {
            this.oSpin = this.spin;
        } else {
            double var2 = (double)var1.getX() + var0.random.nextDouble();
            double var4 = (double)var1.getY() + var0.random.nextDouble();
            double var6 = (double)var1.getZ() + var0.random.nextDouble();
            var0.addParticle(Particles.SMOKE, var2, var4, var6, 0.0, 0.0, 0.0);
            var0.addParticle(Particles.FLAME, var2, var4, var6, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(WorldServer var0, BlockPosition var1) {
        if (!this.isNearPlayer(var0, var1)) {
            return;
        }
        if (this.spawnDelay == -1) {
            this.delay(var0, var1);
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        boolean var2 = false;
        for (int var3 = 0; var3 < this.spawnCount; ++var3) {
            Object var15;
            double var12;
            NBTTagCompound var4 = this.nextSpawnData.getEntityToSpawn();
            Optional<EntityTypes<?>> var5 = EntityTypes.by(var4);
            if (var5.isEmpty()) {
                this.delay(var0, var1);
                return;
            }
            NBTTagList var62 = var4.getList("Pos", 6);
            int var7 = var62.size();
            double var8 = var7 >= 1 ? var62.getDouble(0) : (double)var1.getX() + (var0.random.nextDouble() - var0.random.nextDouble()) * (double)this.spawnRange + 0.5;
            double var10 = var7 >= 2 ? var62.getDouble(1) : (double)(var1.getY() + var0.random.nextInt(3) - 1);
            double d2 = var12 = var7 >= 3 ? var62.getDouble(2) : (double)var1.getZ() + (var0.random.nextDouble() - var0.random.nextDouble()) * (double)this.spawnRange + 0.5;
            if (!var0.noCollision(var5.get().getAABB(var8, var10, var12))) continue;
            BlockPosition var14 = new BlockPosition(var8, var10, var12);
            if (!this.nextSpawnData.getCustomSpawnRules().isPresent() ? !EntityPositionTypes.checkSpawnRules(var5.get(), var0, EnumMobSpawn.SPAWNER, var14, var0.getRandom()) : !var5.get().getCategory().isFriendly() && var0.getDifficulty() == EnumDifficulty.PEACEFUL || !((MobSpawnerData.a)(var15 = this.nextSpawnData.getCustomSpawnRules().get())).blockLightLimit().isValueInRange(var0.getBrightness(EnumSkyBlock.BLOCK, var14)) || !((MobSpawnerData.a)var15).skyLightLimit().isValueInRange(var0.getBrightness(EnumSkyBlock.SKY, var14))) continue;
            var15 = EntityTypes.loadEntityRecursive(var4, var0, var6 -> {
                var6.moveTo(var8, var10, var12, var6.getYRot(), var6.getXRot());
                return var6;
            });
            if (var15 == null) {
                this.delay(var0, var1);
                return;
            }
            int var16 = var0.getEntitiesOfClass(var15.getClass(), new AxisAlignedBB(var1.getX(), var1.getY(), var1.getZ(), var1.getX() + 1, var1.getY() + 1, var1.getZ() + 1).inflate(this.spawnRange)).size();
            if (var16 >= this.maxNearbyEntities) {
                this.delay(var0, var1);
                return;
            }
            ((Entity)var15).moveTo(((Entity)var15).getX(), ((Entity)var15).getY(), ((Entity)var15).getZ(), var0.random.nextFloat() * 360.0f, 0.0f);
            if (var15 instanceof EntityInsentient) {
                EntityInsentient var17 = (EntityInsentient)var15;
                if (this.nextSpawnData.getCustomSpawnRules().isEmpty() && !var17.checkSpawnRules(var0, EnumMobSpawn.SPAWNER) || !var17.checkSpawnObstruction(var0)) continue;
                if (this.nextSpawnData.getEntityToSpawn().size() == 1 && this.nextSpawnData.getEntityToSpawn().contains("id", 8)) {
                    ((EntityInsentient)var15).finalizeSpawn(var0, var0.getCurrentDifficultyAt(((Entity)var15).blockPosition()), EnumMobSpawn.SPAWNER, null, null);
                }
            }
            if (!var0.tryAddFreshEntityWithPassengers((Entity)var15)) {
                this.delay(var0, var1);
                return;
            }
            var0.levelEvent(2004, var1, 0);
            if (var15 instanceof EntityInsentient) {
                ((EntityInsentient)var15).spawnAnim();
            }
            var2 = true;
        }
        if (var2) {
            this.delay(var0, var1);
        }
    }

    private void delay(World var0, BlockPosition var1) {
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + this.random.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom(this.random).ifPresent(var2 -> this.setNextSpawnData(var0, var1, (MobSpawnerData)var2.getData()));
        this.broadcastEvent(var0, var1, 1);
    }

    public void load(@Nullable World var02, BlockPosition var1, NBTTagCompound var22) {
        this.spawnDelay = var22.getShort("Delay");
        boolean var3 = var22.contains("SpawnPotentials", 9);
        boolean var4 = var22.contains("SpawnData", 10);
        if (!var3) {
            MobSpawnerData var5 = var4 ? MobSpawnerData.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var22.getCompound("SpawnData")).resultOrPartial(var0 -> LOGGER.warn("Invalid SpawnData: {}", var0)).orElseGet(MobSpawnerData::new) : new MobSpawnerData();
            this.spawnPotentials = SimpleWeightedRandomList.single(var5);
            this.setNextSpawnData(var02, var1, var5);
        } else {
            NBTTagList var5 = var22.getList("SpawnPotentials", 10);
            this.spawnPotentials = MobSpawnerData.LIST_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var5).resultOrPartial(var0 -> LOGGER.warn("Invalid SpawnPotentials list: {}", var0)).orElseGet(SimpleWeightedRandomList::empty);
            if (var4) {
                MobSpawnerData var6 = MobSpawnerData.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var22.getCompound("SpawnData")).resultOrPartial(var0 -> LOGGER.warn("Invalid SpawnData: {}", var0)).orElseGet(MobSpawnerData::new);
                this.setNextSpawnData(var02, var1, var6);
            } else {
                this.spawnPotentials.getRandom(this.random).ifPresent(var2 -> this.setNextSpawnData(var02, var1, (MobSpawnerData)var2.getData()));
            }
        }
        if (var22.contains("MinSpawnDelay", 99)) {
            this.minSpawnDelay = var22.getShort("MinSpawnDelay");
            this.maxSpawnDelay = var22.getShort("MaxSpawnDelay");
            this.spawnCount = var22.getShort("SpawnCount");
        }
        if (var22.contains("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = var22.getShort("MaxNearbyEntities");
            this.requiredPlayerRange = var22.getShort("RequiredPlayerRange");
        }
        if (var22.contains("SpawnRange", 99)) {
            this.spawnRange = var22.getShort("SpawnRange");
        }
        this.displayEntity = null;
    }

    public NBTTagCompound save(NBTTagCompound var0) {
        var0.putShort("Delay", (short)this.spawnDelay);
        var0.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        var0.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        var0.putShort("SpawnCount", (short)this.spawnCount);
        var0.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        var0.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        var0.putShort("SpawnRange", (short)this.spawnRange);
        var0.put("SpawnData", (NBTBase)MobSpawnerData.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.nextSpawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        var0.put("SpawnPotentials", (NBTBase)MobSpawnerData.LIST_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, this.spawnPotentials).result().orElseThrow());
        return var0;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(World var0) {
        if (this.displayEntity == null) {
            this.displayEntity = EntityTypes.loadEntityRecursive(this.nextSpawnData.getEntityToSpawn(), var0, Function.identity());
            if (this.nextSpawnData.getEntityToSpawn().size() != 1 || !this.nextSpawnData.getEntityToSpawn().contains("id", 8) || this.displayEntity instanceof EntityInsentient) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(World var0, int var1) {
        if (var1 == 1) {
            if (var0.isClientSide) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    public void setNextSpawnData(@Nullable World var0, BlockPosition var1, MobSpawnerData var2) {
        this.nextSpawnData = var2;
    }

    public abstract void broadcastEvent(World var1, BlockPosition var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }
}

