/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantRecipe;

public class MerchantRecipeList
extends ArrayList<MerchantRecipe> {
    public MerchantRecipeList() {
    }

    public MerchantRecipeList(NBTTagCompound var0) {
        NBTTagList var1 = var0.getList("Recipes", 10);
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            this.add(new MerchantRecipe(var1.getCompound(var2)));
        }
    }

    @Nullable
    public MerchantRecipe getRecipeFor(ItemStack var0, ItemStack var1, int var2) {
        if (var2 > 0 && var2 < this.size()) {
            MerchantRecipe var3 = (MerchantRecipe)this.get(var2);
            if (var3.satisfiedBy(var0, var1)) {
                return var3;
            }
            return null;
        }
        for (int var3 = 0; var3 < this.size(); ++var3) {
            MerchantRecipe var4 = (MerchantRecipe)this.get(var3);
            if (!var4.satisfiedBy(var0, var1)) continue;
            return var4;
        }
        return null;
    }

    public void writeToStream(PacketDataSerializer var0) {
        var0.writeByte((byte)(this.size() & 0xFF));
        for (int var1 = 0; var1 < this.size(); ++var1) {
            MerchantRecipe var2 = (MerchantRecipe)this.get(var1);
            var0.writeItem(var2.getBaseCostA());
            var0.writeItem(var2.getResult());
            ItemStack var3 = var2.getCostB();
            var0.writeBoolean(!var3.isEmpty());
            if (!var3.isEmpty()) {
                var0.writeItem(var3);
            }
            var0.writeBoolean(var2.isOutOfStock());
            var0.writeInt(var2.getUses());
            var0.writeInt(var2.getMaxUses());
            var0.writeInt(var2.getXp());
            var0.writeInt(var2.getSpecialPriceDiff());
            var0.writeFloat(var2.getPriceMultiplier());
            var0.writeInt(var2.getDemand());
        }
    }

    public static MerchantRecipeList createFromStream(PacketDataSerializer var0) {
        MerchantRecipeList var1 = new MerchantRecipeList();
        int var2 = var0.readByte() & 0xFF;
        for (int var3 = 0; var3 < var2; ++var3) {
            ItemStack var4 = var0.readItem();
            ItemStack var5 = var0.readItem();
            ItemStack var6 = ItemStack.EMPTY;
            if (var0.readBoolean()) {
                var6 = var0.readItem();
            }
            boolean var7 = var0.readBoolean();
            int var8 = var0.readInt();
            int var9 = var0.readInt();
            int var10 = var0.readInt();
            int var11 = var0.readInt();
            float var12 = var0.readFloat();
            int var13 = var0.readInt();
            MerchantRecipe var14 = new MerchantRecipe(var4, var6, var5, var8, var9, var10, var12, var13);
            if (var7) {
                var14.setToOutOfStock();
            }
            var14.setSpecialPriceDiff(var11);
            var1.add(var14);
        }
        return var1;
    }

    public NBTTagCompound createTag() {
        NBTTagCompound var0 = new NBTTagCompound();
        NBTTagList var1 = new NBTTagList();
        for (int var2 = 0; var2 < this.size(); ++var2) {
            MerchantRecipe var3 = (MerchantRecipe)this.get(var2);
            var1.add(var3.createTag());
        }
        var0.put("Recipes", var1);
        return var0;
    }
}

