/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeMapClone
extends IRecipeComplex {
    public RecipeMapClone(MinecraftKey var0) {
        super(var0);
    }

    @Override
    public boolean matches(InventoryCrafting var0, World var1) {
        int var2 = 0;
        ItemStack var3 = ItemStack.EMPTY;
        for (int var4 = 0; var4 < var0.getContainerSize(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.is(Items.FILLED_MAP)) {
                if (!var3.isEmpty()) {
                    return false;
                }
                var3 = var5;
                continue;
            }
            if (var5.is(Items.MAP)) {
                ++var2;
                continue;
            }
            return false;
        }
        return !var3.isEmpty() && var2 > 0;
    }

    @Override
    public ItemStack assemble(InventoryCrafting var0) {
        int var1 = 0;
        ItemStack var2 = ItemStack.EMPTY;
        for (int var3 = 0; var3 < var0.getContainerSize(); ++var3) {
            ItemStack var4 = var0.getItem(var3);
            if (var4.isEmpty()) continue;
            if (var4.is(Items.FILLED_MAP)) {
                if (!var2.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                var2 = var4;
                continue;
            }
            if (var4.is(Items.MAP)) {
                ++var1;
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (var2.isEmpty() || var1 < 1) {
            return ItemStack.EMPTY;
        }
        ItemStack var3 = var2.copy();
        var3.setCount(var1 + 1);
        return var3;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return var0 >= 3 && var1 >= 3;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.MAP_CLONING;
    }
}

