/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class SolidBucketItem
extends ItemBlock
implements DispensibleContainerItem {
    private final SoundEffect placeSound;

    public SolidBucketItem(Block var0, SoundEffect var1, Item.Info var2) {
        super(var0, var2);
        this.placeSound = var1;
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        EnumInteractionResult var1 = super.useOn(var0);
        EntityHuman var2 = var0.getPlayer();
        if (var1.consumesAction() && var2 != null && !var2.isCreative()) {
            EnumHand var3 = var0.getHand();
            var2.setItemInHand(var3, Items.BUCKET.getDefaultInstance());
        }
        return var1;
    }

    @Override
    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    @Override
    protected SoundEffect getPlaceSound(IBlockData var0) {
        return this.placeSound;
    }

    @Override
    public boolean emptyContents(@Nullable EntityHuman var0, World var1, BlockPosition var2, @Nullable MovingObjectPositionBlock var3) {
        if (var1.isInWorldBounds(var2) && var1.isEmptyBlock(var2)) {
            if (!var1.isClientSide) {
                var1.setBlock(var2, this.getBlock().defaultBlockState(), 3);
            }
            var1.playSound(var0, var2, this.placeSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

