/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.ConfiguredStructureTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockEnderPortalFrame;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class ItemEnderEye
extends Item {
    public ItemEnderEye(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var2;
        World var1 = var0.getLevel();
        IBlockData var3 = var1.getBlockState(var2 = var0.getClickedPos());
        if (!var3.is(Blocks.END_PORTAL_FRAME) || var3.getValue(BlockEnderPortalFrame.HAS_EYE).booleanValue()) {
            return EnumInteractionResult.PASS;
        }
        if (var1.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        IBlockData var4 = (IBlockData)var3.setValue(BlockEnderPortalFrame.HAS_EYE, true);
        Block.pushEntitiesUp(var3, var4, var1, var2);
        var1.setBlock(var2, var4, 2);
        var1.updateNeighbourForOutputSignal(var2, Blocks.END_PORTAL_FRAME);
        var0.getItemInHand().shrink(1);
        var1.levelEvent(1503, var2, 0);
        ShapeDetector.ShapeDetectorCollection var5 = BlockEnderPortalFrame.getOrCreatePortalShape().find(var1, var2);
        if (var5 != null) {
            BlockPosition var6 = var5.getFrontTopLeft().offset(-3, 0, -3);
            for (int var7 = 0; var7 < 3; ++var7) {
                for (int var8 = 0; var8 < 3; ++var8) {
                    var1.setBlock(var6.offset(var7, 0, var8), Blocks.END_PORTAL.defaultBlockState(), 2);
                }
            }
            var1.globalLevelEvent(1038, var6.offset(1, 0, 1), 0);
        }
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        WorldServer var5;
        BlockPosition var6;
        ItemStack var3 = var1.getItemInHand(var2);
        MovingObjectPositionBlock var4 = ItemEnderEye.getPlayerPOVHitResult(var0, var1, RayTrace.FluidCollisionOption.NONE);
        if (((MovingObjectPosition)var4).getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK && var0.getBlockState(var4.getBlockPos()).is(Blocks.END_PORTAL_FRAME)) {
            return InteractionResultWrapper.pass(var3);
        }
        var1.startUsingItem(var2);
        if (var0 instanceof WorldServer && (var6 = (var5 = (WorldServer)var0).findNearestMapFeature(ConfiguredStructureTags.EYE_OF_ENDER_LOCATED, var1.blockPosition(), 100, false)) != null) {
            EntityEnderSignal var7 = new EntityEnderSignal(var0, var1.getX(), var1.getY(0.5), var1.getZ());
            var7.setItem(var3);
            var7.signalTo(var6);
            var0.addFreshEntity(var7);
            if (var1 instanceof EntityPlayer) {
                CriterionTriggers.USED_ENDER_EYE.trigger((EntityPlayer)var1, var6);
            }
            var0.playSound(null, var1.getX(), var1.getY(), var1.getZ(), SoundEffects.ENDER_EYE_LAUNCH, SoundCategory.NEUTRAL, 0.5f, 0.4f / (var0.getRandom().nextFloat() * 0.4f + 0.8f));
            var0.levelEvent(null, 1003, var1.blockPosition(), 0);
            if (!var1.getAbilities().instabuild) {
                var3.shrink(1);
            }
            var1.awardStat(StatisticList.ITEM_USED.get(this));
            var1.swing(var2, true);
            return InteractionResultWrapper.success(var3);
        }
        return InteractionResultWrapper.consume(var3);
    }
}

