/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.IBlockData;

public class ItemAxe
extends ItemTool {
    protected static final Map<Block, Block> STRIPPABLES = new ImmutableMap.Builder().put((Object)Blocks.OAK_WOOD, (Object)Blocks.STRIPPED_OAK_WOOD).put((Object)Blocks.OAK_LOG, (Object)Blocks.STRIPPED_OAK_LOG).put((Object)Blocks.DARK_OAK_WOOD, (Object)Blocks.STRIPPED_DARK_OAK_WOOD).put((Object)Blocks.DARK_OAK_LOG, (Object)Blocks.STRIPPED_DARK_OAK_LOG).put((Object)Blocks.ACACIA_WOOD, (Object)Blocks.STRIPPED_ACACIA_WOOD).put((Object)Blocks.ACACIA_LOG, (Object)Blocks.STRIPPED_ACACIA_LOG).put((Object)Blocks.BIRCH_WOOD, (Object)Blocks.STRIPPED_BIRCH_WOOD).put((Object)Blocks.BIRCH_LOG, (Object)Blocks.STRIPPED_BIRCH_LOG).put((Object)Blocks.JUNGLE_WOOD, (Object)Blocks.STRIPPED_JUNGLE_WOOD).put((Object)Blocks.JUNGLE_LOG, (Object)Blocks.STRIPPED_JUNGLE_LOG).put((Object)Blocks.SPRUCE_WOOD, (Object)Blocks.STRIPPED_SPRUCE_WOOD).put((Object)Blocks.SPRUCE_LOG, (Object)Blocks.STRIPPED_SPRUCE_LOG).put((Object)Blocks.WARPED_STEM, (Object)Blocks.STRIPPED_WARPED_STEM).put((Object)Blocks.WARPED_HYPHAE, (Object)Blocks.STRIPPED_WARPED_HYPHAE).put((Object)Blocks.CRIMSON_STEM, (Object)Blocks.STRIPPED_CRIMSON_STEM).put((Object)Blocks.CRIMSON_HYPHAE, (Object)Blocks.STRIPPED_CRIMSON_HYPHAE).build();

    protected ItemAxe(ToolMaterial var0, float var1, float var2, Item.Info var3) {
        super(var1, var2, var0, TagsBlock.MINEABLE_WITH_AXE, var3);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var12 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        EntityHuman var3 = var0.getPlayer();
        IBlockData var4 = var12.getBlockState(var2);
        Optional<IBlockData> var5 = this.getStripped(var4);
        Optional<IBlockData> var6 = WeatheringCopper.getPrevious(var4);
        Optional<IBlockData> var7 = Optional.ofNullable((Block)HoneycombItem.WAX_OFF_BY_BLOCK.get().get((Object)var4.getBlock())).map(var1 -> var1.withPropertiesOf(var4));
        ItemStack var8 = var0.getItemInHand();
        Optional<Object> var9 = Optional.empty();
        if (var5.isPresent()) {
            var12.playSound(var3, var2, SoundEffects.AXE_STRIP, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var9 = var5;
        } else if (var6.isPresent()) {
            var12.playSound(var3, var2, SoundEffects.AXE_SCRAPE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var12.levelEvent(var3, 3005, var2, 0);
            var9 = var6;
        } else if (var7.isPresent()) {
            var12.playSound(var3, var2, SoundEffects.AXE_WAX_OFF, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var12.levelEvent(var3, 3004, var2, 0);
            var9 = var7;
        }
        if (var9.isPresent()) {
            if (var3 instanceof EntityPlayer) {
                CriterionTriggers.ITEM_USED_ON_BLOCK.trigger((EntityPlayer)var3, var2, var8);
            }
            var12.setBlock(var2, (IBlockData)var9.get(), 11);
            if (var3 != null) {
                var8.hurtAndBreak(1, var3, var1 -> var1.broadcastBreakEvent(var0.getHand()));
            }
            return EnumInteractionResult.sidedSuccess(var12.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    private Optional<IBlockData> getStripped(IBlockData var0) {
        return Optional.ofNullable(STRIPPABLES.get(var0.getBlock())).map(var1 -> (IBlockData)var1.defaultBlockState().setValue(BlockRotatable.AXIS, var0.getValue(BlockRotatable.AXIS)));
    }
}

