/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class Item
implements IMaterial {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<Block, Item> BY_BLOCK = Maps.newHashMap();
    protected static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID BASE_ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    public static final int MAX_STACK_SIZE = 64;
    public static final int EAT_DURATION = 32;
    public static final int MAX_BAR_WIDTH = 13;
    private final Holder.c<Item> builtInRegistryHolder = IRegistry.ITEM.createIntrusiveHolder(this);
    @Nullable
    protected final CreativeModeTab category;
    private final EnumItemRarity rarity;
    private final int maxStackSize;
    private final int maxDamage;
    private final boolean isFireResistant;
    @Nullable
    private final Item craftingRemainingItem;
    @Nullable
    private String descriptionId;
    @Nullable
    private final FoodInfo foodProperties;

    public static int getId(Item var0) {
        return var0 == null ? 0 : IRegistry.ITEM.getId(var0);
    }

    public static Item byId(int var0) {
        return IRegistry.ITEM.byId(var0);
    }

    @Deprecated
    public static Item byBlock(Block var0) {
        return BY_BLOCK.getOrDefault(var0, Items.AIR);
    }

    public Item(Info var0) {
        String var1;
        this.category = var0.category;
        this.rarity = var0.rarity;
        this.craftingRemainingItem = var0.craftingRemainingItem;
        this.maxDamage = var0.maxDamage;
        this.maxStackSize = var0.maxStackSize;
        this.foodProperties = var0.foodProperties;
        this.isFireResistant = var0.isFireResistant;
        if (SharedConstants.IS_RUNNING_IN_IDE && !(var1 = this.getClass().getSimpleName()).endsWith("Item")) {
            LOGGER.error("Item classes should end with Item and {} doesn't.", (Object)var1);
        }
    }

    @Deprecated
    public Holder.c<Item> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    public void onUseTick(World var0, EntityLiving var1, ItemStack var2, int var3) {
    }

    public void onDestroyed(EntityItem var0) {
    }

    public void verifyTagAfterLoad(NBTTagCompound var0) {
    }

    public boolean canAttackBlock(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        return true;
    }

    @Override
    public Item asItem() {
        return this;
    }

    public EnumInteractionResult useOn(ItemActionContext var0) {
        return EnumInteractionResult.PASS;
    }

    public float getDestroySpeed(ItemStack var0, IBlockData var1) {
        return 1.0f;
    }

    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        if (this.isEdible()) {
            ItemStack var3 = var1.getItemInHand(var2);
            if (var1.canEat(this.getFoodProperties().canAlwaysEat())) {
                var1.startUsingItem(var2);
                return InteractionResultWrapper.consume(var3);
            }
            return InteractionResultWrapper.fail(var3);
        }
        return InteractionResultWrapper.pass(var1.getItemInHand(var2));
    }

    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        if (this.isEdible()) {
            return var2.eat(var1, var0);
        }
        return var0;
    }

    public final int getMaxStackSize() {
        return this.maxStackSize;
    }

    public final int getMaxDamage() {
        return this.maxDamage;
    }

    public boolean canBeDepleted() {
        return this.maxDamage > 0;
    }

    public boolean isBarVisible(ItemStack var0) {
        return var0.isDamaged();
    }

    public int getBarWidth(ItemStack var0) {
        return Math.round(13.0f - (float)var0.getDamageValue() * 13.0f / (float)this.maxDamage);
    }

    public int getBarColor(ItemStack var0) {
        float var1 = Math.max(0.0f, ((float)this.maxDamage - (float)var0.getDamageValue()) / (float)this.maxDamage);
        return MathHelper.hsvToRgb(var1 / 3.0f, 1.0f, 1.0f);
    }

    public boolean overrideStackedOnOther(ItemStack var0, Slot var1, ClickAction var2, EntityHuman var3) {
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack var0, ItemStack var1, Slot var2, ClickAction var3, EntityHuman var4, SlotAccess var5) {
        return false;
    }

    public boolean hurtEnemy(ItemStack var0, EntityLiving var1, EntityLiving var2) {
        return false;
    }

    public boolean mineBlock(ItemStack var0, World var1, IBlockData var2, BlockPosition var3, EntityLiving var4) {
        return false;
    }

    public boolean isCorrectToolForDrops(IBlockData var0) {
        return false;
    }

    public EnumInteractionResult interactLivingEntity(ItemStack var0, EntityHuman var1, EntityLiving var2, EnumHand var3) {
        return EnumInteractionResult.PASS;
    }

    public IChatBaseComponent getDescription() {
        return new ChatMessage(this.getDescriptionId());
    }

    public String toString() {
        return IRegistry.ITEM.getKey(this).getPath();
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = SystemUtils.makeDescriptionId("item", IRegistry.ITEM.getKey(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public String getDescriptionId(ItemStack var0) {
        return this.getDescriptionId();
    }

    public boolean shouldOverrideMultiplayerNbt() {
        return true;
    }

    @Nullable
    public final Item getCraftingRemainingItem() {
        return this.craftingRemainingItem;
    }

    public boolean hasCraftingRemainingItem() {
        return this.craftingRemainingItem != null;
    }

    public void inventoryTick(ItemStack var0, World var1, Entity var2, int var3, boolean var4) {
    }

    public void onCraftedBy(ItemStack var0, World var1, EntityHuman var2) {
    }

    public boolean isComplex() {
        return false;
    }

    public EnumAnimation getUseAnimation(ItemStack var0) {
        return var0.getItem().isEdible() ? EnumAnimation.EAT : EnumAnimation.NONE;
    }

    public int getUseDuration(ItemStack var0) {
        if (var0.getItem().isEdible()) {
            return this.getFoodProperties().isFastFood() ? 16 : 32;
        }
        return 0;
    }

    public void releaseUsing(ItemStack var0, World var1, EntityLiving var2, int var3) {
    }

    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack var0) {
        return Optional.empty();
    }

    public IChatBaseComponent getName(ItemStack var0) {
        return new ChatMessage(this.getDescriptionId(var0));
    }

    public boolean isFoil(ItemStack var0) {
        return var0.isEnchanted();
    }

    public EnumItemRarity getRarity(ItemStack var0) {
        if (!var0.isEnchanted()) {
            return this.rarity;
        }
        switch (this.rarity) {
            case COMMON: 
            case UNCOMMON: {
                return EnumItemRarity.RARE;
            }
            case RARE: {
                return EnumItemRarity.EPIC;
            }
        }
        return this.rarity;
    }

    public boolean isEnchantable(ItemStack var0) {
        return this.getMaxStackSize() == 1 && this.canBeDepleted();
    }

    protected static MovingObjectPositionBlock getPlayerPOVHitResult(World var0, EntityHuman var1, RayTrace.FluidCollisionOption var2) {
        float var3 = var1.getXRot();
        float var4 = var1.getYRot();
        Vec3D var5 = var1.getEyePosition();
        float var6 = MathHelper.cos(-var4 * ((float)Math.PI / 180) - (float)Math.PI);
        float var7 = MathHelper.sin(-var4 * ((float)Math.PI / 180) - (float)Math.PI);
        float var8 = -MathHelper.cos(-var3 * ((float)Math.PI / 180));
        float var9 = MathHelper.sin(-var3 * ((float)Math.PI / 180));
        float var10 = var7 * var8;
        float var11 = var9;
        float var12 = var6 * var8;
        double var13 = 5.0;
        Vec3D var15 = var5.add((double)var10 * 5.0, (double)var11 * 5.0, (double)var12 * 5.0);
        return var0.clip(new RayTrace(var5, var15, RayTrace.BlockCollisionOption.OUTLINE, var2, var1));
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public void fillItemCategory(CreativeModeTab var0, NonNullList<ItemStack> var1) {
        if (this.allowdedIn(var0)) {
            var1.add(new ItemStack(this));
        }
    }

    protected boolean allowdedIn(CreativeModeTab var0) {
        CreativeModeTab var1 = this.getItemCategory();
        return var1 != null && (var0 == CreativeModeTab.TAB_SEARCH || var0 == var1);
    }

    @Nullable
    public final CreativeModeTab getItemCategory() {
        return this.category;
    }

    public boolean isValidRepairItem(ItemStack var0, ItemStack var1) {
        return false;
    }

    public Multimap<AttributeBase, AttributeModifier> getDefaultAttributeModifiers(EnumItemSlot var0) {
        return ImmutableMultimap.of();
    }

    public boolean useOnRelease(ItemStack var0) {
        return false;
    }

    public ItemStack getDefaultInstance() {
        return new ItemStack(this);
    }

    public boolean isEdible() {
        return this.foodProperties != null;
    }

    @Nullable
    public FoodInfo getFoodProperties() {
        return this.foodProperties;
    }

    public SoundEffect getDrinkingSound() {
        return SoundEffects.GENERIC_DRINK;
    }

    public SoundEffect getEatingSound() {
        return SoundEffects.GENERIC_EAT;
    }

    public boolean isFireResistant() {
        return this.isFireResistant;
    }

    public boolean canBeHurtBy(DamageSource var0) {
        return !this.isFireResistant || !var0.isFire();
    }

    @Nullable
    public SoundEffect getEquipSound() {
        return null;
    }

    public boolean canFitInsideContainerItems() {
        return true;
    }

    public static class Info {
        int maxStackSize = 64;
        int maxDamage;
        @Nullable
        Item craftingRemainingItem;
        @Nullable
        CreativeModeTab category;
        EnumItemRarity rarity = EnumItemRarity.COMMON;
        @Nullable
        FoodInfo foodProperties;
        boolean isFireResistant;

        public Info food(FoodInfo var0) {
            this.foodProperties = var0;
            return this;
        }

        public Info stacksTo(int var0) {
            if (this.maxDamage > 0) {
                throw new RuntimeException("Unable to have damage AND stack.");
            }
            this.maxStackSize = var0;
            return this;
        }

        public Info defaultDurability(int var0) {
            return this.maxDamage == 0 ? this.durability(var0) : this;
        }

        public Info durability(int var0) {
            this.maxDamage = var0;
            this.maxStackSize = 1;
            return this;
        }

        public Info craftRemainder(Item var0) {
            this.craftingRemainingItem = var0;
            return this;
        }

        public Info tab(CreativeModeTab var0) {
            this.category = var0;
            return this;
        }

        public Info rarity(EnumItemRarity var0) {
            this.rarity = var0;
            return this;
        }

        public Info fireResistant() {
            this.isFireResistant = true;
            return this;
        }
    }
}

