/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemBanner;
import net.minecraft.world.item.ItemBannerPattern;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.TileEntityTypes;

public class ContainerLoom
extends Container {
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;
    private final ContainerAccess access;
    final ContainerProperty selectedBannerPatternIndex = ContainerProperty.standalone();
    Runnable slotUpdateListener = () -> {};
    final Slot bannerSlot;
    final Slot dyeSlot;
    private final Slot patternSlot;
    private final Slot resultSlot;
    long lastSoundTime;
    private final IInventory inputContainer = new InventorySubcontainer(3){

        @Override
        public void setChanged() {
            super.setChanged();
            ContainerLoom.this.slotsChanged(this);
            ContainerLoom.this.slotUpdateListener.run();
        }
    };
    private final IInventory outputContainer = new InventorySubcontainer(1){

        @Override
        public void setChanged() {
            super.setChanged();
            ContainerLoom.this.slotUpdateListener.run();
        }
    };

    public ContainerLoom(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerLoom(int var0, PlayerInventory var1, final ContainerAccess var2) {
        super(Containers.LOOM, var0);
        int var3;
        this.access = var2;
        this.bannerSlot = this.addSlot(new Slot(this.inputContainer, 0, 13, 26){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.getItem() instanceof ItemBanner;
            }
        });
        this.dyeSlot = this.addSlot(new Slot(this.inputContainer, 1, 33, 26){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.getItem() instanceof ItemDye;
            }
        });
        this.patternSlot = this.addSlot(new Slot(this.inputContainer, 2, 23, 45){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.getItem() instanceof ItemBannerPattern;
            }
        });
        this.resultSlot = this.addSlot(new Slot(this.outputContainer, 0, 143, 58){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return false;
            }

            @Override
            public void onTake(EntityHuman var02, ItemStack var12) {
                ContainerLoom.this.bannerSlot.remove(1);
                ContainerLoom.this.dyeSlot.remove(1);
                if (!ContainerLoom.this.bannerSlot.hasItem() || !ContainerLoom.this.dyeSlot.hasItem()) {
                    ContainerLoom.this.selectedBannerPatternIndex.set(0);
                }
                var2.execute((var0, var1) -> {
                    long var22 = var0.getGameTime();
                    if (ContainerLoom.this.lastSoundTime != var22) {
                        var0.playSound(null, (BlockPosition)var1, SoundEffects.UI_LOOM_TAKE_RESULT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        ContainerLoom.this.lastSoundTime = var22;
                    }
                });
                super.onTake(var02, var12);
            }
        });
        for (var3 = 0; var3 < 3; ++var3) {
            for (int var4 = 0; var4 < 9; ++var4) {
                this.addSlot(new Slot(var1, var4 + var3 * 9 + 9, 8 + var4 * 18, 84 + var3 * 18));
            }
        }
        for (var3 = 0; var3 < 9; ++var3) {
            this.addSlot(new Slot(var1, var3, 8 + var3 * 18, 142));
        }
        this.addDataSlot(this.selectedBannerPatternIndex);
    }

    public int getSelectedBannerPatternIndex() {
        return this.selectedBannerPatternIndex.get();
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return ContainerLoom.stillValid(this.access, var0, Blocks.LOOM);
    }

    @Override
    public boolean clickMenuButton(EntityHuman var0, int var1) {
        if (var1 > 0 && var1 <= EnumBannerPatternType.AVAILABLE_PATTERNS) {
            this.selectedBannerPatternIndex.set(var1);
            this.setupResultSlot();
            return true;
        }
        return false;
    }

    @Override
    public void slotsChanged(IInventory var0) {
        ItemStack var1 = this.bannerSlot.getItem();
        ItemStack var2 = this.dyeSlot.getItem();
        ItemStack var3 = this.patternSlot.getItem();
        ItemStack var4 = this.resultSlot.getItem();
        if (!var4.isEmpty() && (var1.isEmpty() || var2.isEmpty() || this.selectedBannerPatternIndex.get() <= 0 || this.selectedBannerPatternIndex.get() >= EnumBannerPatternType.COUNT - EnumBannerPatternType.PATTERN_ITEM_COUNT && var3.isEmpty())) {
            this.resultSlot.set(ItemStack.EMPTY);
            this.selectedBannerPatternIndex.set(0);
        } else if (!var3.isEmpty() && var3.getItem() instanceof ItemBannerPattern) {
            boolean var6;
            NBTTagCompound var5 = ItemBlock.getBlockEntityData(var1);
            boolean bl = var6 = var5 != null && var5.contains("Patterns", 9) && !var1.isEmpty() && var5.getList("Patterns", 10).size() >= 6;
            if (var6) {
                this.selectedBannerPatternIndex.set(0);
            } else {
                this.selectedBannerPatternIndex.set(((ItemBannerPattern)var3.getItem()).getBannerPattern().ordinal());
            }
        }
        this.setupResultSlot();
        this.broadcastChanges();
    }

    public void registerUpdateListener(Runnable var0) {
        this.slotUpdateListener = var0;
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 == this.resultSlot.index) {
                if (!this.moveItemStackTo(var4, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (var1 == this.dyeSlot.index || var1 == this.bannerSlot.index || var1 == this.patternSlot.index ? !this.moveItemStackTo(var4, 4, 40, false) : (var4.getItem() instanceof ItemBanner ? !this.moveItemStackTo(var4, this.bannerSlot.index, this.bannerSlot.index + 1, false) : (var4.getItem() instanceof ItemDye ? !this.moveItemStackTo(var4, this.dyeSlot.index, this.dyeSlot.index + 1, false) : (var4.getItem() instanceof ItemBannerPattern ? !this.moveItemStackTo(var4, this.patternSlot.index, this.patternSlot.index + 1, false) : (var1 >= 4 && var1 < 31 ? !this.moveItemStackTo(var4, 31, 40, false) : var1 >= 31 && var1 < 40 && !this.moveItemStackTo(var4, 4, 31, false)))))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.set(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.access.execute((var1, var2) -> this.clearContainer(var0, this.inputContainer));
    }

    private void setupResultSlot() {
        if (this.selectedBannerPatternIndex.get() > 0) {
            ItemStack var0 = this.bannerSlot.getItem();
            ItemStack var1 = this.dyeSlot.getItem();
            ItemStack var2 = ItemStack.EMPTY;
            if (!var0.isEmpty() && !var1.isEmpty()) {
                NBTTagList var6;
                var2 = var0.copy();
                var2.setCount(1);
                EnumBannerPatternType var3 = EnumBannerPatternType.values()[this.selectedBannerPatternIndex.get()];
                EnumColor var4 = ((ItemDye)var1.getItem()).getDyeColor();
                NBTTagCompound var5 = ItemBlock.getBlockEntityData(var2);
                if (var5 != null && var5.contains("Patterns", 9)) {
                    var6 = var5.getList("Patterns", 10);
                } else {
                    var6 = new NBTTagList();
                    if (var5 == null) {
                        var5 = new NBTTagCompound();
                    }
                    var5.put("Patterns", var6);
                }
                NBTTagCompound var7 = new NBTTagCompound();
                var7.putString("Pattern", var3.getHashname());
                var7.putInt("Color", var4.getId());
                var6.add(var7);
                ItemBlock.setBlockEntityData(var2, TileEntityTypes.BANNER, var5);
            }
            if (!ItemStack.matches(var2, this.resultSlot.getItem())) {
                this.resultSlot.set(var2);
            }
        }
    }

    public Slot getBannerSlot() {
        return this.bannerSlot;
    }

    public Slot getDyeSlot() {
        return this.dyeSlot;
    }

    public Slot getPatternSlot() {
        return this.patternSlot;
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }
}

