/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.IBlockData;

public class PlayerInventory
implements IInventory,
INamableTileEntity {
    public static final int POP_TIME_DURATION = 5;
    public static final int INVENTORY_SIZE = 36;
    private static final int SELECTION_SIZE = 9;
    public static final int SLOT_OFFHAND = 40;
    public static final int NOT_FOUND_INDEX = -1;
    public static final int[] ALL_ARMOR_SLOTS = new int[]{0, 1, 2, 3};
    public static final int[] HELMET_SLOT_ONLY = new int[]{3};
    public final NonNullList<ItemStack> items = NonNullList.withSize(36, ItemStack.EMPTY);
    public final NonNullList<ItemStack> armor = NonNullList.withSize(4, ItemStack.EMPTY);
    public final NonNullList<ItemStack> offhand = NonNullList.withSize(1, ItemStack.EMPTY);
    private final List<NonNullList<ItemStack>> compartments = ImmutableList.of(this.items, this.armor, this.offhand);
    public int selected;
    public final EntityHuman player;
    private int timesChanged;

    public PlayerInventory(EntityHuman var0) {
        this.player = var0;
    }

    public ItemStack getSelected() {
        if (PlayerInventory.isHotbarSlot(this.selected)) {
            return this.items.get(this.selected);
        }
        return ItemStack.EMPTY;
    }

    public static int getSelectionSize() {
        return 9;
    }

    private boolean hasRemainingSpaceForItem(ItemStack var0, ItemStack var1) {
        return !var0.isEmpty() && ItemStack.isSameItemSameTags(var0, var1) && var0.isStackable() && var0.getCount() < var0.getMaxStackSize() && var0.getCount() < this.getMaxStackSize();
    }

    public int getFreeSlot() {
        for (int var0 = 0; var0 < this.items.size(); ++var0) {
            if (!this.items.get(var0).isEmpty()) continue;
            return var0;
        }
        return -1;
    }

    public void setPickedItem(ItemStack var0) {
        int var1 = this.findSlotMatchingItem(var0);
        if (PlayerInventory.isHotbarSlot(var1)) {
            this.selected = var1;
            return;
        }
        if (var1 == -1) {
            int var2;
            this.selected = this.getSuitableHotbarSlot();
            if (!this.items.get(this.selected).isEmpty() && (var2 = this.getFreeSlot()) != -1) {
                this.items.set(var2, this.items.get(this.selected));
            }
            this.items.set(this.selected, var0);
        } else {
            this.pickSlot(var1);
        }
    }

    public void pickSlot(int var0) {
        this.selected = this.getSuitableHotbarSlot();
        ItemStack var1 = this.items.get(this.selected);
        this.items.set(this.selected, this.items.get(var0));
        this.items.set(var0, var1);
    }

    public static boolean isHotbarSlot(int var0) {
        return var0 >= 0 && var0 < 9;
    }

    public int findSlotMatchingItem(ItemStack var0) {
        for (int var1 = 0; var1 < this.items.size(); ++var1) {
            if (this.items.get(var1).isEmpty() || !ItemStack.isSameItemSameTags(var0, this.items.get(var1))) continue;
            return var1;
        }
        return -1;
    }

    public int findSlotMatchingUnusedItem(ItemStack var0) {
        for (int var1 = 0; var1 < this.items.size(); ++var1) {
            ItemStack var2 = this.items.get(var1);
            if (this.items.get(var1).isEmpty() || !ItemStack.isSameItemSameTags(var0, this.items.get(var1)) || this.items.get(var1).isDamaged() || var2.isEnchanted() || var2.hasCustomHoverName()) continue;
            return var1;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        int var1;
        int var0;
        for (var0 = 0; var0 < 9; ++var0) {
            var1 = (this.selected + var0) % 9;
            if (!this.items.get(var1).isEmpty()) continue;
            return var1;
        }
        for (var0 = 0; var0 < 9; ++var0) {
            var1 = (this.selected + var0) % 9;
            if (this.items.get(var1).isEnchanted()) continue;
            return var1;
        }
        return this.selected;
    }

    public void swapPaint(double var0) {
        int var2 = (int)Math.signum(var0);
        this.selected -= var2;
        while (this.selected < 0) {
            this.selected += 9;
        }
        while (this.selected >= 9) {
            this.selected -= 9;
        }
    }

    public int clearOrCountMatchingItems(Predicate<ItemStack> var0, int var1, IInventory var2) {
        int var3 = 0;
        boolean var4 = var1 == 0;
        var3 += ContainerUtil.clearOrCountMatchingItems(this, var0, var1 - var3, var4);
        var3 += ContainerUtil.clearOrCountMatchingItems(var2, var0, var1 - var3, var4);
        ItemStack var5 = this.player.containerMenu.getCarried();
        var3 += ContainerUtil.clearOrCountMatchingItems(var5, var0, var1 - var3, var4);
        if (var5.isEmpty()) {
            this.player.containerMenu.setCarried(ItemStack.EMPTY);
        }
        return var3;
    }

    private int addResource(ItemStack var0) {
        int var1 = this.getSlotWithRemainingSpace(var0);
        if (var1 == -1) {
            var1 = this.getFreeSlot();
        }
        if (var1 == -1) {
            return var0.getCount();
        }
        return this.addResource(var1, var0);
    }

    private int addResource(int var0, ItemStack var1) {
        int var5;
        Item var2 = var1.getItem();
        int var3 = var1.getCount();
        ItemStack var4 = this.getItem(var0);
        if (var4.isEmpty()) {
            var4 = new ItemStack(var2, 0);
            if (var1.hasTag()) {
                var4.setTag(var1.getTag().copy());
            }
            this.setItem(var0, var4);
        }
        if ((var5 = var3) > var4.getMaxStackSize() - var4.getCount()) {
            var5 = var4.getMaxStackSize() - var4.getCount();
        }
        if (var5 > this.getMaxStackSize() - var4.getCount()) {
            var5 = this.getMaxStackSize() - var4.getCount();
        }
        if (var5 == 0) {
            return var3;
        }
        var4.grow(var5);
        var4.setPopTime(5);
        return var3 -= var5;
    }

    public int getSlotWithRemainingSpace(ItemStack var0) {
        if (this.hasRemainingSpaceForItem(this.getItem(this.selected), var0)) {
            return this.selected;
        }
        if (this.hasRemainingSpaceForItem(this.getItem(40), var0)) {
            return 40;
        }
        for (int var1 = 0; var1 < this.items.size(); ++var1) {
            if (!this.hasRemainingSpaceForItem(this.items.get(var1), var0)) continue;
            return var1;
        }
        return -1;
    }

    public void tick() {
        for (NonNullList<ItemStack> var1 : this.compartments) {
            for (int var2 = 0; var2 < var1.size(); ++var2) {
                if (var1.get(var2).isEmpty()) continue;
                var1.get(var2).inventoryTick(this.player.level, this.player, var2, this.selected == var2);
            }
        }
    }

    public boolean add(ItemStack var0) {
        return this.add(-1, var0);
    }

    public boolean add(int var0, ItemStack var1) {
        if (var1.isEmpty()) {
            return false;
        }
        try {
            if (!var1.isDamaged()) {
                int var2;
                do {
                    var2 = var1.getCount();
                    if (var0 == -1) {
                        var1.setCount(this.addResource(var1));
                        continue;
                    }
                    var1.setCount(this.addResource(var0, var1));
                } while (!var1.isEmpty() && var1.getCount() < var2);
                if (var1.getCount() == var2 && this.player.getAbilities().instabuild) {
                    var1.setCount(0);
                    return true;
                }
                return var1.getCount() < var2;
            }
            if (var0 == -1) {
                var0 = this.getFreeSlot();
            }
            if (var0 >= 0) {
                this.items.set(var0, var1.copy());
                this.items.get(var0).setPopTime(5);
                var1.setCount(0);
                return true;
            }
            if (this.player.getAbilities().instabuild) {
                var1.setCount(0);
                return true;
            }
            return false;
        }
        catch (Throwable var2) {
            CrashReport var3 = CrashReport.forThrowable(var2, "Adding item to inventory");
            CrashReportSystemDetails var4 = var3.addCategory("Item being added");
            var4.setDetail("Item ID", Item.getId(var1.getItem()));
            var4.setDetail("Item data", var1.getDamageValue());
            var4.setDetail("Item name", () -> var1.getHoverName().getString());
            throw new ReportedException(var3);
        }
    }

    public void placeItemBackInInventory(ItemStack var0) {
        this.placeItemBackInInventory(var0, true);
    }

    public void placeItemBackInInventory(ItemStack var0, boolean var1) {
        while (!var0.isEmpty()) {
            int var2 = this.getSlotWithRemainingSpace(var0);
            if (var2 == -1) {
                var2 = this.getFreeSlot();
            }
            if (var2 == -1) {
                this.player.drop(var0, false);
                break;
            }
            int var3 = var0.getMaxStackSize() - this.getItem(var2).getCount();
            if (!this.add(var2, var0.split(var3)) || !var1 || !(this.player instanceof EntityPlayer)) continue;
            ((EntityPlayer)this.player).connection.send(new PacketPlayOutSetSlot(-2, 0, var2, this.getItem(var2)));
        }
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        NonNullList<ItemStack> var2 = null;
        for (NonNullList<ItemStack> var4 : this.compartments) {
            if (var0 < var4.size()) {
                var2 = var4;
                break;
            }
            var0 -= var4.size();
        }
        if (var2 != null && !((ItemStack)var2.get(var0)).isEmpty()) {
            return ContainerUtil.removeItem(var2, var0, var1);
        }
        return ItemStack.EMPTY;
    }

    public void removeItem(ItemStack var0) {
        block0: for (NonNullList<ItemStack> var2 : this.compartments) {
            for (int var3 = 0; var3 < var2.size(); ++var3) {
                if (var2.get(var3) != var0) continue;
                var2.set(var3, ItemStack.EMPTY);
                continue block0;
            }
        }
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        NonNullList<ItemStack> var1 = null;
        for (NonNullList<ItemStack> var3 : this.compartments) {
            if (var0 < var3.size()) {
                var1 = var3;
                break;
            }
            var0 -= var3.size();
        }
        if (var1 != null && !((ItemStack)var1.get(var0)).isEmpty()) {
            ItemStack var2 = var1.get(var0);
            var1.set(var0, ItemStack.EMPTY);
            return var2;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        NonNullList<ItemStack> var2 = null;
        for (NonNullList<ItemStack> var4 : this.compartments) {
            if (var0 < var4.size()) {
                var2 = var4;
                break;
            }
            var0 -= var4.size();
        }
        if (var2 != null) {
            var2.set(var0, var1);
        }
    }

    public float getDestroySpeed(IBlockData var0) {
        return this.items.get(this.selected).getDestroySpeed(var0);
    }

    public NBTTagList save(NBTTagList var0) {
        NBTTagCompound var2;
        int var1;
        for (var1 = 0; var1 < this.items.size(); ++var1) {
            if (this.items.get(var1).isEmpty()) continue;
            var2 = new NBTTagCompound();
            var2.putByte("Slot", (byte)var1);
            this.items.get(var1).save(var2);
            var0.add(var2);
        }
        for (var1 = 0; var1 < this.armor.size(); ++var1) {
            if (this.armor.get(var1).isEmpty()) continue;
            var2 = new NBTTagCompound();
            var2.putByte("Slot", (byte)(var1 + 100));
            this.armor.get(var1).save(var2);
            var0.add(var2);
        }
        for (var1 = 0; var1 < this.offhand.size(); ++var1) {
            if (this.offhand.get(var1).isEmpty()) continue;
            var2 = new NBTTagCompound();
            var2.putByte("Slot", (byte)(var1 + 150));
            this.offhand.get(var1).save(var2);
            var0.add(var2);
        }
        return var0;
    }

    public void load(NBTTagList var0) {
        this.items.clear();
        this.armor.clear();
        this.offhand.clear();
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            NBTTagCompound var2 = var0.getCompound(var1);
            int var3 = var2.getByte("Slot") & 0xFF;
            ItemStack var4 = ItemStack.of(var2);
            if (var4.isEmpty()) continue;
            if (var3 >= 0 && var3 < this.items.size()) {
                this.items.set(var3, var4);
                continue;
            }
            if (var3 >= 100 && var3 < this.armor.size() + 100) {
                this.armor.set(var3 - 100, var4);
                continue;
            }
            if (var3 < 150 || var3 >= this.offhand.size() + 150) continue;
            this.offhand.set(var3 - 150, var4);
        }
    }

    @Override
    public int getContainerSize() {
        return this.items.size() + this.armor.size() + this.offhand.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack var1 : this.items) {
            if (var1.isEmpty()) continue;
            return false;
        }
        for (ItemStack var1 : this.armor) {
            if (var1.isEmpty()) continue;
            return false;
        }
        for (ItemStack var1 : this.offhand) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int var0) {
        NonNullList<ItemStack> var1 = null;
        for (NonNullList<ItemStack> var3 : this.compartments) {
            if (var0 < var3.size()) {
                var1 = var3;
                break;
            }
            var0 -= var3.size();
        }
        return var1 == null ? ItemStack.EMPTY : (ItemStack)var1.get(var0);
    }

    @Override
    public IChatBaseComponent getName() {
        return new ChatMessage("container.inventory");
    }

    public ItemStack getArmor(int var0) {
        return this.armor.get(var0);
    }

    public void hurtArmor(DamageSource var0, float var12, int[] var2) {
        if (var12 <= 0.0f) {
            return;
        }
        if ((var12 /= 4.0f) < 1.0f) {
            var12 = 1.0f;
        }
        for (int var6 : var2) {
            ItemStack var7 = this.armor.get(var6);
            if (var0.isFire() && var7.getItem().isFireResistant() || !(var7.getItem() instanceof ItemArmor)) continue;
            var7.hurtAndBreak((int)var12, this.player, var1 -> var1.broadcastBreakEvent(EnumItemSlot.byTypeAndIndex(EnumItemSlot.Function.ARMOR, var6)));
        }
    }

    public void dropAll() {
        for (List list : this.compartments) {
            for (int var2 = 0; var2 < list.size(); ++var2) {
                ItemStack var3 = (ItemStack)list.get(var2);
                if (var3.isEmpty()) continue;
                this.player.drop(var3, true, false);
                list.set(var2, ItemStack.EMPTY);
            }
        }
    }

    @Override
    public void setChanged() {
        ++this.timesChanged;
    }

    public int getTimesChanged() {
        return this.timesChanged;
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        if (this.player.isRemoved()) {
            return false;
        }
        return !(var0.distanceToSqr(this.player) > 64.0);
    }

    public boolean contains(ItemStack var0) {
        for (List list : this.compartments) {
            for (ItemStack var4 : list) {
                if (var4.isEmpty() || !var4.sameItem(var0)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(TagKey<Item> var0) {
        for (List list : this.compartments) {
            for (ItemStack var4 : list) {
                if (var4.isEmpty() || !var4.is(var0)) continue;
                return true;
            }
        }
        return false;
    }

    public void replaceWith(PlayerInventory var0) {
        for (int var1 = 0; var1 < this.getContainerSize(); ++var1) {
            this.setItem(var1, var0.getItem(var1));
        }
        this.selected = var0.selected;
    }

    @Override
    public void clearContent() {
        for (List list : this.compartments) {
            list.clear();
        }
    }

    public void fillStackedContents(AutoRecipeStackManager var0) {
        for (ItemStack var2 : this.items) {
            var0.accountSimpleStack(var2);
        }
    }

    public ItemStack removeFromSelected(boolean var0) {
        ItemStack var1 = this.getSelected();
        if (var1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.removeItem(this.selected, var0 ? var1.getCount() : 1);
    }
}

