/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;

public final class VillagerType {
    public static final VillagerType DESERT = VillagerType.register("desert");
    public static final VillagerType JUNGLE = VillagerType.register("jungle");
    public static final VillagerType PLAINS = VillagerType.register("plains");
    public static final VillagerType SAVANNA = VillagerType.register("savanna");
    public static final VillagerType SNOW = VillagerType.register("snow");
    public static final VillagerType SWAMP = VillagerType.register("swamp");
    public static final VillagerType TAIGA = VillagerType.register("taiga");
    private final String name;
    private static final Map<ResourceKey<BiomeBase>, VillagerType> BY_BIOME = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put(Biomes.BADLANDS, DESERT);
        var0.put(Biomes.DESERT, DESERT);
        var0.put(Biomes.ERODED_BADLANDS, DESERT);
        var0.put(Biomes.WOODED_BADLANDS, DESERT);
        var0.put(Biomes.BAMBOO_JUNGLE, JUNGLE);
        var0.put(Biomes.JUNGLE, JUNGLE);
        var0.put(Biomes.SPARSE_JUNGLE, JUNGLE);
        var0.put(Biomes.SAVANNA_PLATEAU, SAVANNA);
        var0.put(Biomes.SAVANNA, SAVANNA);
        var0.put(Biomes.WINDSWEPT_SAVANNA, SAVANNA);
        var0.put(Biomes.DEEP_FROZEN_OCEAN, SNOW);
        var0.put(Biomes.FROZEN_OCEAN, SNOW);
        var0.put(Biomes.FROZEN_RIVER, SNOW);
        var0.put(Biomes.ICE_SPIKES, SNOW);
        var0.put(Biomes.SNOWY_BEACH, SNOW);
        var0.put(Biomes.SNOWY_TAIGA, SNOW);
        var0.put(Biomes.SNOWY_PLAINS, SNOW);
        var0.put(Biomes.GROVE, SNOW);
        var0.put(Biomes.SNOWY_SLOPES, SNOW);
        var0.put(Biomes.FROZEN_PEAKS, SNOW);
        var0.put(Biomes.JAGGED_PEAKS, SNOW);
        var0.put(Biomes.SWAMP, SWAMP);
        var0.put(Biomes.OLD_GROWTH_SPRUCE_TAIGA, TAIGA);
        var0.put(Biomes.OLD_GROWTH_PINE_TAIGA, TAIGA);
        var0.put(Biomes.WINDSWEPT_GRAVELLY_HILLS, TAIGA);
        var0.put(Biomes.WINDSWEPT_HILLS, TAIGA);
        var0.put(Biomes.TAIGA, TAIGA);
        var0.put(Biomes.WINDSWEPT_FOREST, TAIGA);
    });

    private VillagerType(String var0) {
        this.name = var0;
    }

    public String toString() {
        return this.name;
    }

    private static VillagerType register(String var0) {
        return IRegistry.register(IRegistry.VILLAGER_TYPE, new MinecraftKey(var0), new VillagerType(var0));
    }

    public static VillagerType byBiome(Holder<BiomeBase> var0) {
        return var0.unwrapKey().map(BY_BIOME::get).orElse(PLAINS);
    }
}

