/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinAI;

public class BehaviorHuntHoglin<E extends EntityPiglin>
extends Behavior<E> {
    public BehaviorHuntHoglin() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ANGRY_AT, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.HUNTED_RECENTLY, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, (Object)((Object)MemoryStatus.REGISTERED)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityPiglin var1) {
        return !var1.isBaby() && !PiglinAI.hasAnyoneNearbyHuntedRecently(var1);
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        EntityHoglin var4 = ((EntityPiglin)var1).getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN).get();
        PiglinAI.setAngerTarget(var1, var4);
        PiglinAI.dontKillAnyMoreHoglinsForAWhile(var1);
        PiglinAI.broadcastAngerTarget(var1, var4);
        PiglinAI.broadcastDontKillAnyMoreHoglinsForAWhile(var1);
    }
}

