/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityZombie
extends EntityMonster {
    private static final UUID SPEED_MODIFIER_BABY_UUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_UUID, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final DataWatcherObject<Boolean> DATA_BABY_ID = DataWatcher.defineId(EntityZombie.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Integer> DATA_SPECIAL_TYPE_ID = DataWatcher.defineId(EntityZombie.class, DataWatcherRegistry.INT);
    public static final DataWatcherObject<Boolean> DATA_DROWNED_CONVERSION_ID = DataWatcher.defineId(EntityZombie.class, DataWatcherRegistry.BOOLEAN);
    public static final float ZOMBIE_LEADER_CHANCE = 0.05f;
    public static final int REINFORCEMENT_ATTEMPTS = 50;
    public static final int REINFORCEMENT_RANGE_MAX = 40;
    public static final int REINFORCEMENT_RANGE_MIN = 7;
    private static final float BREAK_DOOR_CHANCE = 0.1f;
    private static final Predicate<EnumDifficulty> DOOR_BREAKING_PREDICATE = var0 -> var0 == EnumDifficulty.HARD;
    private final PathfinderGoalBreakDoor breakDoorGoal = new PathfinderGoalBreakDoor(this, DOOR_BREAKING_PREDICATE);
    private boolean canBreakDoors;
    private int inWaterTime;
    public int conversionTime;

    public EntityZombie(EntityTypes<? extends EntityZombie> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
    }

    public EntityZombie(World var0) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.ZOMBIE, var0);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(4, new a((EntityCreature)this, 1.0, 3));
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.goalSelector.addGoal(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::canBreakDoors));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]).setAlertOthers(EntityPigZombie.class));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.targetSelector.addGoal(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.BABY_ON_LAND_SELECTOR));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.FOLLOW_RANGE, 35.0).add(GenericAttributes.MOVEMENT_SPEED, 0.23f).add(GenericAttributes.ATTACK_DAMAGE, 3.0).add(GenericAttributes.ARMOR, 2.0).add(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.getEntityData().define(DATA_BABY_ID, false);
        this.getEntityData().define(DATA_SPECIAL_TYPE_ID, 0);
        this.getEntityData().define(DATA_DROWNED_CONVERSION_ID, false);
    }

    public boolean isUnderWaterConverting() {
        return this.getEntityData().get(DATA_DROWNED_CONVERSION_ID);
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean var0) {
        if (this.supportsBreakDoorGoal() && PathfinderGoalUtil.hasGroundPathNavigation(this)) {
            if (this.canBreakDoors != var0) {
                this.canBreakDoors = var0;
                ((Navigation)this.getNavigation()).setCanOpenDoors(var0);
                if (var0) {
                    this.goalSelector.addGoal(1, this.breakDoorGoal);
                } else {
                    this.goalSelector.removeGoal(this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.goalSelector.removeGoal(this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    protected boolean supportsBreakDoorGoal() {
        return true;
    }

    @Override
    public boolean isBaby() {
        return this.getEntityData().get(DATA_BABY_ID);
    }

    @Override
    protected int getExperienceReward(EntityHuman var0) {
        if (this.isBaby()) {
            this.xpReward = (int)((double)this.xpReward * 2.5);
        }
        return super.getExperienceReward(var0);
    }

    @Override
    public void setBaby(boolean var0) {
        this.getEntityData().set(DATA_BABY_ID, var0);
        if (this.level != null && !this.level.isClientSide) {
            AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
            var1.removeModifier(SPEED_MODIFIER_BABY);
            if (var0) {
                var1.addTransientModifier(SPEED_MODIFIER_BABY);
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_BABY_ID.equals(var0)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(var0);
    }

    protected boolean convertsInWater() {
        return true;
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide && this.isAlive() && !this.isNoAi()) {
            if (this.isUnderWaterConverting()) {
                --this.conversionTime;
                if (this.conversionTime < 0) {
                    this.doUnderWaterConversion();
                }
            } else if (this.convertsInWater()) {
                if (this.isEyeInFluid(TagsFluid.WATER)) {
                    ++this.inWaterTime;
                    if (this.inWaterTime >= 600) {
                        this.startUnderWaterConversion(300);
                    }
                } else {
                    this.inWaterTime = -1;
                }
            }
        }
        super.tick();
    }

    @Override
    public void aiStep() {
        if (this.isAlive()) {
            boolean var0;
            boolean bl = var0 = this.isSunSensitive() && this.isSunBurnTick();
            if (var0) {
                ItemStack var1 = this.getItemBySlot(EnumItemSlot.HEAD);
                if (!var1.isEmpty()) {
                    if (var1.isDamageableItem()) {
                        var1.setDamageValue(var1.getDamageValue() + this.random.nextInt(2));
                        if (var1.getDamageValue() >= var1.getMaxDamage()) {
                            this.broadcastBreakEvent(EnumItemSlot.HEAD);
                            this.setItemSlot(EnumItemSlot.HEAD, ItemStack.EMPTY);
                        }
                    }
                    var0 = false;
                }
                if (var0) {
                    this.setSecondsOnFire(8);
                }
            }
        }
        super.aiStep();
    }

    public void startUnderWaterConversion(int var0) {
        this.conversionTime = var0;
        this.getEntityData().set(DATA_DROWNED_CONVERSION_ID, true);
    }

    protected void doUnderWaterConversion() {
        this.convertToZombieType(EntityTypes.DROWNED);
        if (!this.isSilent()) {
            this.level.levelEvent(null, 1040, this.blockPosition(), 0);
        }
    }

    protected void convertToZombieType(EntityTypes<? extends EntityZombie> var0) {
        EntityZombie var1 = this.convertTo(var0, true);
        if (var1 != null) {
            var1.handleAttributes(var1.level.getCurrentDifficultyAt(var1.blockPosition()).getSpecialMultiplier());
            var1.setCanBreakDoors(var1.supportsBreakDoorGoal() && this.canBreakDoors());
        }
    }

    protected boolean isSunSensitive() {
        return true;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (!super.hurt(var0, var1)) {
            return false;
        }
        if (!(this.level instanceof WorldServer)) {
            return false;
        }
        WorldServer var2 = (WorldServer)this.level;
        EntityLiving var3 = this.getTarget();
        if (var3 == null && var0.getEntity() instanceof EntityLiving) {
            var3 = (EntityLiving)var0.getEntity();
        }
        if (var3 != null && this.level.getDifficulty() == EnumDifficulty.HARD && (double)this.random.nextFloat() < this.getAttributeValue(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE) && this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            int var4 = MathHelper.floor(this.getX());
            int var5 = MathHelper.floor(this.getY());
            int var6 = MathHelper.floor(this.getZ());
            EntityZombie var7 = new EntityZombie(this.level);
            for (int var8 = 0; var8 < 50; ++var8) {
                int var9 = var4 + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1);
                int var10 = var5 + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1);
                int var11 = var6 + MathHelper.nextInt(this.random, 7, 40) * MathHelper.nextInt(this.random, -1, 1);
                BlockPosition var12 = new BlockPosition(var9, var10, var11);
                EntityTypes<?> var13 = var7.getType();
                EntityPositionTypes.Surface var14 = EntityPositionTypes.getPlacementType(var13);
                if (!SpawnerCreature.isSpawnPositionOk(var14, this.level, var12, var13) || !EntityPositionTypes.checkSpawnRules(var13, var2, EnumMobSpawn.REINFORCEMENT, var12, this.level.random)) continue;
                var7.setPos(var9, var10, var11);
                if (this.level.hasNearbyAlivePlayer(var9, var10, var11, 7.0) || !this.level.isUnobstructed(var7) || !this.level.noCollision(var7) || this.level.containsAnyLiquid(var7.getBoundingBox())) continue;
                var7.setTarget(var3);
                var7.finalizeSpawn(var2, this.level.getCurrentDifficultyAt(var7.blockPosition()), EnumMobSpawn.REINFORCEMENT, null, null);
                var2.addFreshEntityWithPassengers(var7);
                this.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE).addPermanentModifier(new AttributeModifier("Zombie reinforcement caller charge", -0.05f, AttributeModifier.Operation.ADDITION));
                var7.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE).addPermanentModifier(new AttributeModifier("Zombie reinforcement callee charge", -0.05f, AttributeModifier.Operation.ADDITION));
                break;
            }
        }
        return true;
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        boolean var1 = super.doHurtTarget(var0);
        if (var1) {
            float var2 = this.level.getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            if (this.getMainHandItem().isEmpty() && this.isOnFire() && this.random.nextFloat() < var2 * 0.3f) {
                var0.setSecondsOnFire(2 * (int)var2);
            }
        }
        return var1;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.ZOMBIE_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ZOMBIE_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.ZOMBIE_DEATH;
    }

    protected SoundEffect getStepSound() {
        return SoundEffects.ZOMBIE_STEP;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    @Override
    public EnumMonsterType getMobType() {
        return EnumMonsterType.UNDEAD;
    }

    @Override
    protected void populateDefaultEquipmentSlots(DifficultyDamageScaler var0) {
        super.populateDefaultEquipmentSlots(var0);
        float f2 = this.random.nextFloat();
        float f3 = this.level.getDifficulty() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f2 < f3) {
            int var1 = this.random.nextInt(3);
            if (var1 == 0) {
                this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_SWORD));
            } else {
                this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_SHOVEL));
            }
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("IsBaby", this.isBaby());
        var0.putBoolean("CanBreakDoors", this.canBreakDoors());
        var0.putInt("InWaterTime", this.isInWater() ? this.inWaterTime : -1);
        var0.putInt("DrownedConversionTime", this.isUnderWaterConverting() ? this.conversionTime : -1);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setBaby(var0.getBoolean("IsBaby"));
        this.setCanBreakDoors(var0.getBoolean("CanBreakDoors"));
        this.inWaterTime = var0.getInt("InWaterTime");
        if (var0.contains("DrownedConversionTime", 99) && var0.getInt("DrownedConversionTime") > -1) {
            this.startUnderWaterConversion(var0.getInt("DrownedConversionTime"));
        }
    }

    @Override
    public void killed(WorldServer var0, EntityLiving var1) {
        super.killed(var0, var1);
        if ((var0.getDifficulty() == EnumDifficulty.NORMAL || var0.getDifficulty() == EnumDifficulty.HARD) && var1 instanceof EntityVillager) {
            if (var0.getDifficulty() != EnumDifficulty.HARD && this.random.nextBoolean()) {
                return;
            }
            EntityVillager var2 = (EntityVillager)var1;
            EntityZombieVillager var3 = var2.convertTo(EntityTypes.ZOMBIE_VILLAGER, false);
            var3.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var3.blockPosition()), EnumMobSpawn.CONVERSION, new GroupDataZombie(false, true), null);
            var3.setVillagerData(var2.getVillagerData());
            var3.setGossips((NBTBase)var2.getGossips().store(DynamicOpsNBT.INSTANCE).getValue());
            var3.setTradeOffers(var2.getOffers().createTag());
            var3.setVillagerXp(var2.getVillagerXp());
            if (!this.isSilent()) {
                var0.levelEvent(null, 1026, this.blockPosition(), 0);
            }
        }
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return this.isBaby() ? 0.93f : 1.74f;
    }

    @Override
    public boolean canHoldItem(ItemStack var0) {
        if (var0.is(Items.EGG) && this.isBaby() && this.isPassenger()) {
            return false;
        }
        return super.canHoldItem(var0);
    }

    @Override
    public boolean wantsToPickUp(ItemStack var0) {
        if (var0.is(Items.GLOW_INK_SAC)) {
            return false;
        }
        return super.wantsToPickUp(var0);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        Object var6;
        var3 = super.finalizeSpawn(var0, var1, var2, var3, var4);
        float var5 = var1.getSpecialMultiplier();
        this.setCanPickUpLoot(this.random.nextFloat() < 0.55f * var5);
        if (var3 == null) {
            var3 = new GroupDataZombie(EntityZombie.getSpawnAsBabyOdds(var0.getRandom()), true);
        }
        if (var3 instanceof GroupDataZombie) {
            var6 = (GroupDataZombie)var3;
            if (((GroupDataZombie)var6).isBaby) {
                this.setBaby(true);
                if (((GroupDataZombie)var6).canSpawnJockey) {
                    if ((double)var0.getRandom().nextFloat() < 0.05) {
                        var7 = var0.getEntitiesOfClass(EntityChicken.class, this.getBoundingBox().inflate(5.0, 3.0, 5.0), IEntitySelector.ENTITY_NOT_BEING_RIDDEN);
                        if (!var7.isEmpty()) {
                            EntityChicken var8 = (EntityChicken)var7.get(0);
                            var8.setChickenJockey(true);
                            this.startRiding(var8);
                        }
                    } else if ((double)var0.getRandom().nextFloat() < 0.05) {
                        var7 = EntityTypes.CHICKEN.create(this.level);
                        ((Entity)((Object)var7)).moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                        ((EntityAgeable)((Object)var7)).finalizeSpawn(var0, var1, EnumMobSpawn.JOCKEY, null, null);
                        ((EntityChicken)((Object)var7)).setChickenJockey(true);
                        this.startRiding((Entity)((Object)var7));
                        var0.addFreshEntity((Entity)((Object)var7));
                    }
                }
            }
            this.setCanBreakDoors(this.supportsBreakDoorGoal() && this.random.nextFloat() < var5 * 0.1f);
            this.populateDefaultEquipmentSlots(var1);
            this.populateDefaultEquipmentEnchantments(var1);
        }
        if (this.getItemBySlot(EnumItemSlot.HEAD).isEmpty()) {
            var6 = LocalDate.now();
            int var7 = ((LocalDate)var6).get(ChronoField.DAY_OF_MONTH);
            int var8 = ((LocalDate)var6).get(ChronoField.MONTH_OF_YEAR);
            if (var8 == 10 && var7 == 31 && this.random.nextFloat() < 0.25f) {
                this.setItemSlot(EnumItemSlot.HEAD, new ItemStack(this.random.nextFloat() < 0.1f ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN));
                this.armorDropChances[EnumItemSlot.HEAD.getIndex()] = 0.0f;
            }
        }
        this.handleAttributes(var5);
        return var3;
    }

    public static boolean getSpawnAsBabyOdds(Random var0) {
        return var0.nextFloat() < 0.05f;
    }

    protected void handleAttributes(float var0) {
        this.randomizeReinforcementsChance();
        this.getAttribute(GenericAttributes.KNOCKBACK_RESISTANCE).addPermanentModifier(new AttributeModifier("Random spawn bonus", this.random.nextDouble() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        double var1 = this.random.nextDouble() * 1.5 * (double)var0;
        if (var1 > 1.0) {
            this.getAttribute(GenericAttributes.FOLLOW_RANGE).addPermanentModifier(new AttributeModifier("Random zombie-spawn bonus", var1, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.random.nextFloat() < var0 * 0.05f) {
            this.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE).addPermanentModifier(new AttributeModifier("Leader zombie bonus", this.random.nextDouble() * 0.25 + 0.5, AttributeModifier.Operation.ADDITION));
            this.getAttribute(GenericAttributes.MAX_HEALTH).addPermanentModifier(new AttributeModifier("Leader zombie bonus", this.random.nextDouble() * 3.0 + 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            this.setCanBreakDoors(this.supportsBreakDoorGoal());
        }
    }

    protected void randomizeReinforcementsChance() {
        this.getAttribute(GenericAttributes.SPAWN_REINFORCEMENTS_CHANCE).setBaseValue(this.random.nextDouble() * (double)0.1f);
    }

    @Override
    public double getMyRidingOffset() {
        return this.isBaby() ? 0.0 : -0.45;
    }

    @Override
    protected void dropCustomDeathLoot(DamageSource var0, int var1, boolean var2) {
        ItemStack var5;
        EntityCreeper var4;
        super.dropCustomDeathLoot(var0, var1, var2);
        Entity var3 = var0.getEntity();
        if (var3 instanceof EntityCreeper && (var4 = (EntityCreeper)var3).canDropMobsSkull() && !(var5 = this.getSkull()).isEmpty()) {
            var4.increaseDroppedSkulls();
            this.spawnAtLocation(var5);
        }
    }

    protected ItemStack getSkull() {
        return new ItemStack(Items.ZOMBIE_HEAD);
    }

    class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature var1, double var2, int var4) {
            super(Blocks.TURTLE_EGG, var1, var2, var4);
        }

        @Override
        public void playDestroyProgressSound(GeneratorAccess var0, BlockPosition var1) {
            var0.playSound(null, var1, SoundEffects.ZOMBIE_DESTROY_EGG, SoundCategory.HOSTILE, 0.5f, 0.9f + EntityZombie.this.random.nextFloat() * 0.2f);
        }

        @Override
        public void playBreakSound(World var0, BlockPosition var1) {
            var0.playSound(null, var1, SoundEffects.TURTLE_EGG_BREAK, SoundCategory.BLOCKS, 0.7f, 0.9f + var0.random.nextFloat() * 0.2f);
        }

        @Override
        public double acceptedDistance() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean isBaby;
        public final boolean canSpawnJockey;

        public GroupDataZombie(boolean var0, boolean var1) {
            this.isBaby = var0;
            this.canSpawnJockey = var1;
        }
    }
}

