/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class EntityStrider
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final float SUFFOCATE_STEERING_MODIFIER = 0.23f;
    private static final float SUFFOCATE_SPEED_MODIFIER = 0.66f;
    private static final float STEERING_MODIFIER = 0.55f;
    private static final RecipeItemStack FOOD_ITEMS = RecipeItemStack.of(Items.WARPED_FUNGUS);
    private static final RecipeItemStack TEMPT_ITEMS = RecipeItemStack.of(Items.WARPED_FUNGUS, Items.WARPED_FUNGUS_ON_A_STICK);
    private static final DataWatcherObject<Integer> DATA_BOOST_TIME = DataWatcher.defineId(EntityStrider.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_SUFFOCATING = DataWatcher.defineId(EntityStrider.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_SADDLE_ID = DataWatcher.defineId(EntityStrider.class, DataWatcherRegistry.BOOLEAN);
    public final SaddleStorage steering;
    @Nullable
    private PathfinderGoalTempt temptGoal;
    @Nullable
    private PathfinderGoalPanic panicGoal;

    public EntityStrider(EntityTypes<? extends EntityStrider> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.steering = new SaddleStorage(this.entityData, DATA_BOOST_TIME, DATA_SADDLE_ID);
        this.blocksBuilding = true;
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
    }

    public static boolean checkStriderSpawnRules(EntityTypes<EntityStrider> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, Random var4) {
        BlockPosition.MutableBlockPosition var5 = var3.mutable();
        do {
            var5.move(EnumDirection.UP);
        } while (var1.getFluidState(var5).is(TagsFluid.LAVA));
        return var1.getBlockState(var5).isAir();
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_BOOST_TIME.equals(var0) && this.level.isClientSide) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_BOOST_TIME, 0);
        this.entityData.define(DATA_SUFFOCATING, false);
        this.entityData.define(DATA_SADDLE_ID, false);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        this.steering.addAdditionalSaveData(var0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.steering.readAdditionalSaveData(var0);
    }

    @Override
    public boolean isSaddled() {
        return this.steering.hasSaddle();
    }

    @Override
    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    public void equipSaddle(@Nullable SoundCategory var0) {
        this.steering.setSaddle(true);
        if (var0 != null) {
            this.level.playSound(null, this, SoundEffects.STRIDER_SADDLE, var0, 0.5f, 1.0f);
        }
    }

    @Override
    protected void registerGoals() {
        this.panicGoal = new PathfinderGoalPanic(this, 1.65);
        this.goalSelector.addGoal(1, this.panicGoal);
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 1.0));
        this.temptGoal = new PathfinderGoalTempt(this, 1.4, TEMPT_ITEMS, false);
        this.goalSelector.addGoal(3, this.temptGoal);
        this.goalSelector.addGoal(4, new a(this, 1.5));
        this.goalSelector.addGoal(5, new PathfinderGoalFollowParent(this, 1.1));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        this.goalSelector.addGoal(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void setSuffocating(boolean var0) {
        this.entityData.set(DATA_SUFFOCATING, var0);
    }

    public boolean isSuffocating() {
        if (this.getVehicle() instanceof EntityStrider) {
            return ((EntityStrider)this.getVehicle()).isSuffocating();
        }
        return this.entityData.get(DATA_SUFFOCATING);
    }

    @Override
    public boolean canStandOnFluid(Fluid var0) {
        return var0.is(TagsFluid.LAVA);
    }

    @Override
    public double getPassengersRidingOffset() {
        float var0 = Math.min(0.25f, this.animationSpeed);
        float var1 = this.animationPosition;
        return (double)this.getBbHeight() - 0.19 + (double)(0.12f * MathHelper.cos(var1 * 1.5f) * 2.0f * var0);
    }

    @Override
    public boolean canBeControlledByRider() {
        Entity var0 = this.getControllingPassenger();
        if (!(var0 instanceof EntityHuman)) {
            return false;
        }
        EntityHuman var1 = (EntityHuman)var0;
        return var1.getMainHandItem().is(Items.WARPED_FUNGUS_ON_A_STICK) || var1.getOffhandItem().is(Items.WARPED_FUNGUS_ON_A_STICK);
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return var0.isUnobstructed(this);
    }

    @Override
    @Nullable
    public Entity getControllingPassenger() {
        return this.getFirstPassenger();
    }

    @Override
    public Vec3D getDismountLocationForPassenger(EntityLiving var0) {
        Vec3D[] var1 = new Vec3D[]{EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), var0.getYRot()), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), var0.getYRot() - 22.5f), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), var0.getYRot() + 22.5f), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), var0.getYRot() - 45.0f), EntityStrider.getCollisionHorizontalEscapeVector(this.getBbWidth(), var0.getBbWidth(), var0.getYRot() + 45.0f)};
        LinkedHashSet var2 = Sets.newLinkedHashSet();
        double var3 = this.getBoundingBox().maxY;
        double var5 = this.getBoundingBox().minY - 0.5;
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        for (Vec3D var11 : var1) {
            var7.set(this.getX() + var11.x, var3, this.getZ() + var11.z);
            for (double var12 = var3; var12 > var5; var12 -= 1.0) {
                var2.add(var7.immutable());
                var7.move(EnumDirection.DOWN);
            }
        }
        for (BlockPosition var9 : var2) {
            double var10;
            if (this.level.getFluidState(var9).is(TagsFluid.LAVA) || !DismountUtil.isBlockFloorValid(var10 = this.level.getBlockFloorHeight(var9))) continue;
            Vec3D var12 = Vec3D.upFromBottomCenterOf(var9, var10);
            for (EntityPose var14 : var0.getDismountPoses()) {
                AxisAlignedBB var15 = var0.getLocalBoundsForPose(var14);
                if (!DismountUtil.canDismountTo(this.level, var0, var15.move(var12))) continue;
                var0.setPose(var14);
                return var12;
            }
        }
        return new Vec3D(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Override
    public void travel(Vec3D var0) {
        this.setSpeed(this.getMoveSpeed());
        this.travel(this, this.steering, var0);
    }

    public float getMoveSpeed() {
        return (float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) * (this.isSuffocating() ? 0.66f : 1.0f);
    }

    @Override
    public float getSteeringSpeed() {
        return (float)this.getAttributeValue(GenericAttributes.MOVEMENT_SPEED) * (this.isSuffocating() ? 0.23f : 0.55f);
    }

    @Override
    public void travelWithInput(Vec3D var0) {
        super.travel(var0);
    }

    @Override
    protected float nextStep() {
        return this.moveDist + 0.6f;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(this.isInLava() ? SoundEffects.STRIDER_STEP_LAVA : SoundEffects.STRIDER_STEP, 1.0f, 1.0f);
    }

    @Override
    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
        this.checkInsideBlocks();
        if (this.isInLava()) {
            this.resetFallDistance();
            return;
        }
        super.checkFallDamage(var0, var2, var3, var4);
    }

    @Override
    public void tick() {
        if (this.isBeingTempted() && this.random.nextInt(140) == 0) {
            this.playSound(SoundEffects.STRIDER_HAPPY, 1.0f, this.getVoicePitch());
        } else if (this.isPanicking() && this.random.nextInt(60) == 0) {
            this.playSound(SoundEffects.STRIDER_RETREAT, 1.0f, this.getVoicePitch());
        }
        IBlockData var0 = this.level.getBlockState(this.blockPosition());
        IBlockData var1 = this.getBlockStateOn();
        boolean var2 = var0.is(TagsBlock.STRIDER_WARM_BLOCKS) || var1.is(TagsBlock.STRIDER_WARM_BLOCKS) || this.getFluidHeight(TagsFluid.LAVA) > 0.0;
        this.setSuffocating(!var2);
        super.tick();
        this.floatStrider();
        this.checkInsideBlocks();
    }

    private boolean isPanicking() {
        return this.panicGoal != null && this.panicGoal.isRunning();
    }

    private boolean isBeingTempted() {
        return this.temptGoal != null && this.temptGoal.isRunning();
    }

    @Override
    protected boolean shouldPassengersInheritMalus() {
        return true;
    }

    private void floatStrider() {
        if (this.isInLava()) {
            VoxelShapeCollision var0 = VoxelShapeCollision.of(this);
            if (!var0.isAbove(BlockFluids.STABLE_SHAPE, this.blockPosition(), true) || this.level.getFluidState(this.blockPosition().above()).is(TagsFluid.LAVA)) {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
            } else {
                this.onGround = true;
            }
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.175f).add(GenericAttributes.FOLLOW_RANGE, 16.0);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.isPanicking() || this.isBeingTempted()) {
            return null;
        }
        return SoundEffects.STRIDER_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.STRIDER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.STRIDER_DEATH;
    }

    @Override
    protected boolean canAddPassenger(Entity var0) {
        return !this.isVehicle() && !this.isEyeInFluid(TagsFluid.LAVA);
    }

    @Override
    public boolean isSensitiveToWater() {
        return true;
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new b(this, var0);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (var1.getBlockState(var0).getFluidState().is(TagsFluid.LAVA)) {
            return 10.0f;
        }
        return this.isInLava() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    @Override
    public EntityStrider getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.STRIDER.create(var0);
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return FOOD_ITEMS.test(var0);
    }

    @Override
    protected void dropEquipment() {
        super.dropEquipment();
        if (this.isSaddled()) {
            this.spawnAtLocation(Items.SADDLE);
        }
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        boolean var2 = this.isFood(var0.getItemInHand(var1));
        if (!var2 && this.isSaddled() && !this.isVehicle() && !var0.isSecondaryUseActive()) {
            if (!this.level.isClientSide) {
                var0.startRiding(this);
            }
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        EnumInteractionResult var3 = super.mobInteract(var0, var1);
        if (!var3.consumesAction()) {
            ItemStack var4 = var0.getItemInHand(var1);
            if (var4.is(Items.SADDLE)) {
                return var4.interactLivingEntity(var0, this, var1);
            }
            return EnumInteractionResult.PASS;
        }
        if (var2 && !this.isSilent()) {
            this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.STRIDER_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        return var3;
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        if (this.isBaby()) {
            return super.finalizeSpawn(var0, var1, var2, var3, var4);
        }
        if (this.random.nextInt(30) == 0) {
            EntityInsentient var5 = EntityTypes.ZOMBIFIED_PIGLIN.create(var0.getLevel());
            var3 = this.spawnJockey(var0, var1, var5, new EntityZombie.GroupDataZombie(EntityZombie.getSpawnAsBabyOdds(this.random), false));
            var5.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.WARPED_FUNGUS_ON_A_STICK));
            this.equipSaddle(null);
        } else if (this.random.nextInt(10) == 0) {
            EntityAgeable var5 = EntityTypes.STRIDER.create(var0.getLevel());
            var5.setAge(-24000);
            var3 = this.spawnJockey(var0, var1, var5, null);
        } else {
            var3 = new EntityAgeable.a(0.5f);
        }
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    private GroupDataEntity spawnJockey(WorldAccess var0, DifficultyDamageScaler var1, EntityInsentient var2, @Nullable GroupDataEntity var3) {
        var2.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
        var2.finalizeSpawn(var0, var1, EnumMobSpawn.JOCKEY, var3, null);
        var2.startRiding(this, true);
        return new EntityAgeable.a(0.0f);
    }

    @Override
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider strider;

        a(EntityStrider var0, double var1) {
            super(var0, var1, 8, 2);
            this.strider = var0;
        }

        @Override
        public BlockPosition getMoveToTarget() {
            return this.blockPos;
        }

        @Override
        public boolean canContinueToUse() {
            return !this.strider.isInLava() && this.isValidTarget(this.strider.level, this.blockPos);
        }

        @Override
        public boolean canUse() {
            return !this.strider.isInLava() && super.canUse();
        }

        @Override
        public boolean shouldRecalculatePath() {
            return this.tryTicks % 20 == 0;
        }

        @Override
        protected boolean isValidTarget(IWorldReader var0, BlockPosition var1) {
            return var0.getBlockState(var1).is(Blocks.LAVA) && var0.getBlockState(var1.above()).isPathfindable(var0, var1, PathMode.LAND);
        }
    }

    static class b
    extends Navigation {
        b(EntityStrider var0, World var1) {
            super(var0, var1);
        }

        @Override
        protected Pathfinder createPathFinder(int var0) {
            this.nodeEvaluator = new PathfinderNormal();
            return new Pathfinder(this.nodeEvaluator, var0);
        }

        @Override
        protected boolean hasValidPathType(PathType var0) {
            if (var0 == PathType.LAVA || var0 == PathType.DAMAGE_FIRE || var0 == PathType.DANGER_FIRE) {
                return true;
            }
            return super.hasValidPathType(var0);
        }

        @Override
        public boolean isStableDestination(BlockPosition var0) {
            return this.level.getBlockState(var0).is(Blocks.LAVA) || super.isStableDestination(var0);
        }
    }
}

