/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonControllerLanded;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;

public class DragonControllerLandedAttack
extends AbstractDragonControllerLanded {
    private static final int ROAR_DURATION = 40;
    private int attackingTicks;

    public DragonControllerLandedAttack(EntityEnderDragon var0) {
        super(var0);
    }

    @Override
    public void doClientTick() {
        this.dragon.level.playLocalSound(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ(), SoundEffects.ENDER_DRAGON_GROWL, this.dragon.getSoundSource(), 2.5f, 0.8f + this.dragon.getRandom().nextFloat() * 0.3f, false);
    }

    @Override
    public void doServerTick() {
        if (this.attackingTicks++ >= 40) {
            this.dragon.getPhaseManager().setPhase(DragonControllerPhase.SITTING_FLAMING);
        }
    }

    @Override
    public void begin() {
        this.attackingTicks = 0;
    }

    public DragonControllerPhase<DragonControllerLandedAttack> getPhase() {
        return DragonControllerPhase.SITTING_ATTACKING;
    }
}

