/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;

public class PathfinderGoalHorseTrap
extends PathfinderGoal {
    private final EntityHorseSkeleton horse;

    public PathfinderGoalHorseTrap(EntityHorseSkeleton var0) {
        this.horse = var0;
    }

    @Override
    public boolean canUse() {
        return this.horse.level.hasNearbyAlivePlayer(this.horse.getX(), this.horse.getY(), this.horse.getZ(), 10.0);
    }

    @Override
    public void tick() {
        WorldServer var0 = (WorldServer)this.horse.level;
        DifficultyDamageScaler var1 = var0.getCurrentDifficultyAt(this.horse.blockPosition());
        this.horse.setTrap(false);
        this.horse.setTamed(true);
        this.horse.setAge(0);
        EntityLightning var2 = EntityTypes.LIGHTNING_BOLT.create(var0);
        var2.moveTo(this.horse.getX(), this.horse.getY(), this.horse.getZ());
        var2.setVisualOnly(true);
        var0.addFreshEntity(var2);
        EntitySkeleton var3 = this.createSkeleton(var1, this.horse);
        var3.startRiding(this.horse);
        var0.addFreshEntityWithPassengers(var3);
        for (int var4 = 0; var4 < 3; ++var4) {
            EntityHorseAbstract var5 = this.createHorse(var1);
            EntitySkeleton var6 = this.createSkeleton(var1, var5);
            var6.startRiding(var5);
            var5.push(this.horse.getRandom().nextGaussian() * 0.5, 0.0, this.horse.getRandom().nextGaussian() * 0.5);
            var0.addFreshEntityWithPassengers(var5);
        }
    }

    private EntityHorseAbstract createHorse(DifficultyDamageScaler var0) {
        EntityHorseSkeleton var1 = EntityTypes.SKELETON_HORSE.create(this.horse.level);
        var1.finalizeSpawn((WorldServer)this.horse.level, var0, EnumMobSpawn.TRIGGERED, null, null);
        var1.setPos(this.horse.getX(), this.horse.getY(), this.horse.getZ());
        var1.invulnerableTime = 60;
        var1.setPersistenceRequired();
        var1.setTamed(true);
        var1.setAge(0);
        return var1;
    }

    private EntitySkeleton createSkeleton(DifficultyDamageScaler var0, EntityHorseAbstract var1) {
        EntitySkeleton var2 = EntityTypes.SKELETON.create(var1.level);
        var2.finalizeSpawn((WorldServer)var1.level, var0, EnumMobSpawn.TRIGGERED, null, null);
        var2.setPos(var1.getX(), var1.getY(), var1.getZ());
        var2.invulnerableTime = 60;
        var2.setPersistenceRequired();
        if (var2.getItemBySlot(EnumItemSlot.HEAD).isEmpty()) {
            var2.setItemSlot(EnumItemSlot.HEAD, new ItemStack(Items.IRON_HELMET));
        }
        var2.setItemSlot(EnumItemSlot.MAINHAND, EnchantmentManager.enchantItem(var2.getRandom(), this.disenchant(var2.getMainHandItem()), (int)(5.0f + var0.getSpecialMultiplier() * (float)var2.getRandom().nextInt(18)), false));
        var2.setItemSlot(EnumItemSlot.HEAD, EnchantmentManager.enchantItem(var2.getRandom(), this.disenchant(var2.getItemBySlot(EnumItemSlot.HEAD)), (int)(5.0f + var0.getSpecialMultiplier() * (float)var2.getRandom().nextInt(18)), false));
        return var2;
    }

    private ItemStack disenchant(ItemStack var0) {
        var0.removeTagKey("Enchantments");
        return var0;
    }
}

