/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;

public class EntityTropicalFish
extends EntityFishSchool {
    public static final String BUCKET_VARIANT_TAG = "BucketVariantTag";
    private static final DataWatcherObject<Integer> DATA_ID_TYPE_VARIANT = DataWatcher.defineId(EntityTropicalFish.class, DataWatcherRegistry.INT);
    public static final int BASE_SMALL = 0;
    public static final int BASE_LARGE = 1;
    private static final int BASES = 2;
    private static final MinecraftKey[] BASE_TEXTURE_LOCATIONS = new MinecraftKey[]{new MinecraftKey("textures/entity/fish/tropical_a.png"), new MinecraftKey("textures/entity/fish/tropical_b.png")};
    private static final MinecraftKey[] PATTERN_A_TEXTURE_LOCATIONS = new MinecraftKey[]{new MinecraftKey("textures/entity/fish/tropical_a_pattern_1.png"), new MinecraftKey("textures/entity/fish/tropical_a_pattern_2.png"), new MinecraftKey("textures/entity/fish/tropical_a_pattern_3.png"), new MinecraftKey("textures/entity/fish/tropical_a_pattern_4.png"), new MinecraftKey("textures/entity/fish/tropical_a_pattern_5.png"), new MinecraftKey("textures/entity/fish/tropical_a_pattern_6.png")};
    private static final MinecraftKey[] PATTERN_B_TEXTURE_LOCATIONS = new MinecraftKey[]{new MinecraftKey("textures/entity/fish/tropical_b_pattern_1.png"), new MinecraftKey("textures/entity/fish/tropical_b_pattern_2.png"), new MinecraftKey("textures/entity/fish/tropical_b_pattern_3.png"), new MinecraftKey("textures/entity/fish/tropical_b_pattern_4.png"), new MinecraftKey("textures/entity/fish/tropical_b_pattern_5.png"), new MinecraftKey("textures/entity/fish/tropical_b_pattern_6.png")};
    private static final int PATTERNS = 6;
    private static final int COLORS = 15;
    public static final int[] COMMON_VARIANTS = new int[]{EntityTropicalFish.calculateVariant(Variant.STRIPEY, EnumColor.ORANGE, EnumColor.GRAY), EntityTropicalFish.calculateVariant(Variant.FLOPPER, EnumColor.GRAY, EnumColor.GRAY), EntityTropicalFish.calculateVariant(Variant.FLOPPER, EnumColor.GRAY, EnumColor.BLUE), EntityTropicalFish.calculateVariant(Variant.CLAYFISH, EnumColor.WHITE, EnumColor.GRAY), EntityTropicalFish.calculateVariant(Variant.SUNSTREAK, EnumColor.BLUE, EnumColor.GRAY), EntityTropicalFish.calculateVariant(Variant.KOB, EnumColor.ORANGE, EnumColor.WHITE), EntityTropicalFish.calculateVariant(Variant.SPOTTY, EnumColor.PINK, EnumColor.LIGHT_BLUE), EntityTropicalFish.calculateVariant(Variant.BLOCKFISH, EnumColor.PURPLE, EnumColor.YELLOW), EntityTropicalFish.calculateVariant(Variant.CLAYFISH, EnumColor.WHITE, EnumColor.RED), EntityTropicalFish.calculateVariant(Variant.SPOTTY, EnumColor.WHITE, EnumColor.YELLOW), EntityTropicalFish.calculateVariant(Variant.GLITTER, EnumColor.WHITE, EnumColor.GRAY), EntityTropicalFish.calculateVariant(Variant.CLAYFISH, EnumColor.WHITE, EnumColor.ORANGE), EntityTropicalFish.calculateVariant(Variant.DASHER, EnumColor.CYAN, EnumColor.PINK), EntityTropicalFish.calculateVariant(Variant.BRINELY, EnumColor.LIME, EnumColor.LIGHT_BLUE), EntityTropicalFish.calculateVariant(Variant.BETTY, EnumColor.RED, EnumColor.WHITE), EntityTropicalFish.calculateVariant(Variant.SNOOPER, EnumColor.GRAY, EnumColor.RED), EntityTropicalFish.calculateVariant(Variant.BLOCKFISH, EnumColor.RED, EnumColor.WHITE), EntityTropicalFish.calculateVariant(Variant.FLOPPER, EnumColor.WHITE, EnumColor.YELLOW), EntityTropicalFish.calculateVariant(Variant.KOB, EnumColor.RED, EnumColor.WHITE), EntityTropicalFish.calculateVariant(Variant.SUNSTREAK, EnumColor.GRAY, EnumColor.WHITE), EntityTropicalFish.calculateVariant(Variant.DASHER, EnumColor.CYAN, EnumColor.YELLOW), EntityTropicalFish.calculateVariant(Variant.FLOPPER, EnumColor.YELLOW, EnumColor.YELLOW)};
    private boolean isSchool = true;

    private static int calculateVariant(Variant var0, EnumColor var1, EnumColor var2) {
        return var0.getBase() & 0xFF | (var0.getIndex() & 0xFF) << 8 | (var1.getId() & 0xFF) << 16 | (var2.getId() & 0xFF) << 24;
    }

    public EntityTropicalFish(EntityTypes<? extends EntityTropicalFish> var0, World var1) {
        super((EntityTypes<? extends EntityFishSchool>)var0, var1);
    }

    public static String getPredefinedName(int var0) {
        return "entity.minecraft.tropical_fish.predefined." + var0;
    }

    public static EnumColor getBaseColor(int var0) {
        return EnumColor.byId(EntityTropicalFish.getBaseColorIdx(var0));
    }

    public static EnumColor getPatternColor(int var0) {
        return EnumColor.byId(EntityTropicalFish.getPatternColorIdx(var0));
    }

    public static String getFishTypeName(int var0) {
        int var1 = EntityTropicalFish.getBaseVariant(var0);
        int var2 = EntityTropicalFish.getPatternVariant(var0);
        return "entity.minecraft.tropical_fish.type." + Variant.getPatternName(var1, var2);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_ID_TYPE_VARIANT, 0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Variant", this.getVariant());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setVariant(var0.getInt("Variant"));
    }

    public void setVariant(int var0) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, var0);
    }

    @Override
    public boolean isMaxGroupSizeReached(int var0) {
        return !this.isSchool;
    }

    public int getVariant() {
        return this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void saveToBucketTag(ItemStack var0) {
        super.saveToBucketTag(var0);
        NBTTagCompound var1 = var0.getOrCreateTag();
        var1.putInt(BUCKET_VARIANT_TAG, this.getVariant());
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack(Items.TROPICAL_FISH_BUCKET);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.TROPICAL_FISH_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.TROPICAL_FISH_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.TROPICAL_FISH_HURT;
    }

    @Override
    protected SoundEffect getFlopSound() {
        return SoundEffects.TROPICAL_FISH_FLOP;
    }

    private static int getBaseColorIdx(int var0) {
        return (var0 & 0xFF0000) >> 16;
    }

    public float[] getBaseColor() {
        return EnumColor.byId(EntityTropicalFish.getBaseColorIdx(this.getVariant())).getTextureDiffuseColors();
    }

    private static int getPatternColorIdx(int var0) {
        return (var0 & 0xFF000000) >> 24;
    }

    public float[] getPatternColor() {
        return EnumColor.byId(EntityTropicalFish.getPatternColorIdx(this.getVariant())).getTextureDiffuseColors();
    }

    public static int getBaseVariant(int var0) {
        return Math.min(var0 & 0xFF, 1);
    }

    public int getBaseVariant() {
        return EntityTropicalFish.getBaseVariant(this.getVariant());
    }

    private static int getPatternVariant(int var0) {
        return Math.min((var0 & 0xFF00) >> 8, 5);
    }

    public MinecraftKey getPatternTextureLocation() {
        if (EntityTropicalFish.getBaseVariant(this.getVariant()) == 0) {
            return PATTERN_A_TEXTURE_LOCATIONS[EntityTropicalFish.getPatternVariant(this.getVariant())];
        }
        return PATTERN_B_TEXTURE_LOCATIONS[EntityTropicalFish.getPatternVariant(this.getVariant())];
    }

    public MinecraftKey getBaseTextureLocation() {
        return BASE_TEXTURE_LOCATIONS[EntityTropicalFish.getBaseVariant(this.getVariant())];
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        int var8;
        int var7;
        int var6;
        int var5;
        var3 = super.finalizeSpawn(var0, var1, var2, var3, var4);
        if (var2 == EnumMobSpawn.BUCKET && var4 != null && var4.contains(BUCKET_VARIANT_TAG, 3)) {
            this.setVariant(var4.getInt(BUCKET_VARIANT_TAG));
            return var3;
        }
        if (var3 instanceof b) {
            b var9 = (b)var3;
            var5 = var9.base;
            var6 = var9.pattern;
            var7 = var9.baseColor;
            var8 = var9.patternColor;
        } else if ((double)this.random.nextFloat() < 0.9) {
            int var9 = SystemUtils.getRandom(COMMON_VARIANTS, this.random);
            var5 = var9 & 0xFF;
            var6 = (var9 & 0xFF00) >> 8;
            var7 = (var9 & 0xFF0000) >> 16;
            var8 = (var9 & 0xFF000000) >> 24;
            var3 = new b(this, var5, var6, var7, var8);
        } else {
            this.isSchool = false;
            var5 = this.random.nextInt(2);
            var6 = this.random.nextInt(6);
            var7 = this.random.nextInt(15);
            var8 = this.random.nextInt(15);
        }
        this.setVariant(var5 | var6 << 8 | var7 << 16 | var8 << 24);
        return var3;
    }

    public static boolean checkTropicalFishSpawnRules(EntityTypes<EntityTropicalFish> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, Random var4) {
        return var1.getFluidState(var3.below()).is(TagsFluid.WATER) && var1.getBlockState(var3.above()).is(Blocks.WATER) && (var1.getBiome(var3).is(Biomes.LUSH_CAVES) || EntityWaterAnimal.checkSurfaceWaterAnimalSpawnRules(var0, var1, var2, var3, var4));
    }

    static final class Variant
    extends Enum<Variant> {
        public static final /* enum */ Variant KOB = new Variant(0, 0);
        public static final /* enum */ Variant SUNSTREAK = new Variant(0, 1);
        public static final /* enum */ Variant SNOOPER = new Variant(0, 2);
        public static final /* enum */ Variant DASHER = new Variant(0, 3);
        public static final /* enum */ Variant BRINELY = new Variant(0, 4);
        public static final /* enum */ Variant SPOTTY = new Variant(0, 5);
        public static final /* enum */ Variant FLOPPER = new Variant(1, 0);
        public static final /* enum */ Variant STRIPEY = new Variant(1, 1);
        public static final /* enum */ Variant GLITTER = new Variant(1, 2);
        public static final /* enum */ Variant BLOCKFISH = new Variant(1, 3);
        public static final /* enum */ Variant BETTY = new Variant(1, 4);
        public static final /* enum */ Variant CLAYFISH = new Variant(1, 5);
        private final int base;
        private final int index;
        private static final Variant[] VALUES;
        private static final /* synthetic */ Variant[] p;

        public static Variant[] values() {
            return (Variant[])p.clone();
        }

        public static Variant valueOf(String var0) {
            return Enum.valueOf(Variant.class, var0);
        }

        private Variant(int var2, int var3) {
            this.base = var2;
            this.index = var3;
        }

        public int getBase() {
            return this.base;
        }

        public int getIndex() {
            return this.index;
        }

        public static String getPatternName(int var0, int var1) {
            return VALUES[var1 + 6 * var0].getName();
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        private static /* synthetic */ Variant[] d() {
            return new Variant[]{KOB, SUNSTREAK, SNOOPER, DASHER, BRINELY, SPOTTY, FLOPPER, STRIPEY, GLITTER, BLOCKFISH, BETTY, CLAYFISH};
        }

        static {
            p = Variant.d();
            VALUES = Variant.values();
        }
    }

    static class b
    extends EntityFishSchool.a {
        final int base;
        final int pattern;
        final int baseColor;
        final int patternColor;

        b(EntityTropicalFish var0, int var1, int var2, int var3, int var4) {
            super(var0);
            this.base = var1;
            this.pattern = var2;
            this.baseColor = var3;
            this.patternColor = var4;
        }
    }
}

