/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;

public class TemptingSensor
extends Sensor<EntityCreature> {
    public static final int TEMPTATION_RANGE = 10;
    private static final PathfinderTargetCondition TEMPT_TARGETING = PathfinderTargetCondition.forNonCombat().range(10.0).ignoreLineOfSight();
    private final RecipeItemStack temptations;

    public TemptingSensor(RecipeItemStack var0) {
        this.temptations = var0;
    }

    @Override
    protected void doTick(WorldServer var0, EntityCreature var12) {
        BehaviorController<?> var2 = var12.getBrain();
        List var3 = var0.players().stream().filter(IEntitySelector.NO_SPECTATORS).filter(var1 -> TEMPT_TARGETING.test(var12, (EntityLiving)var1)).filter(var1 -> var12.closerThan((Entity)var1, 10.0)).filter(this::playerHoldingTemptation).sorted(Comparator.comparingDouble(var12::distanceToSqr)).collect(Collectors.toList());
        if (!var3.isEmpty()) {
            EntityHuman var4 = (EntityHuman)var3.get(0);
            var2.setMemory(MemoryModuleType.TEMPTING_PLAYER, var4);
        } else {
            var2.eraseMemory(MemoryModuleType.TEMPTING_PLAYER);
        }
    }

    private boolean playerHoldingTemptation(EntityHuman var0) {
        return this.isTemptation(var0.getMainHandItem()) || this.isTemptation(var0.getOffhandItem());
    }

    private boolean isTemptation(ItemStack var0) {
        return this.temptations.test(var0);
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.TEMPTING_PLAYER);
    }
}

