/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.pathfinder.PathEntity;

public class SensorNearestBed
extends Sensor<EntityInsentient> {
    private static final int CACHE_TIMEOUT = 40;
    private static final int BATCH_SIZE = 5;
    private static final int RATE = 20;
    private final Long2LongMap batchCache = new Long2LongOpenHashMap();
    private int triedCount;
    private long lastUpdate;

    public SensorNearestBed() {
        super(20);
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_BED);
    }

    @Override
    protected void doTick(WorldServer var02, EntityInsentient var1) {
        if (!var1.isBaby()) {
            return;
        }
        this.triedCount = 0;
        this.lastUpdate = var02.getGameTime() + (long)var02.getRandom().nextInt(20);
        VillagePlace var2 = var02.getPoiManager();
        Predicate<BlockPosition> var3 = var0 -> {
            long var1 = var0.asLong();
            if (this.batchCache.containsKey(var1)) {
                return false;
            }
            if (++this.triedCount >= 5) {
                return false;
            }
            this.batchCache.put(var1, this.lastUpdate + 40L);
            return true;
        };
        Stream<BlockPosition> var4 = var2.findAll(VillagePlaceType.HOME.getPredicate(), var3, var1.blockPosition(), 48, VillagePlace.Occupancy.ANY);
        PathEntity var5 = var1.getNavigation().createPath(var4, VillagePlaceType.HOME.getValidRange());
        if (var5 != null && var5.canReach()) {
            BlockPosition var6 = var5.getTarget();
            Optional<VillagePlaceType> var7 = var2.getType(var6);
            if (var7.isPresent()) {
                var1.getBrain().setMemory(MemoryModuleType.NEAREST_BED, var6);
            }
        } else if (this.triedCount < 5) {
            this.batchCache.long2LongEntrySet().removeIf(var0 -> var0.getLongValue() < this.lastUpdate);
        }
    }
}

